/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import us.ihmc.euclid.interfaces.GeometryObject;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameSphere3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameSphere3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameFactories;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameShapeIOTools;
import us.ihmc.euclid.shape.primitives.interfaces.Sphere3DReadOnly;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;

public class FrameSphere3D
implements FrameSphere3DBasics,
GeometryObject<FrameSphere3D> {
    private ReferenceFrame referenceFrame;
    private final FixedFramePoint3DBasics position = EuclidFrameFactories.newFixedFramePoint3DBasics((ReferenceFrameHolder)this);
    private double radius;

    public FrameSphere3D() {
        this(ReferenceFrame.getWorldFrame());
    }

    public FrameSphere3D(ReferenceFrame referenceFrame) {
        this(referenceFrame, 1.0);
    }

    public FrameSphere3D(ReferenceFrame referenceFrame, double radius) {
        this.setReferenceFrame(referenceFrame);
        this.setRadius(radius);
    }

    public FrameSphere3D(ReferenceFrame referenceFrame, Point3DReadOnly center, double radius) {
        this.setIncludingFrame(referenceFrame, center, radius);
    }

    public FrameSphere3D(FramePoint3DReadOnly center, double radius) {
        this.setIncludingFrame(center, radius);
    }

    public FrameSphere3D(ReferenceFrame referenceFrame, double centerX, double centerY, double centerZ, double radius) {
        this.setIncludingFrame(referenceFrame, centerX, centerY, centerZ, radius);
    }

    public FrameSphere3D(ReferenceFrame referenceFrame, Sphere3DReadOnly other) {
        this.setIncludingFrame(referenceFrame, other);
    }

    public FrameSphere3D(FrameSphere3DReadOnly other) {
        this.setIncludingFrame(other);
    }

    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    @Override
    public FixedFramePoint3DBasics getPosition() {
        return this.position;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    public void setRadius(double radius) {
        if (radius < 0.0) {
            throw new IllegalArgumentException("The radius of a Sphere 3D cannot be negative.");
        }
        this.radius = radius;
    }

    @Override
    public FrameSphere3D copy() {
        return new FrameSphere3D(this);
    }

    public void set(FrameSphere3D other) {
        FrameSphere3DBasics.super.set(other);
    }

    public boolean epsilonEquals(FrameSphere3D other, double epsilon) {
        return FrameSphere3DBasics.super.epsilonEquals((FrameSphere3DReadOnly)other, epsilon);
    }

    public boolean geometricallyEquals(FrameSphere3D other, double epsilon) {
        return FrameSphere3DBasics.super.geometricallyEquals((FrameSphere3DReadOnly)other, epsilon);
    }

    public boolean equals(Object object) {
        if (object instanceof FrameSphere3DReadOnly) {
            return FrameSphere3DBasics.super.equals((FrameSphere3DReadOnly)object);
        }
        return false;
    }

    public int hashCode() {
        long hash = EuclidHashCodeTools.addToHashCode((long)this.position.hashCode(), (double)this.radius);
        return EuclidHashCodeTools.toIntHashCode((long)hash);
    }

    public String toString() {
        return EuclidFrameShapeIOTools.getFrameSphere3DString(this);
    }
}

