/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.DoubleSupplier;
import java.util.stream.Collectors;
import us.ihmc.euclid.referenceFrame.FrameRamp3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameBoundingBox3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameShape3DPoseBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameRamp3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameRampPolytope3DView;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.referenceFrame.polytope.interfaces.FrameFace3DReadOnly;
import us.ihmc.euclid.referenceFrame.polytope.interfaces.FrameHalfEdge3DReadOnly;
import us.ihmc.euclid.referenceFrame.polytope.interfaces.FrameVertex3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameFactories;
import us.ihmc.euclid.shape.convexPolytope.impl.AbstractFace3D;
import us.ihmc.euclid.shape.convexPolytope.impl.AbstractHalfEdge3D;
import us.ihmc.euclid.shape.convexPolytope.impl.AbstractVertex3D;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DChangeListener;
import us.ihmc.euclid.tools.EuclidCoreFactories;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

class FrameRampPolytope3D
implements FrameRampPolytope3DView {
    private final FrameRamp3D ramp3D;
    private final Face rampFace;
    private final Face xMaxFace;
    private final Face yMinFace;
    private final Face yMaxFace;
    private final Face zMinFace;
    private final List<Face> faces;
    private final List<HalfEdge> edges;
    private final List<Vertex> vertices;

    FrameRampPolytope3D(FrameRamp3D ramp3D) {
        this.ramp3D = ramp3D;
        DoubleSupplier xMin = () -> 0.0;
        DoubleSupplier yMin = () -> -0.5 * ramp3D.getSizeY();
        DoubleSupplier zMin = () -> 0.0;
        DoubleSupplier xMax = () -> ramp3D.getSizeX();
        DoubleSupplier yMax = () -> 0.5 * ramp3D.getSizeY();
        DoubleSupplier zMax = () -> ramp3D.getSizeZ();
        Vertex v0 = new Vertex(xMin, yMax, zMin);
        Vertex v1 = new Vertex(xMax, yMax, zMax);
        Vertex v2 = new Vertex(xMax, yMin, zMax);
        Vertex v3 = new Vertex(xMin, yMin, zMin);
        Vertex v4 = new Vertex(xMax, yMax, zMin);
        Vertex v5 = new Vertex(xMax, yMin, zMin);
        HalfEdge rampE0 = new HalfEdge(v0, v1);
        HalfEdge rampE1 = new HalfEdge(v1, v2);
        HalfEdge rampE2 = new HalfEdge(v2, v3);
        HalfEdge rampE3 = new HalfEdge(v3, v0);
        HalfEdge yMinE0 = new HalfEdge(v3, v2);
        HalfEdge yMinE1 = new HalfEdge(v2, v5);
        HalfEdge yMinE2 = new HalfEdge(v5, v3);
        HalfEdge yMaxE0 = new HalfEdge(v0, v4);
        HalfEdge yMaxE1 = new HalfEdge(v4, v1);
        HalfEdge yMaxE2 = new HalfEdge(v1, v0);
        HalfEdge xMaxE0 = new HalfEdge(v1, v4);
        HalfEdge xMaxE1 = new HalfEdge(v4, v5);
        HalfEdge xMaxE2 = new HalfEdge(v5, v2);
        HalfEdge xMaxE3 = new HalfEdge(v2, v1);
        HalfEdge zMinE0 = new HalfEdge(v0, v3);
        HalfEdge zMinE1 = new HalfEdge(v3, v5);
        HalfEdge zMinE2 = new HalfEdge(v5, v4);
        HalfEdge zMinE3 = new HalfEdge(v4, v0);
        DoubleSupplier slopeFaceAreaSupplier = () -> ramp3D.getSizeY() * ramp3D.getRampLength();
        DoubleSupplier xFaceAreaSupplier = () -> ramp3D.getSizeY() * ramp3D.getSizeZ();
        DoubleSupplier yFaceAreaSupplier = () -> 0.5 * ramp3D.getSizeX() * ramp3D.getSizeZ();
        DoubleSupplier zFaceAreaSupplier = () -> ramp3D.getSizeX() * ramp3D.getSizeY();
        FixedFrameShape3DPoseBasics pose = ramp3D.getPose();
        this.rampFace = new Face("ramp", (Vector3DReadOnly)ramp3D.getRampSurfaceNormal(), slopeFaceAreaSupplier, new HalfEdge[]{rampE0, rampE1, rampE2, rampE3});
        this.yMinFace = new Face("y-min", EuclidCoreFactories.newNegativeLinkedVector3D((Vector3DReadOnly)pose.getYAxis()), yFaceAreaSupplier, new HalfEdge[]{yMinE0, yMinE1, yMinE2});
        this.zMinFace = new Face("z-min", EuclidCoreFactories.newNegativeLinkedVector3D((Vector3DReadOnly)pose.getZAxis()), zFaceAreaSupplier, new HalfEdge[]{zMinE0, zMinE1, zMinE2, zMinE3});
        this.xMaxFace = new Face("x-max", (Vector3DReadOnly)pose.getXAxis(), xFaceAreaSupplier, new HalfEdge[]{xMaxE0, xMaxE1, xMaxE2, xMaxE3});
        this.yMaxFace = new Face("y-max", (Vector3DReadOnly)pose.getYAxis(), yFaceAreaSupplier, new HalfEdge[]{yMaxE0, yMaxE1, yMaxE2});
        this.faces = Collections.unmodifiableList(Arrays.asList(this.rampFace, this.yMinFace, this.zMinFace, this.xMaxFace, this.yMaxFace));
        this.edges = Collections.unmodifiableList(this.faces.stream().flatMap(f -> f.getEdges().stream()).collect(Collectors.toList()));
        this.vertices = Collections.unmodifiableList(Arrays.asList(v0, v1, v2, v3, v4, v5));
        ramp3D.addChangeListeners(this.vertices);
        ramp3D.addChangeListeners(this.faces);
    }

    @Override
    public Face getRampFace() {
        return this.rampFace;
    }

    @Override
    public Face getYMinFace() {
        return this.yMinFace;
    }

    @Override
    public Face getZMinFace() {
        return this.zMinFace;
    }

    @Override
    public Face getXMaxFace() {
        return this.xMaxFace;
    }

    @Override
    public Face getYMaxFace() {
        return this.yMaxFace;
    }

    @Override
    public FrameRamp3DReadOnly getOwner() {
        return this.ramp3D;
    }

    public List<Face> getFaces() {
        return this.faces;
    }

    public List<HalfEdge> getHalfEdges() {
        return this.edges;
    }

    public List<Vertex> getVertices() {
        return this.vertices;
    }

    public ReferenceFrame getReferenceFrame() {
        return this.ramp3D.getReferenceFrame();
    }

    private class Vertex
    extends AbstractVertex3D<Vertex, HalfEdge, Face>
    implements FrameVertex3DReadOnly,
    Shape3DChangeListener {
        private final Point3DReadOnly positionLocal;
        private boolean dirty = true;

        private Vertex(DoubleSupplier xLocal, DoubleSupplier yLocal, DoubleSupplier zLocal) {
            this.positionLocal = EuclidCoreFactories.newLinkedPoint3DReadOnly((DoubleSupplier)xLocal, (DoubleSupplier)yLocal, (DoubleSupplier)zLocal);
        }

        public void changed() {
            this.dirty = true;
        }

        private void update() {
            if (this.dirty) {
                this.dirty = false;
                FrameRampPolytope3D.this.ramp3D.getPose().transform(this.positionLocal, (Point3DBasics)this);
            }
        }

        @Override
        public HalfEdge getEdgeTo(FrameVertex3DReadOnly destination) {
            return (HalfEdge)FrameVertex3DReadOnly.super.getEdgeTo(destination);
        }

        public double getX() {
            this.update();
            return super.getX();
        }

        public double getY() {
            this.update();
            return super.getY();
        }

        public double getZ() {
            this.update();
            return super.getZ();
        }

        public ReferenceFrame getReferenceFrame() {
            return FrameRampPolytope3D.this.ramp3D.getReferenceFrame();
        }
    }

    private class HalfEdge
    extends AbstractHalfEdge3D<Vertex, HalfEdge, Face>
    implements FrameHalfEdge3DReadOnly {
        private HalfEdge(Vertex origin, Vertex destination) {
            super((AbstractVertex3D)origin, (AbstractVertex3D)destination);
        }

        void findAndSetTwin() {
            HalfEdge edgeTo = ((Vertex)this.getDestination()).getEdgeTo((FrameVertex3DReadOnly)this.getOrigin());
            if (edgeTo != null) {
                this.setTwin(edgeTo);
                ((HalfEdge)this.getTwin()).setTwin(this);
            }
        }

        @Override
        public Vertex getFirstEndpoint() {
            return (Vertex)this.getOrigin();
        }

        @Override
        public Vertex getSecondEndpoint() {
            return (Vertex)this.getDestination();
        }

        public ReferenceFrame getReferenceFrame() {
            return FrameRampPolytope3D.this.ramp3D.getReferenceFrame();
        }
    }

    private class Face
    extends AbstractFace3D<Vertex, HalfEdge, Face>
    implements FrameFace3DReadOnly,
    Shape3DChangeListener {
        private final String name;
        private final FixedFrameBoundingBox3DBasics boundingBox;
        private final FixedFramePoint3DBasics centroid;
        private final Vector3DReadOnly normalLocal;
        private final FixedFrameVector3DBasics normal;
        private final DoubleSupplier areaSupplier;
        private boolean isBoundingBoxDirty;
        private boolean isCentroidDirty;
        private boolean isNormalDirty;

        private Face(String name, Vector3DReadOnly normalLocal, DoubleSupplier areaSupplier, HalfEdge ... edges) {
            super(null, 0.0);
            this.boundingBox = EuclidFrameFactories.newObservableFixedFrameBoundingBox3DBasics((ReferenceFrameHolder)this, null, (axis, bound) -> this.updateBoundingBox());
            this.centroid = EuclidFrameFactories.newObservableFixedFramePoint3DBasics((ReferenceFrameHolder)this, null, axis -> this.updateCentroidAndArea());
            this.normal = EuclidFrameFactories.newObservableFixedFrameVector3DBasics((ReferenceFrameHolder)this, null, axis -> this.updateNormal());
            this.isBoundingBoxDirty = true;
            this.isCentroidDirty = true;
            this.isNormalDirty = true;
            this.name = name;
            this.normalLocal = normalLocal;
            this.areaSupplier = areaSupplier;
            this.initialize(Arrays.asList(edges), normalLocal);
            for (HalfEdge edge : edges) {
                edge.findAndSetTwin();
            }
        }

        public void changed() {
            this.isBoundingBoxDirty = true;
            this.isCentroidDirty = true;
            this.isNormalDirty = true;
        }

        public void updateBoundingBox() {
            if (this.isBoundingBoxDirty) {
                this.isBoundingBoxDirty = false;
                super.updateBoundingBox();
            }
        }

        public void updateCentroidAndArea() {
            if (this.isCentroidDirty) {
                this.isCentroidDirty = false;
                this.centroid.setToZero();
                for (int i = 0; i < this.getNumberOfEdges(); ++i) {
                    this.centroid.add((FrameTuple3DReadOnly)this.getVertex(i));
                }
                this.centroid.scale(1.0 / (double)this.getNumberOfEdges());
            }
        }

        public void updateNormal() {
            if (this.isNormalDirty) {
                this.isNormalDirty = false;
                this.normal.set((Tuple3DReadOnly)this.normalLocal);
            }
        }

        public FixedFramePoint3DBasics getCentroid() {
            return this.centroid;
        }

        public FixedFrameVector3DBasics getNormal() {
            return this.normal;
        }

        public double getArea() {
            return this.areaSupplier.getAsDouble();
        }

        public FixedFrameBoundingBox3DBasics getBoundingBox() {
            return this.boundingBox;
        }

        public ReferenceFrame getReferenceFrame() {
            return FrameRampPolytope3D.this.ramp3D.getReferenceFrame();
        }

        public String toString() {
            return "Ramp3D Face " + this.name + " " + super.toString();
        }
    }
}

