/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.tools;

import us.ihmc.euclid.referenceFrame.collision.interfaces.EuclidFrameShape3DCollisionResultReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameBox3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameCapsule3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameCylinder3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameEllipsoid3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePointShape3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameRamp3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameSphere3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.polytope.interfaces.FrameConvexPolytope3DReadOnly;
import us.ihmc.euclid.referenceFrame.polytope.interfaces.FrameFace3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameShapeIOTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class EuclidFrameShapeTestTools {
    private static final String DEFAULT_FORMAT = EuclidCoreTestTools.DEFAULT_FORMAT;

    private EuclidFrameShapeTestTools() {
    }

    public static void assertFrameBox3DEquals(FrameBox3DReadOnly expected, FrameBox3DReadOnly actual, double epsilon) {
        EuclidFrameShapeTestTools.assertFrameBox3DEquals(null, expected, actual, epsilon);
    }

    public static void assertFrameBox3DEquals(String messagePrefix, FrameBox3DReadOnly expected, FrameBox3DReadOnly actual, double epsilon) {
        EuclidFrameShapeTestTools.assertFrameBox3DEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertFrameBox3DEquals(String messagePrefix, FrameBox3DReadOnly expected, FrameBox3DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidFrameShapeTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.epsilonEquals(actual, epsilon)) {
            EuclidFrameShapeTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertFrameBox3DGeometricallyEquals(FrameBox3DReadOnly expected, FrameBox3DReadOnly actual, double epsilon) {
        EuclidFrameShapeTestTools.assertFrameBox3DGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertFrameBox3DGeometricallyEquals(String messagePrefix, FrameBox3DReadOnly expected, FrameBox3DReadOnly actual, double epsilon) {
        EuclidFrameShapeTestTools.assertFrameBox3DGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertFrameBox3DGeometricallyEquals(String messagePrefix, FrameBox3DReadOnly expected, FrameBox3DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidFrameShapeTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.geometricallyEquals(actual, epsilon)) {
            EuclidFrameShapeTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertFrameCapsule3DEquals(FrameCapsule3DReadOnly expected, FrameCapsule3DReadOnly actual, double epsilon) {
        EuclidFrameShapeTestTools.assertFrameCapsule3DEquals(null, expected, actual, epsilon);
    }

    public static void assertFrameCapsule3DEquals(String messagePrefix, FrameCapsule3DReadOnly expected, FrameCapsule3DReadOnly actual, double epsilon) {
        EuclidFrameShapeTestTools.assertFrameCapsule3DEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertFrameCapsule3DEquals(String messagePrefix, FrameCapsule3DReadOnly expected, FrameCapsule3DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidFrameShapeTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.epsilonEquals(actual, epsilon)) {
            EuclidFrameShapeTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertFrameCapsule3DGeometricallyEquals(FrameCapsule3DReadOnly expected, FrameCapsule3DReadOnly actual, double epsilon) {
        EuclidFrameShapeTestTools.assertFrameCapsule3DGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertFrameCapsule3DGeometricallyEquals(String messagePrefix, FrameCapsule3DReadOnly expected, FrameCapsule3DReadOnly actual, double epsilon) {
        EuclidFrameShapeTestTools.assertFrameCapsule3DGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertFrameCapsule3DGeometricallyEquals(String messagePrefix, FrameCapsule3DReadOnly expected, FrameCapsule3DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidFrameShapeTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.geometricallyEquals(actual, epsilon)) {
            EuclidFrameShapeTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertFrameCylinder3DEquals(FrameCylinder3DReadOnly expected, FrameCylinder3DReadOnly actual, double epsilon) {
        EuclidFrameShapeTestTools.assertFrameCylinder3DEquals(null, expected, actual, epsilon);
    }

    public static void assertFrameCylinder3DEquals(String messagePrefix, FrameCylinder3DReadOnly expected, FrameCylinder3DReadOnly actual, double epsilon) {
        EuclidFrameShapeTestTools.assertFrameCylinder3DEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertFrameCylinder3DEquals(String messagePrefix, FrameCylinder3DReadOnly expected, FrameCylinder3DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidFrameShapeTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.epsilonEquals(actual, epsilon)) {
            EuclidFrameShapeTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertFrameCylinder3DGeometricallyEquals(FrameCylinder3DReadOnly expected, FrameCylinder3DReadOnly actual, double epsilon) {
        EuclidFrameShapeTestTools.assertFrameCylinder3DGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertFrameCylinder3DGeometricallyEquals(String messagePrefix, FrameCylinder3DReadOnly expected, FrameCylinder3DReadOnly actual, double epsilon) {
        EuclidFrameShapeTestTools.assertFrameCylinder3DGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertFrameCylinder3DGeometricallyEquals(String messagePrefix, FrameCylinder3DReadOnly expected, FrameCylinder3DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidFrameShapeTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.geometricallyEquals(actual, epsilon)) {
            EuclidFrameShapeTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertFrameEllipsoid3DEquals(FrameEllipsoid3DReadOnly expected, FrameEllipsoid3DReadOnly actual, double epsilon) {
        EuclidFrameShapeTestTools.assertFrameEllipsoid3DEquals(null, expected, actual, epsilon);
    }

    public static void assertFrameEllipsoid3DEquals(String messagePrefix, FrameEllipsoid3DReadOnly expected, FrameEllipsoid3DReadOnly actual, double epsilon) {
        EuclidFrameShapeTestTools.assertFrameEllipsoid3DEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertFrameEllipsoid3DEquals(String messagePrefix, FrameEllipsoid3DReadOnly expected, FrameEllipsoid3DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidFrameShapeTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.epsilonEquals(actual, epsilon)) {
            EuclidFrameShapeTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertFrameEllipsoid3DGeometricallyEquals(FrameEllipsoid3DReadOnly expected, FrameEllipsoid3DReadOnly actual, double epsilon) {
        EuclidFrameShapeTestTools.assertEllipsoid3DGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertEllipsoid3DGeometricallyEquals(String messagePrefix, FrameEllipsoid3DReadOnly expected, FrameEllipsoid3DReadOnly actual, double epsilon) {
        EuclidFrameShapeTestTools.assertFrameEllipsoid3DGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertFrameEllipsoid3DGeometricallyEquals(String messagePrefix, FrameEllipsoid3DReadOnly expected, FrameEllipsoid3DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidFrameShapeTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.geometricallyEquals(actual, epsilon)) {
            EuclidFrameShapeTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertFramePointShape3DEquals(FramePointShape3DReadOnly expected, FramePointShape3DReadOnly actual, double epsilon) {
        EuclidFrameShapeTestTools.assertFramePointShape3DEquals(null, expected, actual, epsilon);
    }

    public static void assertFramePointShape3DEquals(String messagePrefix, FramePointShape3DReadOnly expected, FramePointShape3DReadOnly actual, double epsilon) {
        EuclidFrameShapeTestTools.assertFramePointShape3DEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertFramePointShape3DEquals(String messagePrefix, FramePointShape3DReadOnly expected, FramePointShape3DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidFrameShapeTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.epsilonEquals((FrameTuple3DReadOnly)actual, epsilon)) {
            EuclidFrameShapeTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertFramePointShape3DGeometricallyEquals(FramePointShape3DReadOnly expected, FramePointShape3DReadOnly actual, double epsilon) {
        EuclidFrameShapeTestTools.assertFramePointShape3DGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertFramePointShape3DGeometricallyEquals(String messagePrefix, FramePointShape3DReadOnly expected, FramePointShape3DReadOnly actual, double epsilon) {
        EuclidFrameShapeTestTools.assertFramePointShape3DGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertFramePointShape3DGeometricallyEquals(String messagePrefix, FramePointShape3DReadOnly expected, FramePointShape3DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidFrameShapeTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.geometricallyEquals(actual, epsilon)) {
            EuclidFrameShapeTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertFrameRamp3DEquals(FrameRamp3DReadOnly expected, FrameRamp3DReadOnly actual, double epsilon) {
        EuclidFrameShapeTestTools.assertFrameRamp3DEquals(null, expected, actual, epsilon);
    }

    public static void assertFrameRamp3DEquals(String messagePrefix, FrameRamp3DReadOnly expected, FrameRamp3DReadOnly actual, double epsilon) {
        EuclidFrameShapeTestTools.assertFrameRamp3DEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertFrameRamp3DEquals(String messagePrefix, FrameRamp3DReadOnly expected, FrameRamp3DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidFrameShapeTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.epsilonEquals(actual, epsilon)) {
            EuclidFrameShapeTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertFrameRamp3DGeometricallyEquals(FrameRamp3DReadOnly expected, FrameRamp3DReadOnly actual, double epsilon) {
        EuclidFrameShapeTestTools.assertFrameRamp3DGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertFrameRamp3DGeometricallyEquals(String messagePrefix, FrameRamp3DReadOnly expected, FrameRamp3DReadOnly actual, double epsilon) {
        EuclidFrameShapeTestTools.assertFrameRamp3DGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertFrameRamp3DGeometricallyEquals(String messagePrefix, FrameRamp3DReadOnly expected, FrameRamp3DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidFrameShapeTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.geometricallyEquals(actual, epsilon)) {
            EuclidFrameShapeTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertFrameSphere3DEquals(FrameSphere3DReadOnly expected, FrameSphere3DReadOnly actual, double epsilon) {
        EuclidFrameShapeTestTools.assertFrameSphere3DEquals(null, expected, actual, epsilon);
    }

    public static void assertFrameSphere3DEquals(String messagePrefix, FrameSphere3DReadOnly expected, FrameSphere3DReadOnly actual, double epsilon) {
        EuclidFrameShapeTestTools.assertFrameSphere3DEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertFrameSphere3DEquals(String messagePrefix, FrameSphere3DReadOnly expected, FrameSphere3DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidFrameShapeTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.epsilonEquals(actual, epsilon)) {
            EuclidFrameShapeTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertFrameSphere3DGeometricallyEquals(FrameSphere3DReadOnly expected, FrameSphere3DReadOnly actual, double epsilon) {
        EuclidFrameShapeTestTools.assertFrameSphere3DGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertFrameSphere3DGeometricallyEquals(String messagePrefix, FrameSphere3DReadOnly expected, FrameSphere3DReadOnly actual, double epsilon) {
        EuclidFrameShapeTestTools.assertFrameSphere3DGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertFrameSphere3DGeometricallyEquals(String messagePrefix, FrameSphere3DReadOnly expected, FrameSphere3DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidFrameShapeTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.geometricallyEquals(actual, epsilon)) {
            EuclidFrameShapeTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertEuclidFrameShape3DCollisionResultEquals(EuclidFrameShape3DCollisionResultReadOnly expected, EuclidFrameShape3DCollisionResultReadOnly actual, double epsilon) {
        EuclidFrameShapeTestTools.assertEuclidFrameShape3DCollisionResultEquals(null, expected, actual, epsilon);
    }

    public static void assertEuclidFrameShape3DCollisionResultEquals(String messagePrefix, EuclidFrameShape3DCollisionResultReadOnly expected, EuclidFrameShape3DCollisionResultReadOnly actual, double epsilon) {
        EuclidFrameShapeTestTools.assertEuclidFrameShape3DCollisionResultEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertEuclidFrameShape3DCollisionResultEquals(String messagePrefix, EuclidFrameShape3DCollisionResultReadOnly expected, EuclidFrameShape3DCollisionResultReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidFrameShapeTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.epsilonEquals(actual, epsilon)) {
            if (expected.areShapesColliding() != actual.areShapesColliding()) {
                EuclidFrameShapeTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
            } else {
                Vector3D differenceNormalOnA = new Vector3D();
                differenceNormalOnA.sub((Tuple3DReadOnly)expected.getNormalOnA(), (Tuple3DReadOnly)actual.getNormalOnA());
                Vector3D differenceNormalOnB = new Vector3D();
                differenceNormalOnB.sub((Tuple3DReadOnly)expected.getNormalOnB(), (Tuple3DReadOnly)actual.getNormalOnB());
                String difference = "[";
                difference = difference + "distance: " + Math.abs(expected.getSignedDistance() - actual.getSignedDistance());
                difference = difference + ", pointOnA: " + expected.getPointOnA().distance(actual.getPointOnA()) + ", normalOnA: " + differenceNormalOnA.length();
                difference = difference + ", pointOnB: " + expected.getPointOnB().distance(actual.getPointOnB()) + ", normalOnB: " + differenceNormalOnB.length();
                difference = difference + "]";
                EuclidFrameShapeTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format, difference);
            }
        }
    }

    public static void assertEuclidFrameShape3DCollisionResultGeometricallyEquals(EuclidFrameShape3DCollisionResultReadOnly expected, EuclidFrameShape3DCollisionResultReadOnly actual, double epsilon) {
        EuclidFrameShapeTestTools.assertEuclidFrameShape3DCollisionResultGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertEuclidFrameShape3DCollisionResultGeometricallyEquals(EuclidFrameShape3DCollisionResultReadOnly expected, EuclidFrameShape3DCollisionResultReadOnly actual, double distanceEpsilon, double pointTangentialEpsilon, double normalEpsilon) {
        EuclidFrameShapeTestTools.assertEuclidFrameShape3DCollisionResultGeometricallyEquals(null, expected, actual, distanceEpsilon, pointTangentialEpsilon, normalEpsilon, DEFAULT_FORMAT);
    }

    public static void assertEuclidFrameShape3DCollisionResultGeometricallyEquals(String messagePrefix, EuclidFrameShape3DCollisionResultReadOnly expected, EuclidFrameShape3DCollisionResultReadOnly actual, double epsilon) {
        EuclidFrameShapeTestTools.assertEuclidFrameShape3DCollisionResultGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertEuclidFrameShape3DCollisionResultGeometricallyEquals(String messagePrefix, EuclidFrameShape3DCollisionResultReadOnly expected, EuclidFrameShape3DCollisionResultReadOnly actual, double distanceEpsilon, double pointTangentialEpsilon, double normalEpsilon) {
        EuclidFrameShapeTestTools.assertEuclidFrameShape3DCollisionResultGeometricallyEquals(messagePrefix, expected, actual, distanceEpsilon, pointTangentialEpsilon, normalEpsilon, DEFAULT_FORMAT);
    }

    public static void assertEuclidFrameShape3DCollisionResultGeometricallyEquals(String messagePrefix, EuclidFrameShape3DCollisionResultReadOnly expected, EuclidFrameShape3DCollisionResultReadOnly actual, double epsilon, String format) {
        EuclidFrameShapeTestTools.assertEuclidFrameShape3DCollisionResultGeometricallyEquals(messagePrefix, expected, actual, epsilon, epsilon, epsilon, format);
    }

    public static void assertEuclidFrameShape3DCollisionResultGeometricallyEquals(String messagePrefix, EuclidFrameShape3DCollisionResultReadOnly expected, EuclidFrameShape3DCollisionResultReadOnly actual, double distanceEpsilon, double pointTangentialEpsilon, double normalEpsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidFrameShapeTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.geometricallyEquals(actual, distanceEpsilon, pointTangentialEpsilon, normalEpsilon)) {
            if (expected.areShapesColliding() != actual.areShapesColliding()) {
                EuclidFrameShapeTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
            } else {
                Vector3D differenceNormalOnA = new Vector3D();
                differenceNormalOnA.sub((Tuple3DReadOnly)expected.getNormalOnA(), (Tuple3DReadOnly)actual.getNormalOnA());
                Vector3D differenceNormalOnB = new Vector3D();
                differenceNormalOnB.sub((Tuple3DReadOnly)expected.getNormalOnB(), (Tuple3DReadOnly)actual.getNormalOnB());
                String difference = "[";
                difference = difference + "distance: " + Math.abs(expected.getSignedDistance() - actual.getSignedDistance());
                difference = difference + ", pointOnA: " + expected.getPointOnA().distance(actual.getPointOnA()) + ", normalOnA: " + differenceNormalOnA.length();
                difference = difference + ", pointOnB: " + expected.getPointOnB().distance(actual.getPointOnB()) + ", normalOnB: " + differenceNormalOnB.length();
                difference = difference + "]";
                EuclidFrameShapeTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format, difference);
            }
        }
    }

    public static void assertFrameFace3DEquals(FrameFace3DReadOnly expected, FrameFace3DReadOnly actual, double epsilon) {
        EuclidFrameShapeTestTools.assertFrameFace3DEquals(null, expected, actual, epsilon);
    }

    public static void assertFrameFace3DEquals(String messagePrefix, FrameFace3DReadOnly expected, FrameFace3DReadOnly actual, double epsilon) {
        EuclidFrameShapeTestTools.assertFrameFace3DEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertFrameFace3DEquals(String messagePrefix, FrameFace3DReadOnly expected, FrameFace3DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidFrameShapeTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.epsilonEquals(actual, epsilon)) {
            EuclidFrameShapeTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertFrameFace3DGeometricallyEquals(FrameFace3DReadOnly expected, FrameFace3DReadOnly actual, double epsilon) {
        EuclidFrameShapeTestTools.assertFrameFace3DGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertFrameFace3DGeometricallyEquals(String messagePrefix, FrameFace3DReadOnly expected, FrameFace3DReadOnly actual, double epsilon) {
        EuclidFrameShapeTestTools.assertFrameFace3DGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertFrameFace3DGeometricallyEquals(String messagePrefix, FrameFace3DReadOnly expected, FrameFace3DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidFrameShapeTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.geometricallyEquals(actual, epsilon)) {
            EuclidFrameShapeTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertFrameConvexPolytope3DEquals(FrameConvexPolytope3DReadOnly expected, FrameConvexPolytope3DReadOnly actual, double epsilon) {
        EuclidFrameShapeTestTools.assertFrameConvexPolytope3DEquals(null, expected, actual, epsilon);
    }

    public static void assertFrameConvexPolytope3DEquals(String messagePrefix, FrameConvexPolytope3DReadOnly expected, FrameConvexPolytope3DReadOnly actual, double epsilon) {
        EuclidFrameShapeTestTools.assertFrameConvexPolytope3DEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertFrameConvexPolytope3DEquals(String messagePrefix, FrameConvexPolytope3DReadOnly expected, FrameConvexPolytope3DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidFrameShapeTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.epsilonEquals(actual, epsilon)) {
            EuclidFrameShapeTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    public static void assertFrameConvexPolytope3DGeometricallyEquals(FrameConvexPolytope3DReadOnly expected, FrameConvexPolytope3DReadOnly actual, double epsilon) {
        EuclidFrameShapeTestTools.assertFrameConvexPolytope3DGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertFrameConvexPolytope3DGeometricallyEquals(String messagePrefix, FrameConvexPolytope3DReadOnly expected, FrameConvexPolytope3DReadOnly actual, double epsilon) {
        EuclidFrameShapeTestTools.assertFrameConvexPolytope3DGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertFrameConvexPolytope3DGeometricallyEquals(String messagePrefix, FrameConvexPolytope3DReadOnly expected, FrameConvexPolytope3DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidFrameShapeTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (!expected.geometricallyEquals(actual, epsilon)) {
            EuclidFrameShapeTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
    }

    private static void throwNotEqualAssertionError(String messagePrefix, FrameBox3DReadOnly expected, FrameBox3DReadOnly actual, String format) {
        String expectedAsString = EuclidFrameShapeIOTools.getFrameBox3DString(format, expected);
        String actualAsString = EuclidFrameShapeIOTools.getFrameBox3DString(format, actual);
        EuclidCoreTestTools.throwNotEqualAssertionError((String)messagePrefix, (String)expectedAsString, (String)actualAsString);
    }

    private static void throwNotEqualAssertionError(String messagePrefix, FrameCapsule3DReadOnly expected, FrameCapsule3DReadOnly actual, String format) {
        String expectedAsString = EuclidFrameShapeIOTools.getFrameCapsule3DString(format, expected);
        String actualAsString = EuclidFrameShapeIOTools.getFrameCapsule3DString(format, actual);
        EuclidCoreTestTools.throwNotEqualAssertionError((String)messagePrefix, (String)expectedAsString, (String)actualAsString);
    }

    private static void throwNotEqualAssertionError(String messagePrefix, FrameCylinder3DReadOnly expected, FrameCylinder3DReadOnly actual, String format) {
        String expectedAsString = EuclidFrameShapeIOTools.getFrameCylinder3DString(format, expected);
        String actualAsString = EuclidFrameShapeIOTools.getFrameCylinder3DString(format, actual);
        EuclidCoreTestTools.throwNotEqualAssertionError((String)messagePrefix, (String)expectedAsString, (String)actualAsString);
    }

    private static void throwNotEqualAssertionError(String messagePrefix, FrameEllipsoid3DReadOnly expected, FrameEllipsoid3DReadOnly actual, String format) {
        String expectedAsString = EuclidFrameShapeIOTools.getFrameEllipsoid3DString(format, expected);
        String actualAsString = EuclidFrameShapeIOTools.getFrameEllipsoid3DString(format, actual);
        EuclidCoreTestTools.throwNotEqualAssertionError((String)messagePrefix, (String)expectedAsString, (String)actualAsString);
    }

    private static void throwNotEqualAssertionError(String messagePrefix, FramePointShape3DReadOnly expected, FramePointShape3DReadOnly actual, String format) {
        String expectedAsString = EuclidFrameShapeIOTools.getFramePointShape3DString(format, expected);
        String actualAsString = EuclidFrameShapeIOTools.getFramePointShape3DString(format, actual);
        EuclidCoreTestTools.throwNotEqualAssertionError((String)messagePrefix, (String)expectedAsString, (String)actualAsString);
    }

    private static void throwNotEqualAssertionError(String messagePrefix, FrameRamp3DReadOnly expected, FrameRamp3DReadOnly actual, String format) {
        String expectedAsString = EuclidFrameShapeIOTools.getFrameRamp3DString(format, expected);
        String actualAsString = EuclidFrameShapeIOTools.getFrameRamp3DString(format, actual);
        EuclidCoreTestTools.throwNotEqualAssertionError((String)messagePrefix, (String)expectedAsString, (String)actualAsString);
    }

    private static void throwNotEqualAssertionError(String messagePrefix, FrameSphere3DReadOnly expected, FrameSphere3DReadOnly actual, String format) {
        String expectedAsString = EuclidFrameShapeIOTools.getFrameSphere3DString(format, expected);
        String actualAsString = EuclidFrameShapeIOTools.getFrameSphere3DString(format, actual);
        EuclidCoreTestTools.throwNotEqualAssertionError((String)messagePrefix, (String)expectedAsString, (String)actualAsString);
    }

    private static void throwNotEqualAssertionError(String messagePrefix, EuclidFrameShape3DCollisionResultReadOnly expected, EuclidFrameShape3DCollisionResultReadOnly actual, String format) {
        EuclidFrameShapeTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format, null);
    }

    private static void throwNotEqualAssertionError(String messagePrefix, EuclidFrameShape3DCollisionResultReadOnly expected, EuclidFrameShape3DCollisionResultReadOnly actual, String format, String differenceAsString) {
        String expectedAsString = EuclidFrameShapeIOTools.getEuclidFrameShape3DCollisionResultString(format, expected);
        String actualAsString = EuclidFrameShapeIOTools.getEuclidFrameShape3DCollisionResultString(format, actual);
        EuclidCoreTestTools.throwNotEqualAssertionError((String)messagePrefix, (String)expectedAsString, (String)actualAsString, (String)differenceAsString);
    }

    private static void throwNotEqualAssertionError(String messagePrefix, FrameFace3DReadOnly expected, FrameFace3DReadOnly actual, String format) {
        String expectedAsString = EuclidFrameShapeIOTools.getFrameFace3DString(format, expected);
        String actualAsString = EuclidFrameShapeIOTools.getFrameFace3DString(format, actual);
        EuclidCoreTestTools.throwNotEqualAssertionError((String)messagePrefix, (String)expectedAsString, (String)actualAsString);
    }

    private static void throwNotEqualAssertionError(String messagePrefix, FrameConvexPolytope3DReadOnly expected, FrameConvexPolytope3DReadOnly actual, String format) {
        String expectedAsString = EuclidFrameShapeIOTools.getFrameConvexPolytope3DString(format, expected);
        String actualAsString = EuclidFrameShapeIOTools.getFrameConvexPolytope3DString(format, actual);
        EuclidCoreTestTools.throwNotEqualAssertionError((String)messagePrefix, (String)expectedAsString, (String)actualAsString);
    }
}

