/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.polytope;

import java.util.Collection;
import us.ihmc.euclid.interfaces.Clearable;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameBoundingBox3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.referenceFrame.polytope.FrameHalfEdge3D;
import us.ihmc.euclid.referenceFrame.polytope.FrameVertex3D;
import us.ihmc.euclid.referenceFrame.polytope.interfaces.FrameFace3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameFactories;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameShapeIOTools;
import us.ihmc.euclid.shape.convexPolytope.impl.AbstractFace3D;
import us.ihmc.euclid.shape.convexPolytope.interfaces.HalfEdge3DFactory;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class FrameFace3D
extends AbstractFace3D<FrameVertex3D, FrameHalfEdge3D, FrameFace3D>
implements FrameFace3DReadOnly,
Clearable,
Transformable {
    private final ReferenceFrameHolder referenceFrameHolder;
    private final FixedFrameVector3DBasics normal = EuclidFrameFactories.newFixedFrameVector3DBasics((ReferenceFrameHolder)this);
    private final FixedFramePoint3DBasics centroid = EuclidFrameFactories.newFixedFramePoint3DBasics((ReferenceFrameHolder)this);
    private final FixedFrameBoundingBox3DBasics boundingBox = EuclidFrameFactories.newFixedFrameBoundingBox3DBasics((ReferenceFrameHolder)this);

    public FrameFace3D(ReferenceFrameHolder referenceFrameHolder, Vector3DReadOnly initialGuessNormal) {
        super(FrameFace3D.edgeFactory(referenceFrameHolder));
        this.referenceFrameHolder = referenceFrameHolder;
        this.initialize(initialGuessNormal);
    }

    public FrameFace3D(ReferenceFrameHolder referenceFrameHolder, Vector3DReadOnly initialGuessNormal, double constructionEpsilon) {
        super(FrameFace3D.edgeFactory(referenceFrameHolder), constructionEpsilon);
        this.referenceFrameHolder = referenceFrameHolder;
        this.initialize(initialGuessNormal);
    }

    public FrameFace3D(ReferenceFrameHolder referenceFrameHolder, Collection<FrameHalfEdge3D> faceEdges, FrameVector3DReadOnly normal, double constructionEpsilon) {
        super(FrameFace3D.edgeFactory(referenceFrameHolder), constructionEpsilon);
        this.referenceFrameHolder = referenceFrameHolder;
        this.initialize(faceEdges, (Vector3DReadOnly)normal);
    }

    private static HalfEdge3DFactory<FrameVertex3D, FrameHalfEdge3D> edgeFactory(ReferenceFrameHolder referenceFrameHolder) {
        return (origin, destination) -> new FrameHalfEdge3D(referenceFrameHolder, (FrameVertex3D)origin, (FrameVertex3D)destination);
    }

    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrameHolder.getReferenceFrame();
    }

    public FixedFramePoint3DBasics getCentroid() {
        return this.centroid;
    }

    public FixedFrameVector3DBasics getNormal() {
        return this.normal;
    }

    public FixedFrameBoundingBox3DBasics getBoundingBox() {
        return this.boundingBox;
    }

    public boolean equals(Object object) {
        if (object instanceof FrameFace3DReadOnly) {
            return this.equals((FrameFace3DReadOnly)object);
        }
        return false;
    }

    public String toString() {
        return EuclidFrameShapeIOTools.getFrameFace3DString(this);
    }
}

