/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.polytope;

import us.ihmc.euclid.geometry.interfaces.Vertex3DSupplier;
import us.ihmc.euclid.interfaces.GeometryObject;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameBoundingBox3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameShape3DPoseBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameChangeable;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex3DSupplier;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.referenceFrame.polytope.FrameFace3D;
import us.ihmc.euclid.referenceFrame.polytope.FrameHalfEdge3D;
import us.ihmc.euclid.referenceFrame.polytope.FrameVertex3D;
import us.ihmc.euclid.referenceFrame.polytope.interfaces.FrameConvexPolytope3DReadOnly;
import us.ihmc.euclid.referenceFrame.polytope.interfaces.FrameVertex3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameFactories;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameShapeIOTools;
import us.ihmc.euclid.shape.convexPolytope.impl.AbstractConvexPolytope3D;
import us.ihmc.euclid.shape.convexPolytope.interfaces.ConvexPolytope3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Face3DFactory;
import us.ihmc.euclid.shape.convexPolytope.interfaces.HalfEdge3DFactory;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Vertex3DFactory;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class FrameConvexPolytope3D
extends AbstractConvexPolytope3D<FrameVertex3D, FrameHalfEdge3D, FrameFace3D>
implements FrameConvexPolytope3DReadOnly,
FrameShape3DBasics,
FrameChangeable,
GeometryObject<FrameConvexPolytope3D> {
    private ReferenceFrame referenceFrame;
    private final FixedFramePoint3DBasics centroid = EuclidFrameFactories.newFixedFramePoint3DBasics((ReferenceFrameHolder)this);
    private final FixedFrameBoundingBox3DBasics boundingBox = EuclidFrameFactories.newFixedFrameBoundingBox3DBasics((ReferenceFrameHolder)this);
    private final RigidBodyTransform transformToDesiredFrame = new RigidBodyTransform();

    public FrameConvexPolytope3D() {
        this(ReferenceFrame.getWorldFrame());
    }

    public FrameConvexPolytope3D(ReferenceFrame referenceFrame) {
        this(referenceFrame, 1.0E-10);
    }

    public FrameConvexPolytope3D(ReferenceFrame referenceFrame, double constructionEpsilon) {
        super(constructionEpsilon);
        this.setFactories(FrameConvexPolytope3D.vertexFactory(this), FrameConvexPolytope3D.edgeFactory(this), FrameConvexPolytope3D.faceFactory(this));
        this.initialize();
        this.setReferenceFrame(referenceFrame);
    }

    public FrameConvexPolytope3D(ReferenceFrame referenceFrame, Vertex3DSupplier vertex3DSupplier) {
        this(referenceFrame, vertex3DSupplier, 1.0E-10);
    }

    public FrameConvexPolytope3D(FrameVertex3DSupplier vertex3DSupplier) {
        this(vertex3DSupplier.getReferenceFrame(), (Vertex3DSupplier)vertex3DSupplier);
    }

    public FrameConvexPolytope3D(ReferenceFrame referenceFrame, Vertex3DSupplier vertex3DSupplier, double constructionEpsilon) {
        this(referenceFrame, constructionEpsilon);
        this.addVertices(vertex3DSupplier);
    }

    public FrameConvexPolytope3D(FrameVertex3DSupplier vertex3DSupplier, double constructionEpsilon) {
        this(vertex3DSupplier.getReferenceFrame(), (Vertex3DSupplier)vertex3DSupplier, constructionEpsilon);
    }

    public FrameConvexPolytope3D(ReferenceFrame referenceFrame, ConvexPolytope3DReadOnly other) {
        this(referenceFrame, other.getConstructionEpsilon());
        this.set(other);
    }

    public FrameConvexPolytope3D(FrameConvexPolytope3DReadOnly other) {
        this(other.getReferenceFrame(), other);
    }

    private static Vertex3DFactory<FrameVertex3D> vertexFactory(ReferenceFrameHolder referenceFrameHolder) {
        return position -> new FrameVertex3D(referenceFrameHolder, position);
    }

    private static HalfEdge3DFactory<FrameVertex3D, FrameHalfEdge3D> edgeFactory(ReferenceFrameHolder referenceFrameHolder) {
        return (origin, destination) -> new FrameHalfEdge3D(referenceFrameHolder, (FrameVertex3D)origin, (FrameVertex3D)destination);
    }

    private static Face3DFactory<FrameFace3D> faceFactory(ReferenceFrameHolder referenceFrameHolder) {
        return (initialGuessNormal, constructionEpsilon) -> new FrameFace3D(referenceFrameHolder, initialGuessNormal, constructionEpsilon);
    }

    public void set(FrameConvexPolytope3D other) {
        this.set((FrameConvexPolytope3DReadOnly)other);
    }

    public void set(FrameConvexPolytope3DReadOnly other) {
        this.checkReferenceFrameMatch(other);
        super.set((ConvexPolytope3DReadOnly)other);
    }

    public void setIncludingFrame(FrameConvexPolytope3DReadOnly other) {
        this.setReferenceFrame(other.getReferenceFrame());
        super.set((ConvexPolytope3DReadOnly)other);
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    public void changeFrame(ReferenceFrame desiredFrame) {
        if (desiredFrame == this.referenceFrame) {
            return;
        }
        this.referenceFrame.getTransformToDesiredFrame(this.transformToDesiredFrame, desiredFrame);
        this.applyTransform((Transform)this.transformToDesiredFrame);
        this.referenceFrame = desiredFrame;
    }

    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public FixedFramePoint3DBasics getCentroid() {
        return this.centroid;
    }

    public FixedFrameBoundingBox3DBasics getBoundingBox() {
        return this.boundingBox;
    }

    @Override
    public FrameVertex3DReadOnly getSupportingVertex(Vector3DReadOnly supportDirection) {
        return (FrameVertex3DReadOnly)super.getSupportingVertex(supportDirection);
    }

    @Override
    public FixedFrameShape3DPoseBasics getPose() {
        return null;
    }

    @Override
    public FrameConvexPolytope3D copy() {
        return new FrameConvexPolytope3D(this);
    }

    public boolean epsilonEquals(FrameConvexPolytope3D other, double epsilon) {
        return FrameConvexPolytope3DReadOnly.super.epsilonEquals(other, epsilon);
    }

    public boolean geometricallyEquals(FrameConvexPolytope3D other, double epsilon) {
        return FrameConvexPolytope3DReadOnly.super.geometricallyEquals(other, epsilon);
    }

    public boolean equals(Object object) {
        if (object instanceof FrameConvexPolytope3DReadOnly) {
            return FrameConvexPolytope3DReadOnly.super.equals((FrameConvexPolytope3DReadOnly)object);
        }
        return false;
    }

    public String toString() {
        return EuclidFrameShapeIOTools.getFrameConvexPolytope3DString(this);
    }
}

