/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import us.ihmc.euclid.interfaces.GeometryObject;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePointShape3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePointShape3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameShapeIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class FramePointShape3D
implements FramePointShape3DBasics,
GeometryObject<FramePointShape3D> {
    private ReferenceFrame referenceFrame;
    private double x;
    private double y;
    private double z;

    public FramePointShape3D() {
        this(ReferenceFrame.getWorldFrame());
    }

    public FramePointShape3D(ReferenceFrame referenceFrame) {
        this.setToZero(referenceFrame);
    }

    public FramePointShape3D(ReferenceFrame referenceFrame, double x, double y, double z) {
        this.setIncludingFrame(referenceFrame, x, y, z);
    }

    public FramePointShape3D(ReferenceFrame referenceFrame, Tuple3DReadOnly tuple3DReadOnly) {
        this.setIncludingFrame(referenceFrame, tuple3DReadOnly);
    }

    public FramePointShape3D(FrameTuple3DReadOnly tuple3DReadOnly) {
        this.setIncludingFrame(tuple3DReadOnly);
    }

    public void set(FramePointShape3D other) {
        FramePointShape3DBasics.super.set((FrameTuple3DReadOnly)other);
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    @Override
    public FramePointShape3D copy() {
        return new FramePointShape3D((FrameTuple3DReadOnly)this);
    }

    public boolean epsilonEquals(FramePointShape3D other, double epsilon) {
        return FramePointShape3DBasics.super.epsilonEquals((FrameTuple3DReadOnly)other, epsilon);
    }

    public boolean geometricallyEquals(FramePointShape3D other, double epsilon) {
        return FramePointShape3DBasics.super.geometricallyEquals((FramePoint3DReadOnly)other, epsilon);
    }

    public boolean equals(Object object) {
        if (object instanceof FramePointShape3DReadOnly) {
            return FramePointShape3DBasics.super.equals((FrameTuple3DReadOnly)((FramePointShape3DReadOnly)object));
        }
        return false;
    }

    public int hashCode() {
        long bits = EuclidHashCodeTools.toLongHashCode((double)this.x, (double)this.y, (double)this.z);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.referenceFrame);
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    public String toString() {
        return EuclidFrameShapeIOTools.getFramePointShape3DString(this);
    }
}

