/*
 * Decompiled with CFR 0.152.
 */
package com.eprosima.idl.generator.manager;

import com.eprosima.idl.parser.exception.ParseException;
import com.eprosima.idl.parser.typecode.EnumMember;
import com.eprosima.idl.parser.typecode.EnumTypeCode;
import com.eprosima.idl.parser.typecode.Member;
import com.eprosima.idl.parser.typecode.TypeCode;
import com.eprosima.idl.parser.typecode.UnionMember;
import com.eprosima.idl.parser.typecode.UnionTypeCode;
import java.util.ArrayList;
import java.util.List;

public class TemplateUtil {
    public static String stripType(String type) {
        if (type.startsWith("std::array")) {
            return "std::array";
        }
        if (type.startsWith("std::vector")) {
            return "std::vector";
        }
        return type;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setUnionDefaultLabel(UnionTypeCode union_type, String scopeFile, int line) {
        TypeCode dist_type = union_type.getDiscriminator();
        List<Member> members = union_type.getMembers();
        if (dist_type == null || union_type.getDefaultMember() == null) return;
        if (dist_type.getKind() == 1 || dist_type.getKind() == 2 || dist_type.getKind() == 17 || dist_type.getKind() == 3 || dist_type.getKind() == 4 || dist_type.getKind() == 18 || dist_type.getKind() == 8) {
            long dvalue = -1L;
            boolean found = true;
            ArrayList<Member> list = new ArrayList<Member>(members);
            block0: do {
                ++dvalue;
                found = false;
                for (Member member : list) {
                    if (member instanceof UnionMember) {
                        UnionMember umember = (UnionMember)member;
                        for (String label : umember.getLabels()) {
                            long value = Long.valueOf(label);
                            if (dvalue != value) continue;
                            found = true;
                            break;
                        }
                    }
                    if (!found) continue;
                    continue block0;
                }
            } while (found);
            union_type.setDefaultvalue(Long.toString(dvalue));
            union_type.setJavaDefaultvalue(Long.toString(dvalue));
            return;
        } else if (dist_type.getKind() == 7) {
            if (members.size() == 1 && ((UnionMember)members.get(0)).getLabels().size() == 1) {
                if (((UnionMember)members.get(0)).getLabels().get(0).equals("true")) {
                    union_type.setDefaultvalue("false");
                    union_type.setJavaDefaultvalue("false");
                    return;
                } else {
                    if (!((UnionMember)members.get(0)).getLabels().get(0).equals("false")) throw new ParseException(null, "is not a valid label for a boolean discriminator.");
                    union_type.setDefaultvalue("true");
                    union_type.setJavaDefaultvalue("true");
                }
                return;
            } else {
                if (members.size() > 2) {
                    throw new ParseException(null, "boolean switch cannot have more than two elements.");
                }
                union_type.setDefaultvalue("false");
                union_type.setJavaDefaultvalue("false");
            }
            return;
        } else {
            if (dist_type.getKind() != 12) throw new ParseException(null, "Not supported type discriminator.");
            EnumTypeCode enume = (EnumTypeCode)dist_type;
            ArrayList<Member> list = new ArrayList<Member>(members);
            ArrayList<Member> enum_members = new ArrayList<Member>();
            enum_members.addAll(enume.getMembers());
            for (Member member : members) {
                UnionMember umember = (UnionMember)member;
                for (String label : umember.getInternalLabels()) {
                    int count;
                    for (count = 0; count < enum_members.size() && !((EnumMember)enum_members.get(count)).getName().equals(label); ++count) {
                    }
                    if (count >= enum_members.size()) continue;
                    enum_members.remove(count);
                }
            }
            if (enum_members.size() <= 0) throw new ParseException(null, "All enumeration elements are used in the union");
            union_type.setDefaultvalue(enume.getScope() + "::" + ((Member)enum_members.get(0)).getName());
            union_type.setJavaDefaultvalue(EnumTypeCode.javapackage + enume.getJavaScopedname() + "." + ((Member)enum_members.get(0)).getName());
        }
    }

    public static String checkUnionLabel(TypeCode dist_type, String label, String scopeFile, int line) {
        if (dist_type != null && dist_type.getKind() == 12) {
            EnumTypeCode enume = (EnumTypeCode)dist_type;
            if (enume.getScope() != null) {
                if (label.contains("::")) {
                    if (!label.startsWith(enume.getScope())) {
                        throw new ParseException(null, "was not declared previously");
                    }
                    label = label.replaceFirst(enume.getScope() + "::", "");
                }
            } else if (label.contains("::")) {
                throw new ParseException(null, "was not declared previously");
            }
        }
        return label;
    }
}

