/*
 * Decompiled with CFR 0.152.
 */
package com.eprosima.solution;

import com.eprosima.log.ColorMessage;
import com.eprosima.solution.Project;
import java.util.ArrayList;

public class Solution {
    private ArrayList<Project> m_projects = new ArrayList();
    private ArrayList<Project> m_cacheprojects = null;
    private ArrayList<String> m_libraryPaths = new ArrayList();
    private ArrayList<String> m_libraries = new ArrayList();
    private ArrayList<String> m_includes = new ArrayList();
    private ArrayList<String> m_defines = new ArrayList();
    String m_os = System.getProperty("os.name");

    public void addProject(Project project) {
        project.setParent(this);
        this.m_projects.add(project);
    }

    public String getOS() {
        return this.m_os;
    }

    public ArrayList getProjects() {
        if (this.m_cacheprojects == null) {
            ArrayList<Project> tmpArray = new ArrayList<Project>(this.m_projects);
            this.m_cacheprojects = new ArrayList();
            while (tmpArray.size() > 0) {
                Project proj = tmpArray.remove(0);
                ArrayList<String> deps = proj.getFullDependencies();
                boolean candidate = true;
                for (int count = 0; candidate && count < deps.size(); ++count) {
                    boolean found = false;
                    for (int acount = 0; !found && acount < this.m_cacheprojects.size(); ++acount) {
                        if (!this.compareNames(deps.get(count), this.m_cacheprojects.get(acount).getFile())) continue;
                        found = true;
                    }
                    if (found) continue;
                    for (int rcount = 0; !found && rcount < tmpArray.size(); ++rcount) {
                        if (!this.compareNames(deps.get(count), tmpArray.get(rcount).getFile())) continue;
                        found = true;
                    }
                    if (found) {
                        tmpArray.add(proj);
                        candidate = false;
                        continue;
                    }
                    System.out.println(ColorMessage.yellow("warning:") + " File " + deps.get(count) + " wasn't parsed in this execution. The generated example will not work. To generate a successful example, try to execute this application passing all necessary IDL files.");
                }
                if (!candidate) continue;
                this.m_cacheprojects.add(proj);
            }
        }
        return this.m_cacheprojects;
    }

    public boolean existsProject(String name) {
        boolean ret = false;
        for (int i = 0; i < this.m_projects.size(); ++i) {
            if (!this.compareNames(this.m_projects.get(i).getFile(), name)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public boolean compareNames(String dep, String file) {
        if (this.m_os.contains("Windows")) {
            return dep.toLowerCase().equals(file.toLowerCase());
        }
        return dep.equals(file);
    }

    public void addLibraryPath(String libraryPath) {
        this.m_libraryPaths.add(libraryPath);
    }

    public ArrayList<String> getLibraryPaths() {
        return this.m_libraryPaths;
    }

    public void addLibrary(String library) {
        this.m_libraries.add(library);
    }

    public ArrayList<String> getLibraries() {
        return this.m_libraries;
    }

    public void addInclude(String include) {
        this.m_includes.add(include);
    }

    public ArrayList<String> getIncludes() {
        return this.m_includes;
    }

    public void addDefine(String define) {
        this.m_defines.add(define);
    }

    public ArrayList<String> getDefines() {
        return this.m_defines;
    }
}

