/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ekf.filter.sensor;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.ekf.TestTools;
import us.ihmc.ekf.filter.RobotState;
import us.ihmc.ekf.filter.sensor.ComposedSensor;
import us.ihmc.ekf.filter.sensor.Sensor;

public class ComposedSensorTest {
    private static final Random RANDOM = new Random(14284L);

    @Test
    public void testComposedSensor() {
        for (int i = 0; i < 50; ++i) {
            this.testComposedSensor(RANDOM, 10, 100);
        }
    }

    @Test
    public void testAddingComposedState() {
        ArrayList<Sensor> subSensors = new ArrayList<Sensor>();
        int stateSize = RANDOM.nextInt(100) + 1;
        ComposedSensor sensor = ComposedSensorTest.createComposedSensor(RANDOM, 100, 10, "Test", stateSize, subSensors);
        ComposedSensor sensorToAdd = ComposedSensorTest.createComposedSensor(RANDOM, 100, 10, "ToAdd", stateSize, subSensors);
        sensor.addSensor((Sensor)sensorToAdd);
        int startIndex = 0;
        for (Sensor subSensor : subSensors) {
            Assertions.assertEquals((int)startIndex, (int)sensor.getStartIndex(subSensor));
            startIndex += subSensor.getMeasurementSize();
        }
    }

    public void testComposedSensor(Random random, int maxSensors, int maxSubSensorSize) {
        ArrayList<Sensor> subSensors = new ArrayList<Sensor>();
        final int stateSize = 10;
        ComposedSensor sensor = ComposedSensorTest.createComposedSensor(random, maxSensors, maxSubSensorSize, "Test", stateSize, subSensors);
        RobotState dummyState = new RobotState(null, new ArrayList()){

            public int getSize() {
                return stateSize;
            }
        };
        DMatrixRMaj H = new DMatrixRMaj(0, 0);
        DMatrixRMaj r = new DMatrixRMaj(0, 0);
        DMatrixRMaj R = new DMatrixRMaj(0, 0);
        sensor.getMeasurementJacobian((DMatrix1Row)H, dummyState);
        sensor.getResidual((DMatrix1Row)r, dummyState);
        sensor.getRMatrix((DMatrix1Row)R);
        int combinedSize = 0;
        for (int i = 0; i < subSensors.size(); ++i) {
            Sensor subSensor = (Sensor)subSensors.get(i);
            int startIndex = sensor.getStartIndex(subSensor);
            Assertions.assertEquals((int)combinedSize, (int)startIndex);
            DMatrixRMaj subH = new DMatrixRMaj(0, 0);
            DMatrixRMaj subr = new DMatrixRMaj(0, 0);
            subSensor.getMeasurementJacobian((DMatrix1Row)subH, dummyState);
            subSensor.getResidual((DMatrix1Row)subr, dummyState);
            TestTools.assertBlockEquals(startIndex, 0, (DMatrix)subH, (DMatrix)H);
            TestTools.assertBlockEquals(startIndex, 0, (DMatrix)subr, (DMatrix)r);
            DMatrixRMaj subR = new DMatrixRMaj(0, 0);
            subSensor.getRMatrix((DMatrix1Row)subR);
            TestTools.assertBlockEquals(startIndex, startIndex, (DMatrix)subR, (DMatrix)R);
            TestTools.assertBlockZero(startIndex, 0, (DMatrix)R, subSensor.getMeasurementSize(), startIndex);
            TestTools.assertBlockZero(0, startIndex, (DMatrix)R, startIndex, subSensor.getMeasurementSize());
            combinedSize += subSensor.getMeasurementSize();
        }
    }

    private static ComposedSensor createComposedSensor(Random random, int maxSensors, int maxSubSensorSize, String name, int stateSize, List<Sensor> subSensorListToModify) {
        ComposedSensor sensor = new ComposedSensor(name);
        int combinedSize = 0;
        int numberOfSensors = random.nextInt(maxSensors);
        for (int i = 0; i < numberOfSensors; ++i) {
            Sensor subSensor = ComposedSensorTest.nextSensor(random, maxSubSensorSize, stateSize, name + "SubSensor" + i);
            sensor.addSensor(subSensor);
            if (subSensorListToModify != null) {
                subSensorListToModify.add(subSensor);
            }
            Assertions.assertEquals((int)(combinedSize += subSensor.getMeasurementSize()), (int)sensor.getMeasurementSize());
        }
        return sensor;
    }

    private static Sensor nextSensor(Random random, int maxSize, int stateSize, final String name) {
        final int size = random.nextInt(maxSize);
        final DMatrixRMaj H = TestTools.nextMatrix(size, stateSize, random, -1.0, 1.0);
        final DMatrixRMaj r = TestTools.nextMatrix(size, 1, random, -1.0, 1.0);
        final DMatrixRMaj R = TestTools.nextMatrix(size, size, random, -1.0, 1.0);
        return new Sensor(){

            public void getMeasurementJacobian(DMatrix1Row jacobianToPack, RobotState robotState) {
                jacobianToPack.set((DMatrixD1)H);
            }

            public void getResidual(DMatrix1Row residualToPack, RobotState robotState) {
                residualToPack.set((DMatrixD1)r);
            }

            public void getRMatrix(DMatrix1Row noiseCovarianceToPack) {
                noiseCovarianceToPack.set((DMatrixD1)R);
            }

            public String getName() {
                return name;
            }

            public int getMeasurementSize() {
                return size;
            }
        };
    }
}

