/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ekf.filter;

import java.util.ArrayList;
import java.util.Random;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.simple.SimpleBase;
import org.ejml.simple.SimpleMatrix;
import org.junit.jupiter.api.Test;
import us.ihmc.ekf.TestTools;
import us.ihmc.ekf.filter.FilterTools;
import us.ihmc.ekf.filter.RobotState;
import us.ihmc.ekf.filter.StateEstimator;
import us.ihmc.ekf.filter.sensor.ComposedSensor;
import us.ihmc.ekf.filter.sensor.implementations.JointPositionSensor;
import us.ihmc.ekf.filter.state.ComposedState;
import us.ihmc.ekf.filter.state.State;
import us.ihmc.ekf.filter.state.implementations.JointState;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.yoVariables.parameters.DefaultParameterReader;
import us.ihmc.yoVariables.registry.YoRegistry;

public class StateEstimatorTest {
    private static final double EPSILON = 1.0E-10;

    @Test
    public void testStadyStateValues() {
        DMatrixRMaj Pinv;
        FilterTools.proccessNoiseModel = FilterTools.ProccessNoiseModel.ONLY_ACCELERATION_VARIANCE;
        YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
        Random random = new Random(358L);
        double dt = 0.001;
        ArrayList<String> jointNames = new ArrayList<String>();
        ArrayList<JointState> jointStates = new ArrayList<JointState>();
        jointNames.add("Joint0");
        jointNames.add("Joint1");
        jointNames.add("Joint2");
        ArrayList<JointPositionSensor> sensors = new ArrayList<JointPositionSensor>();
        DMatrixRMaj expectedState = new DMatrixRMaj(jointNames.size() * 3, 1);
        CommonOps_DDRM.fill((DMatrixD1)expectedState, (double)0.0);
        for (int jointIdx = 0; jointIdx < jointNames.size(); ++jointIdx) {
            String jointName = (String)jointNames.get(jointIdx);
            JointPositionSensor jointSensor = new JointPositionSensor(jointName, dt, registry);
            double jointPosition = EuclidCoreRandomTools.nextDouble((Random)random);
            expectedState.set(3 * jointIdx, jointPosition);
            jointSensor.setJointPositionMeasurement(jointPosition);
            sensors.add(jointSensor);
            JointState jointState = new JointState(jointName, dt, registry);
            jointStates.add(jointState);
        }
        RobotState robotState = new RobotState(null, jointStates);
        StateEstimator stateEstimator = new StateEstimator(sensors, robotState, registry);
        new DefaultParameterReader().readParametersInRegistry(registry);
        for (int i = 0; i < 6000; ++i) {
            stateEstimator.predict();
            stateEstimator.correct();
        }
        DMatrixRMaj actualState = new DMatrixRMaj(0, 0);
        robotState.getStateVector((DMatrix1Row)actualState);
        TestTools.assertEquals(expectedState, actualState, 1.0E-10);
        DMatrixRMaj actualCovariance = new DMatrixRMaj(0, 0);
        stateEstimator.getCovariance((DMatrix1Row)actualCovariance);
        DMatrixRMaj F = new DMatrixRMaj(0, 0);
        DMatrixRMaj Q = new DMatrixRMaj(0, 0);
        DMatrixRMaj H = new DMatrixRMaj(0, 0);
        DMatrixRMaj R = new DMatrixRMaj(0, 0);
        DMatrixRMaj residual = new DMatrixRMaj(0, 0);
        ComposedState state = new ComposedState("ReferenceState");
        ComposedSensor sensor = new ComposedSensor("ReferenceSensor");
        sensors.forEach(s -> sensor.addSensor(s));
        state.addState((State)robotState);
        state.addState(sensor.getSensorState());
        state.getFMatrix((DMatrix1Row)F);
        state.getQMatrix((DMatrix1Row)Q);
        sensor.getMeasurementJacobian((DMatrix1Row)H, robotState);
        sensor.getResidual((DMatrix1Row)residual, robotState);
        sensor.getRMatrix((DMatrix1Row)R);
        DMatrixRMaj P = new DMatrixRMaj(actualCovariance.getNumRows(), actualCovariance.getNumCols());
        DMatrixRMaj Htranspose = new DMatrixRMaj(H.getNumCols(), H.getNumRows());
        DMatrixRMaj inverse = new DMatrixRMaj(0, 0);
        DMatrixRMaj Rinv = StateEstimatorTest.invert(R);
        CommonOps_DDRM.transpose((DMatrixRMaj)H, (DMatrixRMaj)Htranspose);
        CommonOps_DDRM.setIdentity((DMatrix1Row)P);
        for (int i = 0; i < 10000; ++i) {
            Pinv = StateEstimatorTest.invert(P);
            inverse = StateEstimatorTest.invert(StateEstimatorTest.computeABAtPlusC(Htranspose, Rinv, Pinv));
            P = StateEstimatorTest.computeABAtPlusC(F, inverse, Q);
        }
        Pinv = (DMatrixRMaj)((SimpleMatrix)new SimpleMatrix((Matrix)P).invert()).getMatrix();
        P = StateEstimatorTest.invert(StateEstimatorTest.computeABAtPlusC(Htranspose, Rinv, Pinv));
        TestTools.assertEquals(P, actualCovariance, 1.0E-10);
    }

    private static DMatrixRMaj invert(DMatrixRMaj matrix) {
        return (DMatrixRMaj)((SimpleMatrix)new SimpleMatrix((Matrix)matrix).invert()).getMatrix();
    }

    private static DMatrixRMaj computeABAtPlusC(DMatrixRMaj A, DMatrixRMaj B, DMatrixRMaj C) {
        SimpleMatrix aSimple = new SimpleMatrix((Matrix)A);
        SimpleMatrix bSimple = new SimpleMatrix((Matrix)B);
        SimpleMatrix cSimple = new SimpleMatrix((Matrix)C);
        return (DMatrixRMaj)((SimpleMatrix)((SimpleMatrix)((SimpleMatrix)aSimple.mult((SimpleBase)bSimple)).mult(aSimple.transpose())).plus((SimpleBase)cSimple)).getMatrix();
    }
}

