/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ekf.filter.state;

import java.util.Random;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.ekf.filter.state.State;
import us.ihmc.ekf.filter.state.implementations.JointState;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.yoVariables.parameters.DefaultParameterReader;
import us.ihmc.yoVariables.registry.YoRegistry;

public class JointStateTest {
    private static final double EPSILON = 1.0E-12;

    @Test
    public void testSize() {
        Random random = new Random(4922L);
        State state = JointStateTest.createState(random, new YoRegistry("Test"));
        DMatrixRMaj matrix = new DMatrixRMaj(0, 0);
        state.getFMatrix((DMatrix1Row)matrix);
        Assertions.assertEquals((int)state.getSize(), (int)matrix.getNumRows());
        Assertions.assertEquals((int)state.getSize(), (int)matrix.getNumCols());
        state.getQMatrix((DMatrix1Row)matrix);
        Assertions.assertEquals((int)state.getSize(), (int)matrix.getNumRows());
        Assertions.assertEquals((int)state.getSize(), (int)matrix.getNumCols());
    }

    @Test
    public void testInitialize() {
        Random random = new Random(4922L);
        double qExpected = random.nextDouble();
        double qdExpected = random.nextDouble();
        JointState state = new JointState("TestJoint", Double.NaN, new YoRegistry("TestRegistry"));
        state.initialize(qExpected, qdExpected);
        Assertions.assertEquals((double)qExpected, (double)state.getQ(), (double)Double.MIN_VALUE);
        Assertions.assertEquals((double)qdExpected, (double)state.getQd(), (double)Double.MIN_VALUE);
        Assertions.assertEquals((double)0.0, (double)state.getQdd(), (double)Double.MIN_VALUE);
    }

    @Test
    public void testStateVector() {
        Random random = new Random(4922L);
        for (int test = 0; test < 50; ++test) {
            State state = JointStateTest.createState(random, new YoRegistry("Test"));
            DMatrixRMaj expectedState = new DMatrixRMaj(state.getSize(), 1);
            for (int i = 0; i < state.getSize(); ++i) {
                expectedState.set(i, random.nextDouble());
            }
            state.setStateVector((DMatrix1Row)expectedState);
            DMatrixRMaj actualState = new DMatrixRMaj(0, 0);
            state.getStateVector((DMatrix1Row)actualState);
            for (int i = 0; i < state.getSize(); ++i) {
                Assertions.assertEquals((double)expectedState.get(i), (double)actualState.get(i), (double)Double.MIN_VALUE);
            }
        }
    }

    @Test
    public void testGetters() {
        Random random = new Random(4922L);
        JointState state = new JointState("TestJoint", Double.NaN, new YoRegistry("TestRegistry"));
        DMatrixRMaj expectedState = new DMatrixRMaj(state.getSize(), 1);
        for (int i = 0; i < state.getSize(); ++i) {
            expectedState.set(i, random.nextDouble());
        }
        state.setStateVector((DMatrix1Row)expectedState);
        Assertions.assertEquals((double)expectedState.get(0), (double)state.getQ(), (double)Double.MIN_VALUE);
        Assertions.assertEquals((double)expectedState.get(1), (double)state.getQd(), (double)Double.MIN_VALUE);
        Assertions.assertEquals((double)expectedState.get(2), (double)state.getQdd(), (double)Double.MIN_VALUE);
    }

    @Test
    public void testPrediction() {
        Random random = new Random(4922L);
        for (int test = 0; test < 50; ++test) {
            double c0 = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            double c1 = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            double c2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            double t0 = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            double dt = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0);
            JointState state = new JointState("TestJoint", dt, new YoRegistry("TestRegistry"));
            DMatrixRMaj stateVector = new DMatrixRMaj(state.getSize(), 1);
            stateVector.set(0, c0 * t0 * t0 + c1 * t0 + c2);
            stateVector.set(1, 2.0 * c0 * t0 + c1);
            stateVector.set(2, 2.0 * c0);
            state.setStateVector((DMatrix1Row)stateVector);
            state.predict();
            state.getStateVector((DMatrix1Row)stateVector);
            double t1 = t0 + dt;
            Assertions.assertEquals((double)(c0 * t1 * t1 + c1 * t1 + c2), (double)stateVector.get(0), (double)1.0E-12);
            Assertions.assertEquals((double)(2.0 * c0 * t1 + c1), (double)stateVector.get(1), (double)1.0E-12);
            Assertions.assertEquals((double)(2.0 * c0), (double)stateVector.get(2), (double)1.0E-12);
        }
    }

    @Test
    public void testPredictionAgainstAMatrix() {
        Random random = new Random(4922L);
        for (int test = 0; test < 50; ++test) {
            State state = JointStateTest.createState(random, new YoRegistry("Test"));
            DMatrixRMaj initialState = new DMatrixRMaj(state.getSize(), 1);
            initialState.set(0, EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            initialState.set(1, EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            initialState.set(2, EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            state.setStateVector((DMatrix1Row)initialState);
            DMatrixRMaj A = new DMatrixRMaj(0, 0);
            state.getFMatrix((DMatrix1Row)A);
            DMatrixRMaj predicted = new DMatrixRMaj(state.getSize(), 1);
            state.predict();
            state.getStateVector((DMatrix1Row)predicted);
            DMatrixRMaj linearized = new DMatrixRMaj(state.getSize(), 1);
            CommonOps_DDRM.mult((DMatrix1Row)A, (DMatrix1Row)initialState, (DMatrix1Row)linearized);
            for (int i = 0; i < state.getSize(); ++i) {
                Assertions.assertEquals((double)predicted.get(i), (double)linearized.get(i), (double)Double.MIN_VALUE);
            }
        }
    }

    private static State createState(Random random, YoRegistry registry) {
        JointState jointState = new JointState("Joint", random.nextDouble(), registry);
        new DefaultParameterReader().readParametersInRegistry(registry);
        return jointState;
    }
}

