/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ekf.filter.state;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.ekf.TestTools;
import us.ihmc.ekf.filter.state.ComposedState;
import us.ihmc.ekf.filter.state.State;

public class ComposedStateTest {
    private static final Random RANDOM = new Random(14284L);

    @Test
    public void testComposedState() {
        for (int i = 0; i < 50; ++i) {
            this.testComposedState(RANDOM, 10, 100);
        }
    }

    @Test
    public void testAddingComposedState() {
        ArrayList<State> subStates = new ArrayList<State>();
        ComposedState state = ComposedStateTest.createComposedState(RANDOM, 100, 10, "Test", subStates);
        ComposedState stateToAdd = ComposedStateTest.createComposedState(RANDOM, 100, 10, "ToAdd", subStates);
        state.addState((State)stateToAdd);
        int startIndex = 0;
        for (State subState : subStates) {
            Assertions.assertEquals((int)startIndex, (int)state.getStartIndex(subState));
            startIndex += subState.getSize();
        }
    }

    public void testComposedState(Random random, int maxStates, int maxSubStateSize) {
        ArrayList<State> subStates = new ArrayList<State>();
        ComposedState state = ComposedStateTest.createComposedState(random, maxStates, maxSubStateSize, "Test", subStates);
        DMatrixRMaj F = new DMatrixRMaj(0, 0);
        DMatrixRMaj Q = new DMatrixRMaj(0, 0);
        DMatrixRMaj x = new DMatrixRMaj(0, 0);
        state.getFMatrix((DMatrix1Row)F);
        state.getQMatrix((DMatrix1Row)Q);
        state.getStateVector((DMatrix1Row)x);
        int combinedSize = 0;
        for (int i = 0; i < subStates.size(); ++i) {
            State subState = (State)subStates.get(i);
            int startIndex = state.getStartIndex(subState);
            Assertions.assertEquals((int)combinedSize, (int)startIndex);
            DMatrixRMaj subF = new DMatrixRMaj(0, 0);
            subState.getFMatrix((DMatrix1Row)subF);
            TestTools.assertBlockEquals(startIndex, startIndex, (DMatrix)subF, (DMatrix)F);
            TestTools.assertBlockZero(startIndex, 0, (DMatrix)F, subState.getSize(), startIndex);
            TestTools.assertBlockZero(0, startIndex, (DMatrix)F, startIndex, subState.getSize());
            DMatrixRMaj subQ = new DMatrixRMaj(0, 0);
            subState.getQMatrix((DMatrix1Row)subQ);
            TestTools.assertBlockEquals(startIndex, startIndex, (DMatrix)subQ, (DMatrix)Q);
            TestTools.assertBlockZero(startIndex, 0, (DMatrix)Q, subState.getSize(), startIndex);
            TestTools.assertBlockZero(0, startIndex, (DMatrix)Q, startIndex, subState.getSize());
            DMatrixRMaj subx = new DMatrixRMaj(0, 0);
            subState.getStateVector((DMatrix1Row)subx);
            TestTools.assertBlockEquals(startIndex, 0, (DMatrix)subx, (DMatrix)x);
            combinedSize += subState.getSize();
        }
        DMatrixRMaj xNew = TestTools.nextMatrix(combinedSize, 1, random, -1.0, 1.0);
        state.setStateVector((DMatrix1Row)xNew);
        state.getStateVector((DMatrix1Row)x);
        TestTools.assertEquals(xNew, x);
        state.predict();
        state.getStateVector((DMatrix1Row)x);
        TestTools.assertNaN(x);
    }

    private static ComposedState createComposedState(Random random, int maxStates, int maxSubStateSize, String name, List<State> subStateListToModify) {
        ComposedState state = new ComposedState(name);
        int combinedSize = 0;
        int numberOfStates = random.nextInt(maxStates);
        for (int i = 0; i < numberOfStates; ++i) {
            State subState = ComposedStateTest.nextState(random, maxSubStateSize, name + "SubState" + i);
            state.addState(subState);
            if (subStateListToModify != null) {
                subStateListToModify.add(subState);
            }
            Assertions.assertEquals((int)(combinedSize += subState.getSize()), (int)state.getSize());
        }
        return state;
    }

    private static State nextState(Random random, int maxSize, final String name) {
        final int size = random.nextInt(maxSize);
        final DMatrixRMaj F = TestTools.nextMatrix(size, size, random, -1.0, 1.0);
        final DMatrixRMaj Q = TestTools.nextMatrix(size, size, random, -1.0, 1.0);
        final DMatrixRMaj x = TestTools.nextMatrix(size, 1, random, -1.0, 1.0);
        return new State(){

            public void setStateVector(DMatrix1Row newState) {
                if (newState.getNumRows() != x.getNumRows()) {
                    Assertions.fail((String)"Unexpected state size");
                }
                if (newState.getNumCols() != 1) {
                    Assertions.fail((String)"Unexpected state size");
                }
                x.set((DMatrixD1)newState);
            }

            public void predict() {
                CommonOps_DDRM.fill((DMatrixD1)x, (double)Double.NaN);
            }

            public void getStateVector(DMatrix1Row stateVectorToPack) {
                stateVectorToPack.set((DMatrixD1)x);
            }

            public int getSize() {
                return size;
            }

            public void getQMatrix(DMatrix1Row noiseCovarianceToPack) {
                noiseCovarianceToPack.set((DMatrixD1)Q);
            }

            public void getFMatrix(DMatrix1Row fMatrixToPack) {
                fMatrixToPack.set((DMatrixD1)F);
            }

            public String getName() {
                return name;
            }
        };
    }
}

