/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.velocityControlEvaluation;

import us.ihmc.atlas.velocityControlEvaluation.VelocityControlEvaluationRobot;
import us.ihmc.robotics.math.filters.DelayedYoDouble;
import us.ihmc.simulationconstructionset.util.RobotController;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class VelocityControlEvaluationController
implements RobotController {
    private final VelocityControlEvaluationRobot robot;
    private final double controlDT;
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoDouble q_d_x = new YoDouble("q_d_x", this.registry);
    private final YoDouble qd_d_x = new YoDouble("qd_d_x", this.registry);
    private final YoDouble qdd_d_x = new YoDouble("qdd_d_x", this.registry);
    private final YoDouble offset = new YoDouble("offset", this.registry);
    private final YoDouble amplitude = new YoDouble("amplitude", this.registry);
    private final YoDouble frequency = new YoDouble("frequency", this.registry);
    private final YoDouble xTrajectory = new YoDouble("xTrajectory", this.registry);
    private final YoDouble xDotTrajectory = new YoDouble("xDotTrajectory", this.registry);
    private final YoDouble xDDotTrajectory = new YoDouble("xDDotTrajectory", this.registry);
    private final YoDouble omega = new YoDouble("omega", this.registry);
    private final YoDouble zeta = new YoDouble("zeta", this.registry);
    private final YoDouble kp = new YoDouble("kp", this.registry);
    private final YoDouble kd = new YoDouble("kd", this.registry);
    private final YoDouble alphaDesiredVelocity = new YoDouble("alphaDesiredVelocity", "Filter for velocity control in order to achieve acceleration control. Zero means compliant, but poor acceleration. One means stiff, but good acceleration tracking", this.registry);
    private final YoDouble kForceVel = new YoDouble("kForceVel", "Gain for velocity control in order to achieve acceleration control", this.registry);
    private final YoDouble qdd_tau = new YoDouble("qdd_tau", "Torque from inverse dynamics desired acceleration", this.registry);
    private final YoDouble qd_tau = new YoDouble("qd_tau", "Torque from integrating acceleration to get velocity", this.registry);
    private final YoDouble undelayedTorque = new YoDouble("undelayedTorque", "", this.registry);
    private final DelayedYoDouble delayedTorque = new DelayedYoDouble("delayedTorque", "", (DoubleProvider)this.undelayedTorque, 2, this.registry);

    public VelocityControlEvaluationController(VelocityControlEvaluationRobot robot, double controlDT) {
        this.robot = robot;
        this.controlDT = controlDT;
        this.offset.set(0.05);
        this.amplitude.set(0.2);
        this.frequency.set(1.0);
        this.omega.set(10.0);
        this.zeta.set(0.7);
        this.alphaDesiredVelocity.set(0.975);
        this.kForceVel.set(100.0);
    }

    public void initialize() {
    }

    public YoRegistry getYoRegistry() {
        return this.registry;
    }

    public String getName() {
        return this.registry.getName();
    }

    public String getDescription() {
        return this.getName();
    }

    public void doControl() {
        this.computeDesiredTrajectory();
        this.computeGains();
        double desiredAcceleration = this.xDDotTrajectory.getDoubleValue() + this.kp.getDoubleValue() * (this.xTrajectory.getDoubleValue() - this.robot.getX()) + this.kd.getDoubleValue() * (this.xDotTrajectory.getDoubleValue() - this.robot.getXDot());
        this.qdd_d_x.set(desiredAcceleration);
        this.qd_d_x.set(this.alphaDesiredVelocity.getDoubleValue() * (this.qd_d_x.getDoubleValue() + desiredAcceleration * this.controlDT) + (1.0 - this.alphaDesiredVelocity.getDoubleValue()) * this.robot.getXDot());
        this.qdd_tau.set(this.qdd_d_x.getDoubleValue() * 10.0);
        this.qd_tau.set(this.kForceVel.getDoubleValue() * (this.qd_d_x.getDoubleValue() - this.robot.getXDot()));
        this.undelayedTorque.set(this.qdd_tau.getDoubleValue() + this.qd_tau.getDoubleValue());
        this.delayedTorque.update();
        this.robot.setTau(this.delayedTorque.getDoubleValue());
    }

    private void computeGains() {
        this.kp.set(this.omega.getDoubleValue() * this.omega.getDoubleValue());
        this.kd.set(2.0 * this.zeta.getDoubleValue() * this.omega.getDoubleValue());
    }

    private void computeDesiredTrajectory() {
        double twoPiFreq = Math.PI * 2 * this.frequency.getDoubleValue();
        this.xTrajectory.set(this.offset.getDoubleValue() + this.amplitude.getDoubleValue() * Math.sin(twoPiFreq * this.robot.getTime()));
        this.xDotTrajectory.set(twoPiFreq * this.amplitude.getDoubleValue() * Math.cos(twoPiFreq * this.robot.getTime()));
        this.xDDotTrajectory.set(-twoPiFreq * twoPiFreq * this.amplitude.getDoubleValue() * Math.sin(twoPiFreq * this.robot.getTime()));
    }
}

