/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.sensors;

import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.stage.Stage;
import us.ihmc.atlas.AtlasRobotModel;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.util.NetworkPorts;
import us.ihmc.javaFXToolkit.applicationCreator.JavaFXApplicationCreator;
import us.ihmc.log.LogTools;
import us.ihmc.messager.Messager;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.messager.kryo.KryoMessager;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotEnvironmentAwareness.communication.SLAMModuleAPI;
import us.ihmc.robotEnvironmentAwareness.ui.PlanarSegmentationUI;
import us.ihmc.robotEnvironmentAwareness.ui.SLAMBasedEnvironmentAwarenessUI;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.ros2.ROS2Callback;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.tools.processManagement.JavaProcessManager;
import us.ihmc.wholeBodyController.RobotContactPointParameters;

public class AtlasRealsenseSLAMRemoteUILauncher {
    private final DomainFactory.PubSubImplementation pubSubImplementation = DomainFactory.PubSubImplementation.FAST_RTPS;
    private ROS2Node ros2Node;
    private Messager slamMessager;
    private Messager segmentationMessager;
    private SLAMBasedEnvironmentAwarenessUI ui;
    private PlanarSegmentationUI planarSegmentationUI;

    public AtlasRealsenseSLAMRemoteUILauncher() {
        Runnable setup = () -> ExceptionTools.handle(this::setup, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        JavaFXApplicationCreator.createAJavaFXApplication();
        Platform.runLater((Runnable)setup);
    }

    public void setup() throws Exception {
        AtlasRobotModel drcRobotModel = new AtlasRobotModel(AtlasRobotVersion.ATLAS_UNPLUGGED_V5_DUAL_ROBOTIQ, RobotTarget.REAL_ROBOT, false);
        RobotContactPointParameters contactPointParameters = drcRobotModel.getContactPointParameters();
        SideDependentList defaultContactPoints = new SideDependentList();
        for (RobotSide side : RobotSide.values) {
            defaultContactPoints.put((Enum)side, (Object)((List)contactPointParameters.getControllerFootGroundContactPoints().get((Enum)side)));
        }
        this.ros2Node = ROS2Tools.createROS2Node((DomainFactory.PubSubImplementation)this.pubSubImplementation, (String)"REA_module");
        this.slamMessager = KryoMessager.createClient((MessagerAPIFactory.MessagerAPI)SLAMModuleAPI.API, (String)"poweredge", (int)NetworkPorts.SLAM_MODULE_UI_PORT.getPort(), (String)"KryoSLAMModuleMessager", (int)5);
        ThreadTools.startAThread(() -> ExceptionTools.handle(() -> this.slamMessager.startMessager(), (ExceptionHandler)DefaultExceptionHandler.RUNTIME_EXCEPTION), (String)"KryoMessagerAsyncConnectionThread");
        this.segmentationMessager = KryoMessager.createClient((MessagerAPIFactory.MessagerAPI)SLAMModuleAPI.API, (String)"poweredge", (int)NetworkPorts.PLANAR_SEGMENTATION_UI_PORT.getPort(), (String)"KryoSegmentationModuleMessager", (int)5);
        ThreadTools.startAThread(() -> ExceptionTools.handle(() -> this.segmentationMessager.startMessager(), (ExceptionHandler)DefaultExceptionHandler.RUNTIME_EXCEPTION), (String)"KryoMessagerAsyncConnectionThread");
        Stage primaryStage = new Stage();
        this.ui = SLAMBasedEnvironmentAwarenessUI.creatIntraprocessUI((Messager)this.slamMessager, (Stage)primaryStage, (SideDependentList)defaultContactPoints);
        Stage secondStage = new Stage();
        this.planarSegmentationUI = PlanarSegmentationUI.createIntraprocessUI((Messager)this.segmentationMessager, (Stage)secondStage);
        this.ui.show();
        this.planarSegmentationUI.show();
        new ROS2Callback((ROS2NodeInterface)this.ros2Node, SLAMModuleAPI.SHUTDOWN, message -> {
            LogTools.info((String)"Received SHUTDOWN. Shutting down...");
            this.stop();
        });
    }

    public void stop() {
        ThreadTools.sleepSeconds((double)2.0);
        ExceptionTools.handle(() -> this.slamMessager.closeMessager(), (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        ExceptionTools.handle(() -> this.segmentationMessager.closeMessager(), (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        this.ros2Node.destroy();
    }

    public static void main(String[] args) {
        JavaProcessManager manager = new JavaProcessManager();
        manager.runOrRegister("AtlasSLAMBasedREA", AtlasRealsenseSLAMRemoteUILauncher::new);
        ArrayList processes = manager.spawnProcesses(AtlasRealsenseSLAMRemoteUILauncher.class, args);
        ROS2Node ros2Node = ROS2Tools.createROS2Node((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS, (String)"test_node");
        new ROS2Callback((ROS2NodeInterface)ros2Node, SLAMModuleAPI.SHUTDOWN, message -> {
            LogTools.info((String)"Received SHUTDOWN. Shutting down...");
            ThreadTools.startAsDaemon(() -> {
                ThreadTools.sleepSeconds((double)2.0);
                for (Process process : processes) {
                    LogTools.info((String)"Destoying process  forcibly");
                    process.destroyForcibly();
                }
                ros2Node.destroy();
            }, (String)"DestroyThread");
        });
    }
}

