/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.sensors;

import java.nio.file.Path;
import java.nio.file.Paths;
import us.ihmc.atlas.AtlasRobotModel;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.atlas.sensors.AtlasSLAMModule;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.messager.Messager;
import us.ihmc.robotEnvironmentAwareness.perceptionSuite.PerceptionSuite;
import us.ihmc.robotEnvironmentAwareness.slam.SLAMModule;
import us.ihmc.tools.io.WorkspacePathTools;

public class AtlasPerceptionSuite
extends PerceptionSuite {
    private static final Path rootPath = WorkspacePathTools.handleWorkingDirectoryFuzziness((String)"ihmc-open-robotics-software");
    private static final String directory = "/atlas/src/main/resources/";
    private static final String SLAM_MODULE_CONFIGURATION_FILE_NAME = "atlasSLAMModuleConfiguration.txt";
    private static final String SEGMENTATION_MODULE_CONFIGURATION_FILE_NAME = "atlasSegmentationModuleConfiguration.txt";
    private static final String LIDAR_REA_MODULE_CONFIGURATION_FILE_NAME = "atlasREAModuleConfiguration.txt";
    private static final String REALSENSE_REA_MODULE_CONFIGURATION_FILE_NAME = "atlasRealSenseREAModuleConfiguration.txt";
    private final Path slamConfigurationFilePath = Paths.get(rootPath.toString(), "/atlas/src/main/resources/atlasSLAMModuleConfiguration.txt");
    private final DRCRobotModel robotModel = new AtlasRobotModel(AtlasRobotVersion.ATLAS_UNPLUGGED_V5_DUAL_ROBOTIQ, RobotTarget.REAL_ROBOT, false);

    public AtlasPerceptionSuite(Messager messager) {
        super(messager, Paths.get(rootPath.toString(), "/atlas/src/main/resources/atlasSegmentationModuleConfiguration.txt"), Paths.get(rootPath.toString(), "/atlas/src/main/resources/atlasREAModuleConfiguration.txt"), Paths.get(rootPath.toString(), "/atlas/src/main/resources/atlasRealSenseREAModuleConfiguration.txt"), "atlas");
    }

    protected SLAMModule createSLAMModule(Messager messager) {
        return AtlasSLAMModule.createIntraprocessModule(this.ros2Node, this.robotModel, messager, this.slamConfigurationFilePath.toFile());
    }

    public static AtlasPerceptionSuite createIntraprocess(Messager messager) {
        return new AtlasPerceptionSuite(messager);
    }
}

