/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.sensors;

import boofcv.struct.calib.CameraPinholeBrown;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import perception_msgs.msg.dds.VideoPacket;
import sensor_msgs.CompressedImage;
import us.ihmc.atlas.AtlasRobotModel;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.ROS2SyncedRobotModel;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.behaviors.tools.CommunicationHelper;
import us.ihmc.codecs.generated.YUVPicture;
import us.ihmc.codecs.yuv.JPEGEncoder;
import us.ihmc.codecs.yuv.YUVPictureConverter;
import us.ihmc.communication.PerceptionAPI;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.configuration.NetworkParameters;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.humanoidRobotics.communication.packets.HumanoidMessageTools;
import us.ihmc.humanoidRobotics.frames.HumanoidReferenceFrames;
import us.ihmc.log.LogTools;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.tools.UnitConversions;
import us.ihmc.tools.thread.MissingThreadTools;
import us.ihmc.tools.thread.ResettableExceptionHandlingExecutorService;
import us.ihmc.tools.thread.Throttler;
import us.ihmc.utilities.ros.RosMainNode;
import us.ihmc.utilities.ros.RosTools;
import us.ihmc.utilities.ros.subscriber.AbstractRosTopicSubscriber;
import us.ihmc.utilities.ros.subscriber.RosTopicSubscriberInterface;

public class AtlasD435ToMultiSenseLeftEyeBridge {
    private static final double OUTPUT_FREQUENCY = UnitConversions.hertzToSeconds((double)10.0);

    public AtlasD435ToMultiSenseLeftEyeBridge() {
        RosMainNode ros1Node = RosTools.createRosNode((URI)NetworkParameters.getROSURI(), (String)"d435_to_left_eye");
        ROS2Node ros2Node = ROS2Tools.createROS2Node((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS, (String)"d435_to_left_eye");
        AtlasRobotModel robotModel = new AtlasRobotModel(AtlasRobotVersion.ATLAS_UNPLUGGED_V5_DUAL_ROBOTIQ, RobotTarget.REAL_ROBOT);
        final CommunicationHelper ros2Helper = new CommunicationHelper((DRCRobotModel)robotModel, (ROS2NodeInterface)ros2Node);
        final ROS2SyncedRobotModel syncedRobot = ros2Helper.newSyncedRobot();
        final RigidBodyTransform transformToWorld = new RigidBodyTransform();
        final Throttler throttler = new Throttler();
        final YUVPictureConverter converter = new YUVPictureConverter();
        final JPEGEncoder encoder = new JPEGEncoder();
        int imageWidth = 640;
        int imageHeight = 360;
        double fx = 500.0;
        double fy = 500.0;
        final CameraPinholeBrown depthCameraIntrinsics = new CameraPinholeBrown(fx, fy, 0.0, (double)imageWidth / 2.0, (double)imageHeight / 2.0, imageWidth, imageHeight);
        final ResettableExceptionHandlingExecutorService executor = MissingThreadTools.newSingleThreadExecutor((String)"D435ToLeftEyeBridge", (boolean)true);
        AbstractRosTopicSubscriber<CompressedImage> subscriber = new AbstractRosTopicSubscriber<CompressedImage>("sensor_msgs/CompressedImage"){

            public void onNewMessage(CompressedImage ros1Image) {
                if (throttler.run(OUTPUT_FREQUENCY)) {
                    executor.submit(() -> {
                        syncedRobot.update();
                        try {
                            byte[] payload = ros1Image.getData().array();
                            int offset = ros1Image.getData().arrayOffset();
                            BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(payload, offset, payload.length - offset));
                            YUVPicture picture = converter.fromBufferedImage(bufferedImage, YUVPicture.YUVSubsamplingType.YUV420);
                            ByteBuffer buffer = encoder.encode(picture, 75);
                            byte[] data = new byte[buffer.remaining()];
                            buffer.get(data);
                            FramePose3DReadOnly ousterPose = syncedRobot.getFramePoseReadOnly(HumanoidReferenceFrames::getOusterLidarFrame);
                            ousterPose.get((RigidBodyTransformBasics)transformToWorld);
                            VideoPacket message = new VideoPacket();
                            message.setTimestamp(System.nanoTime());
                            message.getData().add(data);
                            message.getPosition().set((Tuple3DReadOnly)ousterPose.getPosition());
                            message.getOrientation().set((QuaternionReadOnly)ousterPose.getOrientation());
                            message.setVideoSource((byte)0);
                            message.getIntrinsicParameters().set(HumanoidMessageTools.toIntrinsicParametersMessage((CameraPinholeBrown)depthCameraIntrinsics));
                            ros2Helper.publish(PerceptionAPI.VIDEO, (Object)message);
                        }
                        catch (Exception e) {
                            LogTools.error((String)e.getMessage());
                            e.printStackTrace();
                        }
                    });
                }
            }
        };
        ros1Node.attachSubscriber("/camera/color/image_raw/compressed", (RosTopicSubscriberInterface)subscriber);
        ros1Node.execute();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            executor.destroy();
            ros1Node.shutdown();
        }, "IHMC-D435ROS1ToLeftEyeBridgeShutdown"));
    }

    public static void main(String[] args) {
        new AtlasD435ToMultiSenseLeftEyeBridge();
    }
}

