/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.ros;

import controller_msgs.msg.dds.RobotConfigurationData;
import java.util.concurrent.atomic.AtomicLong;
import multisense_ros.StampedPps;
import us.ihmc.atlas.parameters.AtlasSensorInformation;
import us.ihmc.avatar.ros.DRCROSPPSTimestampOffsetProvider;
import us.ihmc.commons.Conversions;
import us.ihmc.utilities.ros.RosNodeInterface;
import us.ihmc.utilities.ros.subscriber.RosTimestampSubscriber;
import us.ihmc.utilities.ros.subscriber.RosTopicSubscriberInterface;

public class AtlasPPSTimestampOffsetProvider
implements DRCROSPPSTimestampOffsetProvider {
    public static final boolean DEBUG = false;
    private final Object lock = new Object();
    private final String ppsTopic;
    private RosTimestampSubscriber ppsSubscriber;
    private final AtomicLong currentTimeStampOffset = new AtomicLong(0L);
    private volatile boolean offsetIsDetermined = false;
    private static AtlasPPSTimestampOffsetProvider instance = null;
    private RosNodeInterface ros1Node;
    private long multisensePPSTimestamp = -1L;

    private AtlasPPSTimestampOffsetProvider(AtlasSensorInformation sensorInformation) {
        this.ppsTopic = sensorInformation.getPPSRosTopic();
    }

    private void setupPPSSubscriber() {
        this.ppsSubscriber = new RosTimestampSubscriber(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onNewMessage(StampedPps message) {
                Object object = AtlasPPSTimestampOffsetProvider.this.lock;
                synchronized (object) {
                    AtlasPPSTimestampOffsetProvider.this.multisensePPSTimestamp = message.getHostTime().totalNsecs();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribeToROS1Topics(RosNodeInterface ros1Node) {
        Object object = this.lock;
        synchronized (object) {
            if (this.ros1Node == null) {
                this.setupPPSSubscriber();
                ros1Node.attachSubscriber(this.ppsTopic, (RosTopicSubscriberInterface)this.ppsSubscriber);
                this.ros1Node = ros1Node;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeFromROS1Topics(RosNodeInterface ros1Node) {
        Object object = this.lock;
        synchronized (object) {
            ros1Node.removeSubscriber((RosTopicSubscriberInterface)this.ppsSubscriber);
        }
    }

    public long getCurrentTimestampOffset() {
        return this.currentTimeStampOffset.get();
    }

    public long adjustTimeStampToRobotClock(long timeStamp) {
        return timeStamp + this.currentTimeStampOffset.get();
    }

    public long adjustRobotTimeStampToRosClock(long timeStamp) {
        return timeStamp - this.currentTimeStampOffset.get();
    }

    public boolean offsetIsDetermined() {
        return this.offsetIsDetermined;
    }

    public static synchronized DRCROSPPSTimestampOffsetProvider getInstance(AtlasSensorInformation sensorInformation) {
        if (instance == null) {
            instance = new AtlasPPSTimestampOffsetProvider(sensorInformation);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedPacket(RobotConfigurationData packet) {
        Object object = this.lock;
        synchronized (object) {
            if (this.ros1Node != null && this.ros1Node.isStarted()) {
                long ppsFromROSAge;
                long lastPPSTimestampFromRobot = packet.getSyncTimestamp();
                long ppsFromRobotAge = packet.getMonotonicTime() - lastPPSTimestampFromRobot;
                if (Math.abs(ppsFromRobotAge - (ppsFromROSAge = this.ros1Node.getCurrentTime().totalNsecs() - this.multisensePPSTimestamp)) > Conversions.millisecondsToNanoseconds((long)100L)) {
                    return;
                }
                long newOffset = lastPPSTimestampFromRobot - this.multisensePPSTimestamp;
                long lastTimestampOffset = this.currentTimeStampOffset.getAndSet(newOffset);
                if (this.offsetIsDetermined && Math.abs(newOffset - lastTimestampOffset) > Conversions.millisecondsToNanoseconds((long)1L)) {
                    System.err.println("[AtlasPPSTimestampOffsetProvider] Unstable PPS offset. New offset: " + newOffset + ", previous offset: " + lastTimestampOffset);
                }
                this.offsetIsDetermined = true;
            }
        }
    }
}

