/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.physics;

import us.ihmc.atlas.AtlasJointMap;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.simulationconstructionset.FloatingJoint;
import us.ihmc.simulationconstructionset.FloatingRootJointRobot;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.Link;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.physics.CollisionHandler;
import us.ihmc.simulationconstructionset.physics.CollisionShapeDescription;
import us.ihmc.simulationconstructionset.physics.CollisionShapeFactory;
import us.ihmc.simulationconstructionset.physics.ScsCollisionConfigure;
import us.ihmc.simulationconstructionset.physics.ScsCollisionDetector;

public class AtlasPhysicsEngineConfiguration
implements ScsCollisionConfigure {
    private static final int GROUP_GROUND = -1;
    private static final int GROUP_FEET = -1;
    private AtlasJointMap jointMap;
    private FloatingRootJointRobot sdfRobot;

    public AtlasPhysicsEngineConfiguration(AtlasJointMap jointMap, FloatingRootJointRobot sdfRobot) {
        this.jointMap = jointMap;
        this.sdfRobot = sdfRobot;
    }

    public void setup(Robot robot, ScsCollisionDetector collisionDetector, CollisionHandler collisionHandler) {
        String leftFootJointName = this.jointMap.getJointBeforeFootName(RobotSide.LEFT);
        String rightFootJointName = this.jointMap.getJointBeforeFootName(RobotSide.RIGHT);
        Joint leftFootJoint = this.sdfRobot.getJoint(leftFootJointName);
        Joint rightFootJoint = this.sdfRobot.getJoint(rightFootJointName);
        Link leftLink = leftFootJoint.getLink();
        Link rightLink = rightFootJoint.getLink();
        CollisionShapeFactory factoryShape = collisionDetector.getShapeFactory();
        CollisionShapeDescription collisionFoot = factoryShape.createBox(this.jointMap.getPhysicalProperties().getActualFootLength() / 2.0, this.jointMap.getPhysicalProperties().getActualFootWidth() / 2.0, 0.05);
        RigidBodyTransform ankleToSole = new RigidBodyTransform((Orientation3DReadOnly)new Quaternion(), (Tuple3DReadOnly)new Vector3D(0.0, 0.0, 0.084));
        RigidBodyTransform soleToAnkle = new RigidBodyTransform();
        ankleToSole.setAndInvert((RigidBodyTransformReadOnly)soleToAnkle);
        factoryShape.addShape(leftLink, soleToAnkle, collisionFoot, false, -1, -1);
        factoryShape.addShape(rightLink, soleToAnkle, collisionFoot, false, -1, -1);
        CollisionShapeDescription collisionGround = factoryShape.createBox(20.0, 20.0, 0.1);
        FloatingJoint groundJoint = new FloatingJoint("ground", "ground", (Tuple3DReadOnly)new Vector3D(), robot);
        Link linkGround = new Link("Ground Plane Hack");
        linkGround.setMass(1000.0);
        linkGround.setMomentOfInertia(10.0, 10.0, 10.0);
        factoryShape.addShape(linkGround, null, collisionGround, true, -1, -1);
        groundJoint.setLink(linkGround);
        groundJoint.setPositionAndVelocity(0.0, 0.0, -0.1, 0.0, 0.0, 0.0);
        groundJoint.setDynamic(false);
        robot.addRootJoint((Joint)groundJoint);
    }
}

