/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.parameters;

import gnu.trove.map.hash.TObjectDoubleHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import us.ihmc.atlas.AtlasJointMap;
import us.ihmc.atlas.parameters.AtlasContactPointParameters;
import us.ihmc.atlas.parameters.AtlasICPControllerParameters;
import us.ihmc.atlas.parameters.AtlasJointPrivilegedConfigurationParameters;
import us.ihmc.atlas.parameters.AtlasMomentumOptimizationSettings;
import us.ihmc.atlas.parameters.AtlasStepAdjustmentParameters;
import us.ihmc.atlas.parameters.AtlasSteppingParameters;
import us.ihmc.atlas.parameters.AtlasSwingTrajectoryParameters;
import us.ihmc.atlas.parameters.AtlasToeOffParameters;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.commonWalkingControlModules.capturePoint.controller.ICPControllerParameters;
import us.ihmc.commonWalkingControlModules.capturePoint.stepAdjustment.StepAdjustmentParameters;
import us.ihmc.commonWalkingControlModules.configurations.GroupParameter;
import us.ihmc.commonWalkingControlModules.configurations.JointPrivilegedConfigurationParameters;
import us.ihmc.commonWalkingControlModules.configurations.SteppingParameters;
import us.ihmc.commonWalkingControlModules.configurations.SwingTrajectoryParameters;
import us.ihmc.commonWalkingControlModules.configurations.ToeOffParameters;
import us.ihmc.commonWalkingControlModules.configurations.ToeSlippingDetectorParameters;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyControlMode;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.PrivilegedConfigurationCommand;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.JointLimitParameters;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.MomentumOptimizationSettings;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.OneDoFJointPrivilegedConfigurationParameters;
import us.ihmc.commonWalkingControlModules.sensors.footSwitch.WrenchBasedFootSwitchFactory;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.robotics.controllers.pidGains.GainCoupling;
import us.ihmc.robotics.controllers.pidGains.PIDGainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.implementations.PDGains;
import us.ihmc.robotics.controllers.pidGains.implementations.PID3DConfiguration;
import us.ihmc.robotics.controllers.pidGains.implementations.PIDSE3Configuration;
import us.ihmc.robotics.partNames.ArmJointName;
import us.ihmc.robotics.partNames.LegJointName;
import us.ihmc.robotics.partNames.NeckJointName;
import us.ihmc.robotics.partNames.SpineJointName;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.sensors.FootSwitchFactory;

public class AtlasWalkingControllerParameters
extends WalkingControllerParameters {
    private final RobotTarget target;
    private final boolean runningOnRealRobot;
    private final SideDependentList<RigidBodyTransform> handPosesWithRespectToChestFrame = new SideDependentList();
    private final double minimumHeightAboveGround;
    private boolean doPrepareManipulationForLocomotion = true;
    private double nominalHeightAboveGround;
    private final double maximumHeightAboveGround;
    private final AtlasJointMap jointMap;
    private final AtlasMomentumOptimizationSettings momentumOptimizationSettings;
    private final double massScale;
    private TObjectDoubleHashMap<String> jointHomeConfiguration = null;
    private Map<String, Pose3D> bodyHomeConfiguration = null;
    private JointPrivilegedConfigurationParameters jointPrivilegedConfigurationParameters;
    private ToeOffParameters toeOffParameters;
    private SwingTrajectoryParameters swingTrajectoryParameters;
    private ICPControllerParameters icpOptimizationParameters;
    private StepAdjustmentParameters stepAdjustmentParameters;
    private AtlasSteppingParameters steppingParameters;
    private final OneDoFJointPrivilegedConfigurationParameters kneePrivilegedConfigurationParameters;
    private final JointLimitParameters spineJointLimitParameters;
    private final JointLimitParameters kneeJointLimitParameters;
    private final JointLimitParameters ankleJointLimitParameters;

    public AtlasWalkingControllerParameters(RobotTarget target, AtlasJointMap jointMap, AtlasContactPointParameters contactPointParameters) {
        this.target = target;
        this.jointMap = jointMap;
        this.massScale = Math.pow(jointMap.getModelScale(), jointMap.getMassScalePower());
        this.momentumOptimizationSettings = new AtlasMomentumOptimizationSettings(jointMap, contactPointParameters.getNumberOfContactableBodies());
        this.minimumHeightAboveGround = jointMap.getModelScale() * 0.705 + 0.084;
        this.nominalHeightAboveGround = jointMap.getModelScale() * 0.7849999999999999 + 0.084;
        this.maximumHeightAboveGround = jointMap.getModelScale() * 0.816 + 0.084;
        this.runningOnRealRobot = target == RobotTarget.REAL_ROBOT;
        this.jointPrivilegedConfigurationParameters = new AtlasJointPrivilegedConfigurationParameters(this.runningOnRealRobot);
        this.toeOffParameters = new AtlasToeOffParameters(jointMap);
        this.swingTrajectoryParameters = new AtlasSwingTrajectoryParameters(target, jointMap.getModelScale());
        this.steppingParameters = new AtlasSteppingParameters(jointMap);
        this.icpOptimizationParameters = new AtlasICPControllerParameters(this.runningOnRealRobot);
        this.stepAdjustmentParameters = new AtlasStepAdjustmentParameters();
        this.kneePrivilegedConfigurationParameters = new OneDoFJointPrivilegedConfigurationParameters();
        this.kneePrivilegedConfigurationParameters.setConfigurationGain(this.runningOnRealRobot ? 40.0 : 150.0);
        this.kneePrivilegedConfigurationParameters.setVelocityGain(6.0);
        this.kneePrivilegedConfigurationParameters.setWeight(5.0);
        this.kneePrivilegedConfigurationParameters.setMaxAcceleration(Double.POSITIVE_INFINITY);
        this.kneePrivilegedConfigurationParameters.setPrivilegedConfigurationOption(PrivilegedConfigurationCommand.PrivilegedConfigurationOption.AT_MID_RANGE);
        this.spineJointLimitParameters = new JointLimitParameters();
        this.spineJointLimitParameters.setMaxAbsJointVelocity(9.0);
        this.spineJointLimitParameters.setJointLimitDistanceForMaxVelocity(Math.toRadians(30.0));
        this.spineJointLimitParameters.setJointLimitFilterBreakFrequency(15.0);
        this.spineJointLimitParameters.setVelocityControlGain(30.0);
        this.kneeJointLimitParameters = new JointLimitParameters();
        this.kneeJointLimitParameters.setMaxAbsJointVelocity(5.0);
        this.kneeJointLimitParameters.setJointLimitDistanceForMaxVelocity(Math.toRadians(30.0));
        this.kneeJointLimitParameters.setJointLimitFilterBreakFrequency(15.0);
        this.kneeJointLimitParameters.setVelocityControlGain(60.0);
        this.kneeJointLimitParameters.setVelocityDeadbandSize(0.6);
        this.ankleJointLimitParameters = new JointLimitParameters();
        this.ankleJointLimitParameters.setMaxAbsJointVelocity(5.0);
        this.ankleJointLimitParameters.setJointLimitDistanceForMaxVelocity(Math.toRadians(20.0));
        this.ankleJointLimitParameters.setJointLimitFilterBreakFrequency(10.0);
        this.ankleJointLimitParameters.setVelocityControlGain(90.0);
        this.ankleJointLimitParameters.setVelocityDeadbandSize(0.6);
        this.ankleJointLimitParameters.setRangeOfMotionMarginFraction(0.02);
        for (RobotSide robotSide : RobotSide.values) {
            RigidBodyTransform transform = new RigidBodyTransform();
            double x = 0.2;
            double y = robotSide.negateIfRightSide(0.35);
            double z = -0.4;
            Vector3D translation = new Vector3D(x, y, z);
            translation.scale(jointMap.getModelScale());
            transform.getTranslation().set((Tuple3DReadOnly)translation);
            RotationMatrix rotation = new RotationMatrix();
            double yaw = 0.0;
            double pitch = 0.7;
            double roll = 0.0;
            rotation.setYawPitchRoll(yaw, pitch, roll);
            transform.getRotation().set((RotationMatrixReadOnly)rotation);
            this.handPosesWithRespectToChestFrame.put((Enum)robotSide, (Object)transform);
        }
    }

    public boolean resubmitStepsInSwingEveryTick() {
        return true;
    }

    public boolean resubmitStepsInTransferEveryTick() {
        return true;
    }

    public double getOmega0() {
        return (this.runningOnRealRobot ? 3.4 : 3.0) / Math.sqrt(this.jointMap.getModelScale());
    }

    public boolean enableToeOffSlippingDetection() {
        return true;
    }

    public ToeSlippingDetectorParameters getToeSlippingDetectorParameters() {
        return new ToeSlippingDetectorParameters();
    }

    public boolean allowDisturbanceRecoveryBySpeedingUpSwing() {
        return true;
    }

    public boolean allowAutomaticManipulationAbort() {
        return true;
    }

    public double getICPErrorThresholdToSpeedUpSwing() {
        return this.jointMap.getModelScale() * 0.05;
    }

    public double getMinimumSwingTimeForDisturbanceRecovery() {
        if (this.runningOnRealRobot) {
            return 0.6;
        }
        return 0.3;
    }

    public double minimumHeightAboveAnkle() {
        return this.minimumHeightAboveGround;
    }

    public double nominalHeightAboveAnkle() {
        return this.nominalHeightAboveGround;
    }

    public double maximumHeightAboveAnkle() {
        return this.maximumHeightAboveGround;
    }

    public double getMaximumLegLengthForSingularityAvoidance() {
        return this.jointMap.getPhysicalProperties().getShinLength() + this.jointMap.getPhysicalProperties().getThighLength();
    }

    public PDGains getCoMHeightControlGains() {
        PDGains gains = new PDGains();
        double kp = 40.0;
        double zeta = this.runningOnRealRobot ? 0.4 : 0.8;
        double maxAcceleration = 4.905;
        double maxJerk = maxAcceleration / 0.05;
        gains.setKp(kp);
        gains.setZeta(zeta);
        gains.setMaximumFeedback(maxAcceleration);
        gains.setMaximumFeedbackRate(maxJerk);
        return gains;
    }

    public List<GroupParameter<PIDGainsReadOnly>> getJointSpaceControlGains() {
        ArrayList<GroupParameter<PIDGainsReadOnly>> jointspaceGains = new ArrayList<GroupParameter<PIDGainsReadOnly>>();
        jointspaceGains.add(new GroupParameter("SpineJoints", this.jointMap.getSpineJointNamesAsStrings()));
        jointspaceGains.add(new GroupParameter("NeckJoints", this.jointMap.getNeckJointNamesAsStrings()));
        jointspaceGains.add(new GroupParameter("ArmJoints", this.jointMap.getArmJointNamesAsStrings()));
        jointspaceGains.add(new GroupParameter("LegJoints", this.jointMap.getLegJointNamesAsStrings()));
        return jointspaceGains;
    }

    public List<GroupParameter<PID3DConfiguration>> getTaskspaceOrientationControlGains() {
        ArrayList<GroupParameter<PID3DConfiguration>> taskspaceAngularGains = new ArrayList<GroupParameter<PID3DConfiguration>>();
        PID3DConfiguration chestAngularGainConfiguration = new PID3DConfiguration(GainCoupling.XY, false);
        taskspaceAngularGains.add(new GroupParameter("Chest", (Object)chestAngularGainConfiguration, this.jointMap.getChestName()));
        PID3DConfiguration headAngularGainConfiguration = new PID3DConfiguration(GainCoupling.XYZ, false);
        taskspaceAngularGains.add(new GroupParameter("Head", (Object)headAngularGainConfiguration, this.jointMap.getHeadName()));
        PID3DConfiguration handAngularGainConfiguration = new PID3DConfiguration(GainCoupling.XYZ, false);
        taskspaceAngularGains.add(new GroupParameter("Hand", (Object)handAngularGainConfiguration, this.jointMap.getHandNames()));
        PID3DConfiguration pelvisAngularGainConfiguration = new PID3DConfiguration(GainCoupling.XY, false);
        taskspaceAngularGains.add(new GroupParameter("Pelvis", (Object)pelvisAngularGainConfiguration, this.jointMap.getPelvisName()));
        return taskspaceAngularGains;
    }

    public List<GroupParameter<PID3DConfiguration>> getTaskspacePositionControlGains() {
        ArrayList<GroupParameter<PID3DConfiguration>> taskspaceLinearGains = new ArrayList<GroupParameter<PID3DConfiguration>>();
        PID3DConfiguration handLinearGainConfiguration = new PID3DConfiguration(GainCoupling.XYZ, false);
        taskspaceLinearGains.add(new GroupParameter("Hand", (Object)handLinearGainConfiguration, this.jointMap.getHandNames()));
        return taskspaceLinearGains;
    }

    public Map<String, RigidBodyControlMode> getDefaultControlModesForRigidBodies() {
        HashMap<String, RigidBodyControlMode> defaultControlModes = new HashMap<String, RigidBodyControlMode>();
        defaultControlModes.put(this.jointMap.getChestName(), RigidBodyControlMode.TASKSPACE);
        return defaultControlModes;
    }

    public TObjectDoubleHashMap<String> getOrCreateJointHomeConfiguration() {
        if (this.jointHomeConfiguration != null) {
            return this.jointHomeConfiguration;
        }
        this.jointHomeConfiguration = new TObjectDoubleHashMap();
        this.jointHomeConfiguration.put((Object)this.jointMap.getSpineJointName(SpineJointName.SPINE_PITCH), 0.0);
        this.jointHomeConfiguration.put((Object)this.jointMap.getSpineJointName(SpineJointName.SPINE_ROLL), 0.0);
        this.jointHomeConfiguration.put((Object)this.jointMap.getSpineJointName(SpineJointName.SPINE_YAW), 0.0);
        this.jointHomeConfiguration.put((Object)this.jointMap.getNeckJointName(NeckJointName.PROXIMAL_NECK_PITCH), this.runningOnRealRobot ? 0.7 : 0.0);
        for (RobotSide robotSide : RobotSide.values) {
            this.jointHomeConfiguration.put((Object)this.jointMap.getArmJointName(robotSide, ArmJointName.SHOULDER_YAW), robotSide.negateIfRightSide(0.785398));
            this.jointHomeConfiguration.put((Object)this.jointMap.getArmJointName(robotSide, ArmJointName.SHOULDER_ROLL), robotSide.negateIfRightSide(-0.52379));
            this.jointHomeConfiguration.put((Object)this.jointMap.getArmJointName(robotSide, ArmJointName.ELBOW_PITCH), 2.33708);
            this.jointHomeConfiguration.put((Object)this.jointMap.getArmJointName(robotSide, ArmJointName.ELBOW_ROLL), robotSide.negateIfRightSide(2.35619));
            this.jointHomeConfiguration.put((Object)this.jointMap.getArmJointName(robotSide, ArmJointName.FIRST_WRIST_PITCH), -0.337807);
            this.jointHomeConfiguration.put((Object)this.jointMap.getArmJointName(robotSide, ArmJointName.WRIST_ROLL), robotSide.negateIfRightSide(0.20773));
            this.jointHomeConfiguration.put((Object)this.jointMap.getArmJointName(robotSide, ArmJointName.SECOND_WRIST_PITCH), -0.026599);
        }
        return this.jointHomeConfiguration;
    }

    public Map<String, Pose3D> getOrCreateBodyHomeConfiguration() {
        if (this.bodyHomeConfiguration != null) {
            return this.bodyHomeConfiguration;
        }
        this.bodyHomeConfiguration = new HashMap<String, Pose3D>();
        Pose3D homeChestPoseInPelvisZUpFrame = new Pose3D();
        if (this.runningOnRealRobot) {
            homeChestPoseInPelvisZUpFrame.appendPitchRotation(Math.toRadians(10.0));
        }
        this.bodyHomeConfiguration.put(this.jointMap.getChestName(), homeChestPoseInPelvisZUpFrame);
        return this.bodyHomeConfiguration;
    }

    public PIDSE3Configuration getSwingFootControlGains() {
        return new PIDSE3Configuration(GainCoupling.XY, false);
    }

    public PIDSE3Configuration getHoldPositionFootControlGains() {
        return new PIDSE3Configuration(GainCoupling.XY, false);
    }

    public PIDSE3Configuration getToeOffFootControlGains() {
        return new PIDSE3Configuration(GainCoupling.XY, false);
    }

    public boolean doPrepareManipulationForLocomotion() {
        return this.doPrepareManipulationForLocomotion;
    }

    public void setDoPrepareManipulationForLocomotion(boolean doPrepareManipulationForLocomotion) {
        this.doPrepareManipulationForLocomotion = doPrepareManipulationForLocomotion;
    }

    public double getDefaultTransferTime() {
        return this.runningOnRealRobot ? 0.8 : 0.25;
    }

    public double getDefaultSwingTime() {
        return this.runningOnRealRobot ? 1.2 : 0.6;
    }

    public FootSwitchFactory getFootSwitchFactory() {
        WrenchBasedFootSwitchFactory footSwitchFactory = new WrenchBasedFootSwitchFactory();
        double contactThresholdForce = 5.0;
        if (this.target == RobotTarget.GAZEBO) {
            contactThresholdForce = 50.0;
        } else if (this.target == RobotTarget.REAL_ROBOT) {
            contactThresholdForce = 80.0;
        }
        footSwitchFactory.setDefaultContactThresholdForce(this.massScale * contactThresholdForce);
        footSwitchFactory.setDefaultCoPThresholdFraction(0.02);
        footSwitchFactory.setDefaultSecondContactThresholdForceIgnoringCoP(this.massScale * (this.runningOnRealRobot ? 220.0 : 180.0));
        return footSwitchFactory;
    }

    public String[] getJointsToIgnoreInController() {
        return new String[0];
    }

    public MomentumOptimizationSettings getMomentumOptimizationSettings() {
        return this.momentumOptimizationSettings;
    }

    public double getMaxICPErrorBeforeSingleSupportForwardX() {
        return 0.035 * this.jointMap.getModelScale();
    }

    public double getMaxICPErrorBeforeSingleSupportInnerY() {
        return 0.015 * this.jointMap.getModelScale();
    }

    public boolean finishSingleSupportWhenICPPlannerIsDone() {
        return false;
    }

    public double getHighCoPDampingDurationToPreventFootShakies() {
        return -1.0;
    }

    public double getCoPErrorThresholdForHighCoPDamping() {
        return Double.POSITIVE_INFINITY;
    }

    public double getMaxAllowedDistanceCMPSupport() {
        return 0.04 * this.jointMap.getModelScale();
    }

    public boolean usePelvisHeightControllerOnly() {
        return false;
    }

    public String[] getJointsWithRestrictiveLimits() {
        String bkxName = this.jointMap.getSpineJointName(SpineJointName.SPINE_ROLL);
        String bkyName = this.jointMap.getSpineJointName(SpineJointName.SPINE_PITCH);
        String leftKnyName = this.jointMap.getLegJointName(RobotSide.LEFT, LegJointName.KNEE_PITCH);
        String rightKnyName = this.jointMap.getLegJointName(RobotSide.RIGHT, LegJointName.KNEE_PITCH);
        String leftAkyName = this.jointMap.getLegJointName(RobotSide.LEFT, LegJointName.ANKLE_PITCH);
        String rightAkyName = this.jointMap.getLegJointName(RobotSide.RIGHT, LegJointName.ANKLE_PITCH);
        String[] joints = new String[]{bkxName, bkyName, leftKnyName, rightKnyName, leftAkyName, rightAkyName};
        return joints;
    }

    public JointLimitParameters getJointLimitParametersForJointsWithRestrictiveLimits(String jointName) {
        if (this.jointMap.getSpineJointName(jointName) == SpineJointName.SPINE_ROLL || this.jointMap.getSpineJointName(jointName) == SpineJointName.SPINE_PITCH) {
            return this.spineJointLimitParameters;
        }
        if (this.jointMap.getLegJointName(jointName) != null) {
            if (this.jointMap.getLegJointName(jointName).getRight() == LegJointName.KNEE_PITCH) {
                return this.kneeJointLimitParameters;
            }
            if (this.jointMap.getLegJointName(jointName).getRight() == LegJointName.ANKLE_PITCH) {
                return this.ankleJointLimitParameters;
            }
        }
        return null;
    }

    public boolean controlToeDuringSwing() {
        return true;
    }

    public JointPrivilegedConfigurationParameters getJointPrivilegedConfigurationParameters() {
        return this.jointPrivilegedConfigurationParameters;
    }

    public OneDoFJointPrivilegedConfigurationParameters getKneePrivilegedConfigurationParameters() {
        return this.kneePrivilegedConfigurationParameters;
    }

    public boolean enableHeightFeedbackControl() {
        return true;
    }

    public ToeOffParameters getToeOffParameters() {
        return this.toeOffParameters;
    }

    public SwingTrajectoryParameters getSwingTrajectoryParameters() {
        return this.swingTrajectoryParameters;
    }

    public ICPControllerParameters getICPControllerParameters() {
        return this.icpOptimizationParameters;
    }

    public StepAdjustmentParameters getStepAdjustmentParameters() {
        return this.stepAdjustmentParameters;
    }

    public SteppingParameters getSteppingParameters() {
        return this.steppingParameters;
    }

    public double getMinSwingTrajectoryClearanceFromStanceFoot() {
        return 0.15;
    }

    public void setJointPrivilegedConfigurationParameters(JointPrivilegedConfigurationParameters jointPrivilegedConfigurationParameters) {
        this.jointPrivilegedConfigurationParameters = jointPrivilegedConfigurationParameters;
    }

    public void setToeOffParameters(ToeOffParameters toeOffParameters) {
        this.toeOffParameters = toeOffParameters;
    }

    public void setSwingTrajectoryParameters(SwingTrajectoryParameters swingTrajectoryParameters) {
        this.swingTrajectoryParameters = swingTrajectoryParameters;
    }

    public void setIcpOptimizationParameters(ICPControllerParameters icpOptimizationParameters) {
        this.icpOptimizationParameters = icpOptimizationParameters;
    }

    public void setSteppingParameters(AtlasSteppingParameters steppingParameters) {
        this.steppingParameters = steppingParameters;
    }

    public double getMaximumVelocityCoMHeight() {
        return 0.5;
    }
}

