/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.parameters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import us.ihmc.atlas.AtlasJointMap;
import us.ihmc.atlas.parameters.AtlasStandPrepSetpoints;
import us.ihmc.commonWalkingControlModules.configurations.GroupParameter;
import us.ihmc.commonWalkingControlModules.configurations.HighLevelControllerParameters;
import us.ihmc.commonWalkingControlModules.controllerCore.parameters.JointAccelerationIntegrationParameters;
import us.ihmc.commonWalkingControlModules.controllerCore.parameters.JointAccelerationIntegrationParametersReadOnly;
import us.ihmc.commonWalkingControlModules.controllerCore.parameters.JointVelocityIntegratorResetMode;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.WholeBodySetpointParameters;
import us.ihmc.humanoidRobotics.communication.packets.dataobjects.HighLevelControllerName;
import us.ihmc.robotics.math.filters.AlphaFilteredYoVariable;
import us.ihmc.robotics.partNames.ArmJointName;
import us.ihmc.robotics.partNames.HumanoidJointNameMap;
import us.ihmc.robotics.partNames.LegJointName;
import us.ihmc.robotics.partNames.NeckJointName;
import us.ihmc.robotics.partNames.SpineJointName;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.sensorProcessing.outputData.JointDesiredBehavior;
import us.ihmc.sensorProcessing.outputData.JointDesiredBehaviorReadOnly;
import us.ihmc.sensorProcessing.outputData.JointDesiredControlMode;

public class AtlasHighLevelControllerParameters
implements HighLevelControllerParameters {
    private final AtlasJointMap jointMap;
    private boolean runningOnRealRobot;

    public AtlasHighLevelControllerParameters(boolean runningOnRealRobot, AtlasJointMap jointMap) {
        this.runningOnRealRobot = runningOnRealRobot;
        this.jointMap = jointMap;
    }

    public WholeBodySetpointParameters getStandPrepParameters() {
        return new AtlasStandPrepSetpoints(this.jointMap);
    }

    public List<GroupParameter<JointDesiredBehaviorReadOnly>> getDesiredJointBehaviors(HighLevelControllerName state) {
        switch (state) {
            case WALKING: {
                return this.getDesiredJointBehaviorForWalking();
            }
            case DO_NOTHING_BEHAVIOR: 
            case FALLING_STATE: {
                return this.getDesiredJointBehaviorForDoNothing();
            }
            case STAND_PREP_STATE: 
            case STAND_READY: 
            case STAND_TRANSITION_STATE: {
                return this.getDesiredJointBehaviorForHangingAround();
            }
        }
        throw new RuntimeException("Implement a desired joint behavior for the high level state " + state);
    }

    private List<GroupParameter<JointDesiredBehaviorReadOnly>> getDesiredJointBehaviorForHangingAround() {
        if (this.runningOnRealRobot) {
            return null;
        }
        ArrayList<GroupParameter<JointDesiredBehaviorReadOnly>> behaviors = new ArrayList<GroupParameter<JointDesiredBehaviorReadOnly>>();
        AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, LegJointName.HIP_YAW, JointDesiredControlMode.POSITION, 500.0, 50.0);
        AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, LegJointName.HIP_ROLL, JointDesiredControlMode.POSITION, 500.0, 50.0);
        AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, LegJointName.HIP_PITCH, JointDesiredControlMode.POSITION, 500.0, 50.0);
        AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, LegJointName.KNEE_PITCH, JointDesiredControlMode.POSITION, 100.0, 50.0);
        AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, LegJointName.ANKLE_PITCH, JointDesiredControlMode.POSITION, 40.0, 10.0);
        AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, LegJointName.ANKLE_ROLL, JointDesiredControlMode.POSITION, 40.0, 10.0);
        AtlasHighLevelControllerParameters.configureBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, SpineJointName.SPINE_YAW, JointDesiredControlMode.POSITION, 1500.0, 150.0);
        AtlasHighLevelControllerParameters.configureBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, SpineJointName.SPINE_PITCH, JointDesiredControlMode.POSITION, 1500.0, 150.0);
        AtlasHighLevelControllerParameters.configureBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, SpineJointName.SPINE_ROLL, JointDesiredControlMode.POSITION, 1500.0, 150.0);
        AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, ArmJointName.SHOULDER_YAW, JointDesiredControlMode.POSITION, 250.0, 25.0);
        AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, ArmJointName.SHOULDER_ROLL, JointDesiredControlMode.POSITION, 500.0, 50.0);
        AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, ArmJointName.ELBOW_PITCH, JointDesiredControlMode.POSITION, 250.0, 25.0);
        AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, ArmJointName.ELBOW_ROLL, JointDesiredControlMode.POSITION, 50.0, 10.0);
        AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, ArmJointName.FIRST_WRIST_PITCH, JointDesiredControlMode.POSITION, 3.0, 0.5);
        AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, ArmJointName.WRIST_ROLL, JointDesiredControlMode.POSITION, 3.0, 0.5);
        AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, ArmJointName.SECOND_WRIST_PITCH, JointDesiredControlMode.POSITION, 3.0, 0.5);
        AtlasHighLevelControllerParameters.configureBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, NeckJointName.PROXIMAL_NECK_PITCH, JointDesiredControlMode.POSITION, 50.0, 10.0);
        return behaviors;
    }

    public List<GroupParameter<JointDesiredBehaviorReadOnly>> getDesiredJointBehaviorsUnderLoad(HighLevelControllerName state) {
        if (state == HighLevelControllerName.WALKING) {
            return this.getDesiredJointBehaviorForWalkingUnderLoad();
        }
        return null;
    }

    private List<GroupParameter<JointDesiredBehaviorReadOnly>> getDesiredJointBehaviorForWalkingUnderLoad() {
        ArrayList<GroupParameter<JointDesiredBehaviorReadOnly>> behaviors = new ArrayList<GroupParameter<JointDesiredBehaviorReadOnly>>();
        if (this.runningOnRealRobot) {
            double maxVelocityError = 1.5;
            AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, this.jointMap, LegJointName.HIP_YAW, JointDesiredControlMode.EFFORT, 0.0, 25.0, maxVelocityError);
            AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, this.jointMap, LegJointName.HIP_ROLL, JointDesiredControlMode.EFFORT, 0.0, 60.0, maxVelocityError);
            AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, this.jointMap, LegJointName.HIP_PITCH, JointDesiredControlMode.EFFORT, 0.0, 100.0, maxVelocityError);
            AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, this.jointMap, LegJointName.KNEE_PITCH, JointDesiredControlMode.EFFORT, 0.0, 100.0, maxVelocityError);
            AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, this.jointMap, LegJointName.ANKLE_PITCH, JointDesiredControlMode.EFFORT, 0.0, 0.0, maxVelocityError);
            AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, this.jointMap, LegJointName.ANKLE_ROLL, JointDesiredControlMode.EFFORT, 0.0, 0.0, maxVelocityError);
        } else {
            AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, LegJointName.HIP_YAW, JointDesiredControlMode.EFFORT, 0.0, 0.0);
            AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, LegJointName.HIP_ROLL, JointDesiredControlMode.EFFORT, 0.0, 0.0);
            AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, LegJointName.HIP_PITCH, JointDesiredControlMode.EFFORT, 0.0, 0.0);
            AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, LegJointName.KNEE_PITCH, JointDesiredControlMode.EFFORT, 0.0, 0.0);
            AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, LegJointName.ANKLE_PITCH, JointDesiredControlMode.EFFORT, 0.0, 0.0);
            AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, LegJointName.ANKLE_ROLL, JointDesiredControlMode.EFFORT, 0.0, 0.0);
        }
        return behaviors;
    }

    private List<GroupParameter<JointDesiredBehaviorReadOnly>> getDesiredJointBehaviorForWalking() {
        ArrayList<GroupParameter<JointDesiredBehaviorReadOnly>> behaviors = new ArrayList<GroupParameter<JointDesiredBehaviorReadOnly>>();
        if (this.runningOnRealRobot) {
            AtlasHighLevelControllerParameters.configureBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, NeckJointName.PROXIMAL_NECK_PITCH, JointDesiredControlMode.POSITION, 0.0, 0.0);
            JointDesiredControlMode armControlMode = JointDesiredControlMode.POSITION;
            double armDamping = 0.0;
            AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, ArmJointName.SHOULDER_YAW, armControlMode, 0.0, armDamping);
            AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, ArmJointName.SHOULDER_ROLL, armControlMode, 0.0, armDamping);
            AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, ArmJointName.ELBOW_PITCH, armControlMode, 0.0, armDamping);
            AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, ArmJointName.ELBOW_ROLL, armControlMode, 0.0, armDamping);
            AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, ArmJointName.FIRST_WRIST_PITCH, armControlMode, 0.0, armDamping);
            AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, ArmJointName.WRIST_ROLL, armControlMode, 0.0, armDamping);
            AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, ArmJointName.SECOND_WRIST_PITCH, armControlMode, 0.0, armDamping);
            AtlasHighLevelControllerParameters.configureBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, SpineJointName.SPINE_YAW, JointDesiredControlMode.EFFORT, 0.0, 0.0);
            AtlasHighLevelControllerParameters.configureBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, SpineJointName.SPINE_PITCH, JointDesiredControlMode.EFFORT, 0.0, 80.0);
            AtlasHighLevelControllerParameters.configureBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, SpineJointName.SPINE_ROLL, JointDesiredControlMode.EFFORT, 0.0, 200.0);
            double maxVelocityError = 1.5;
            AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, this.jointMap, LegJointName.HIP_YAW, JointDesiredControlMode.EFFORT, 0.0, 25.0, maxVelocityError);
            AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, this.jointMap, LegJointName.HIP_ROLL, JointDesiredControlMode.EFFORT, 0.0, 60.0, maxVelocityError);
            AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, this.jointMap, LegJointName.HIP_PITCH, JointDesiredControlMode.EFFORT, 0.0, 100.0, maxVelocityError);
            AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, this.jointMap, LegJointName.KNEE_PITCH, JointDesiredControlMode.EFFORT, 0.0, 100.0, maxVelocityError);
            AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, this.jointMap, LegJointName.ANKLE_PITCH, JointDesiredControlMode.EFFORT, 0.0, 20.0, maxVelocityError);
            AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, this.jointMap, LegJointName.ANKLE_ROLL, JointDesiredControlMode.EFFORT, 0.0, 20.0, maxVelocityError);
        } else {
            AtlasHighLevelControllerParameters.configureBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, NeckJointName.PROXIMAL_NECK_PITCH, JointDesiredControlMode.EFFORT, 0.0, 0.0);
            AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, ArmJointName.SHOULDER_YAW, JointDesiredControlMode.EFFORT, 0.0, 0.0);
            AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, ArmJointName.SHOULDER_ROLL, JointDesiredControlMode.EFFORT, 0.0, 0.0);
            AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, ArmJointName.ELBOW_PITCH, JointDesiredControlMode.EFFORT, 0.0, 0.0);
            AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, ArmJointName.ELBOW_ROLL, JointDesiredControlMode.EFFORT, 0.0, 0.0);
            AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, ArmJointName.FIRST_WRIST_PITCH, JointDesiredControlMode.EFFORT, 0.0, 0.0);
            AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, ArmJointName.WRIST_ROLL, JointDesiredControlMode.EFFORT, 0.0, 0.0);
            AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, ArmJointName.SECOND_WRIST_PITCH, JointDesiredControlMode.EFFORT, 0.0, 0.0);
            AtlasHighLevelControllerParameters.configureBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, SpineJointName.SPINE_YAW, JointDesiredControlMode.EFFORT, 0.0, 0.0);
            AtlasHighLevelControllerParameters.configureBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, SpineJointName.SPINE_PITCH, JointDesiredControlMode.EFFORT, 0.0, 0.0);
            AtlasHighLevelControllerParameters.configureBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, SpineJointName.SPINE_ROLL, JointDesiredControlMode.EFFORT, 0.0, 0.0);
            AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, LegJointName.HIP_YAW, JointDesiredControlMode.EFFORT, 0.0, 0.0);
            AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, LegJointName.HIP_ROLL, JointDesiredControlMode.EFFORT, 0.0, 0.0);
            AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, LegJointName.HIP_PITCH, JointDesiredControlMode.EFFORT, 0.0, 0.0);
            AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, LegJointName.KNEE_PITCH, JointDesiredControlMode.EFFORT, 0.0, 0.0);
            AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, LegJointName.ANKLE_PITCH, JointDesiredControlMode.EFFORT, 0.0, 0.0);
            AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, LegJointName.ANKLE_ROLL, JointDesiredControlMode.EFFORT, 0.0, 0.0);
        }
        return behaviors;
    }

    private List<GroupParameter<JointDesiredBehaviorReadOnly>> getDesiredJointBehaviorForDoNothing() {
        List<String> allJoints = Arrays.asList(this.jointMap.getOrderedJointNames());
        JointDesiredBehavior allJointBehaviors = new JointDesiredBehavior(JointDesiredControlMode.EFFORT);
        ArrayList<GroupParameter<JointDesiredBehaviorReadOnly>> behaviors = new ArrayList<GroupParameter<JointDesiredBehaviorReadOnly>>();
        behaviors.add(new GroupParameter("", (Object)allJointBehaviors, allJoints));
        return behaviors;
    }

    public HighLevelControllerName getDefaultInitialControllerState() {
        return this.runningOnRealRobot ? HighLevelControllerName.DO_NOTHING_BEHAVIOR : HighLevelControllerName.WALKING;
    }

    public HighLevelControllerName getFallbackControllerState() {
        return HighLevelControllerName.DO_NOTHING_BEHAVIOR;
    }

    public boolean automaticallyTransitionToWalkingWhenReady() {
        return false;
    }

    public double getTimeToMoveInStandPrep() {
        return 0.5;
    }

    public double getMinimumTimeInStandReady() {
        return 0.0;
    }

    public double getTimeInStandTransition() {
        return 1.0;
    }

    public double getCalibrationDuration() {
        return 0.0;
    }

    /*
     * WARNING - void declaration
     */
    public List<GroupParameter<JointAccelerationIntegrationParametersReadOnly>> getJointAccelerationIntegrationParameters(HighLevelControllerName state) {
        void var8_24;
        ArmJointName name;
        void var8_22;
        void var7_13;
        void var7_11;
        ArrayList<GroupParameter<JointAccelerationIntegrationParametersReadOnly>> integrationSettings = new ArrayList<GroupParameter<JointAccelerationIntegrationParametersReadOnly>>();
        JointAccelerationIntegrationParameters settings = new JointAccelerationIntegrationParameters();
        settings.setPositionBreakFrequency(AlphaFilteredYoVariable.computeBreakFrequencyGivenAlpha((double)0.9996, (double)0.004));
        settings.setVelocityBreakFrequency(AlphaFilteredYoVariable.computeBreakFrequencyGivenAlpha((double)0.95, (double)0.004));
        settings.setMaxPositionError(0.2);
        settings.setMaxVelocityError(2.0);
        ArrayList<String> neckJointNames = new ArrayList<String>();
        NeckJointName[] neckJointNameArray = this.jointMap.getNeckJointNames();
        int n = neckJointNameArray.length;
        boolean bl = false;
        while (var7_11 < n) {
            NeckJointName neckJointName = neckJointNameArray[var7_11];
            neckJointNames.add(this.jointMap.getNeckJointName(neckJointName));
            ++var7_11;
        }
        integrationSettings.add(new GroupParameter("NeckAccelerationIntegration", (Object)settings, neckJointNames));
        settings = new JointAccelerationIntegrationParameters();
        settings.setPositionBreakFrequency(1.2);
        settings.setVelocityBreakFrequency(2.4);
        settings.setMaxPositionError(0.2);
        settings.setMaxVelocityError(2.0);
        ArrayList<String> shoulderJointNames = new ArrayList<String>();
        neckJointNameArray = new ArmJointName[]{ArmJointName.SHOULDER_YAW, ArmJointName.SHOULDER_ROLL};
        n = neckJointNameArray.length;
        boolean bl2 = false;
        while (var7_13 < n) {
            NeckJointName neckJointName = neckJointNameArray[var7_13];
            for (RobotSide robotSide : RobotSide.values) {
                shoulderJointNames.add(this.jointMap.getArmJointName(robotSide, (ArmJointName)neckJointName));
            }
            ++var7_13;
        }
        integrationSettings.add(new GroupParameter("ShoulderAccelerationIntegration", (Object)settings, shoulderJointNames));
        settings = new JointAccelerationIntegrationParameters();
        settings.setPositionBreakFrequency(1.0);
        settings.setVelocityBreakFrequency(1.25);
        settings.setMaxPositionError(0.2);
        settings.setMaxVelocityError(2.0);
        ArmJointName[] elbowJoints = new ArmJointName[]{ArmJointName.ELBOW_PITCH, ArmJointName.ELBOW_ROLL};
        ArrayList<String> elbowJointNames = new ArrayList<String>();
        ArmJointName[] armJointNameArray = elbowJoints;
        int n2 = armJointNameArray.length;
        boolean bl3 = false;
        while (var8_22 < n2) {
            name = armJointNameArray[var8_22];
            for (RobotSide robotSide : RobotSide.values) {
                elbowJointNames.add(this.jointMap.getArmJointName(robotSide, name));
            }
            ++var8_22;
        }
        integrationSettings.add(new GroupParameter("ElbowAccelerationIntegration", (Object)settings, elbowJointNames));
        settings = new JointAccelerationIntegrationParameters();
        settings.setPositionBreakFrequency(AlphaFilteredYoVariable.computeBreakFrequencyGivenAlpha((double)0.9999, (double)0.004));
        settings.setVelocityBreakFrequency(AlphaFilteredYoVariable.computeBreakFrequencyGivenAlpha((double)0.95, (double)0.004));
        settings.setMaxPositionError(0.2);
        settings.setMaxVelocityError(2.0);
        ArmJointName[] wristJoints = new ArmJointName[]{ArmJointName.FIRST_WRIST_PITCH, ArmJointName.WRIST_ROLL, ArmJointName.SECOND_WRIST_PITCH};
        ArrayList<String> wristJointNames = new ArrayList<String>();
        armJointNameArray = wristJoints;
        int n3 = armJointNameArray.length;
        boolean bl4 = false;
        while (var8_24 < n3) {
            name = armJointNameArray[var8_24];
            for (RobotSide robotSide : RobotSide.values) {
                wristJointNames.add(this.jointMap.getArmJointName(robotSide, name));
            }
            ++var8_24;
        }
        integrationSettings.add(new GroupParameter("WristAccelerationIntegration", (Object)settings, wristJointNames));
        settings = new JointAccelerationIntegrationParameters();
        settings.setVelocityBreakFrequency(AlphaFilteredYoVariable.computeBreakFrequencyGivenAlpha((double)0.985, (double)0.004));
        settings.setMaxVelocityError(2.0);
        integrationSettings.add(new GroupParameter("SpineAccelerationIntegration", (Object)settings, this.jointMap.getSpineJointNamesAsStrings()));
        ArrayList<String> legJoints = new ArrayList<String>();
        for (ArmJointName armJointName : RobotSide.values) {
            legJoints.add(this.jointMap.getLegJointName((RobotSide)armJointName, LegJointName.HIP_YAW));
            legJoints.add(this.jointMap.getLegJointName((RobotSide)armJointName, LegJointName.HIP_ROLL));
            legJoints.add(this.jointMap.getLegJointName((RobotSide)armJointName, LegJointName.HIP_PITCH));
            legJoints.add(this.jointMap.getLegJointName((RobotSide)armJointName, LegJointName.ANKLE_PITCH));
            legJoints.add(this.jointMap.getLegJointName((RobotSide)armJointName, LegJointName.ANKLE_ROLL));
        }
        RobotSide[] settings2 = new JointAccelerationIntegrationParameters();
        settings2.setVelocityBreakFrequency(AlphaFilteredYoVariable.computeBreakFrequencyGivenAlpha((double)0.985, (double)0.004));
        settings2.setMaxVelocityError(5.0);
        integrationSettings.add(new GroupParameter("LegAccelerationIntegration", (Object)settings2, legJoints));
        ArrayList<String> kneeJoints = new ArrayList<String>();
        for (RobotSide robotSide : RobotSide.values) {
            kneeJoints.add(this.jointMap.getLegJointName(robotSide, LegJointName.KNEE_PITCH));
        }
        JointAccelerationIntegrationParameters settings3 = new JointAccelerationIntegrationParameters();
        settings3.setVelocityBreakFrequency(AlphaFilteredYoVariable.computeBreakFrequencyGivenAlpha((double)0.985, (double)0.004));
        settings3.setMaxVelocityError(5.0);
        settings3.setVelocityResetMode(JointVelocityIntegratorResetMode.ZERO_VELOCITY);
        integrationSettings.add(new GroupParameter("KneeAccelerationIntegration", (Object)settings3, kneeJoints));
        return integrationSettings;
    }

    public static void configureBehavior(List<GroupParameter<JointDesiredBehaviorReadOnly>> behaviors, HumanoidJointNameMap jointMap, SpineJointName jointName, JointDesiredControlMode controlMode, double stiffness, double damping) {
        JointDesiredBehavior jointBehavior = new JointDesiredBehavior(controlMode, stiffness, damping);
        List<String> names = Collections.singletonList(jointMap.getSpineJointName(jointName));
        behaviors.add((GroupParameter<JointDesiredBehaviorReadOnly>)new GroupParameter(jointName.toString(), (Object)jointBehavior, names));
    }

    public static void configureBehavior(List<GroupParameter<JointDesiredBehaviorReadOnly>> behaviors, HumanoidJointNameMap jointMap, NeckJointName jointName, JointDesiredControlMode controlMode, double stiffness, double damping) {
        JointDesiredBehavior jointBehavior = new JointDesiredBehavior(controlMode, stiffness, damping);
        List<String> names = Collections.singletonList(jointMap.getNeckJointName(jointName));
        behaviors.add((GroupParameter<JointDesiredBehaviorReadOnly>)new GroupParameter(jointName.toString(), (Object)jointBehavior, names));
    }

    public static void configureSymmetricBehavior(List<GroupParameter<JointDesiredBehaviorReadOnly>> behaviors, HumanoidJointNameMap jointMap, LegJointName jointName, JointDesiredControlMode controlMode, double stiffness, double damping) {
        AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, jointMap, jointName, controlMode, stiffness, damping, Double.POSITIVE_INFINITY);
    }

    public static void configureSymmetricBehavior(List<GroupParameter<JointDesiredBehaviorReadOnly>> behaviors, HumanoidJointNameMap jointMap, LegJointName jointName, JointDesiredControlMode controlMode, double stiffness, double damping, double maxVelocityError) {
        JointDesiredBehavior jointBehavior = new JointDesiredBehavior(controlMode, stiffness, damping);
        jointBehavior.setMaxVelocityError(maxVelocityError);
        behaviors.add((GroupParameter<JointDesiredBehaviorReadOnly>)new GroupParameter(jointName.toString(), (Object)jointBehavior, AtlasHighLevelControllerParameters.getLeftAndRightJointNames(jointMap, jointName)));
    }

    public static void configureSymmetricBehavior(List<GroupParameter<JointDesiredBehaviorReadOnly>> behaviors, HumanoidJointNameMap jointMap, ArmJointName jointName, JointDesiredControlMode controlMode, double stiffness, double damping) {
        JointDesiredBehavior jointBehavior = new JointDesiredBehavior(controlMode, stiffness, damping);
        behaviors.add((GroupParameter<JointDesiredBehaviorReadOnly>)new GroupParameter(jointName.toString(), (Object)jointBehavior, AtlasHighLevelControllerParameters.getLeftAndRightJointNames(jointMap, jointName)));
    }

    public static List<String> getLeftAndRightJointNames(HumanoidJointNameMap jointMap, LegJointName legJointName) {
        ArrayList<String> jointNames = new ArrayList<String>();
        for (RobotSide side : RobotSide.values) {
            jointNames.add(jointMap.getLegJointName(side, legJointName));
        }
        return jointNames;
    }

    public static List<String> getLeftAndRightJointNames(HumanoidJointNameMap jointMap, ArmJointName armJointName) {
        ArrayList<String> jointNames = new ArrayList<String>();
        for (RobotSide side : RobotSide.values) {
            jointNames.add(jointMap.getArmJointName(side, armJointName));
        }
        return jointNames;
    }
}

