/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.jfxvisualizer;

import atlas_msgs.msg.dds.AtlasLowLevelControlModeMessage;
import atlas_msgs.msg.dds.BDIBehaviorCommandPacket;
import controller_msgs.msg.dds.AbortWalkingMessage;
import controller_msgs.msg.dds.PauseWalkingMessage;
import us.ihmc.communication.HumanoidControllerAPI;
import us.ihmc.communication.controllerAPI.RobotLowLevelMessenger;
import us.ihmc.humanoidRobotics.communication.packets.HumanoidMessageTools;
import us.ihmc.humanoidRobotics.communication.packets.atlas.AtlasLowLevelControlMode;
import us.ihmc.ros2.ROS2PublisherBasics;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.ros2.RealtimeROS2Node;

public class AtlasLowLevelMessenger
implements RobotLowLevelMessenger {
    private final ROS2PublisherBasics<AtlasLowLevelControlModeMessage> lowLevelModePublisher;
    private final ROS2PublisherBasics<BDIBehaviorCommandPacket> bdiBehaviorPublisher;
    private final ROS2PublisherBasics<AbortWalkingMessage> abortWalkingPublisher;
    private final ROS2PublisherBasics<PauseWalkingMessage> pauseWalkingPublisher;

    public AtlasLowLevelMessenger(RealtimeROS2Node ros2Node, String robotName) {
        ROS2Topic inputTopic = HumanoidControllerAPI.getInputTopic((String)robotName);
        this.lowLevelModePublisher = ros2Node.createPublisher(inputTopic.withTypeName(AtlasLowLevelControlModeMessage.class));
        this.bdiBehaviorPublisher = ros2Node.createPublisher(inputTopic.withTypeName(BDIBehaviorCommandPacket.class));
        this.abortWalkingPublisher = ros2Node.createPublisher(inputTopic.withTypeName(AbortWalkingMessage.class));
        this.pauseWalkingPublisher = ros2Node.createPublisher(inputTopic.withTypeName(PauseWalkingMessage.class));
    }

    public void sendFreezeRequest() {
        AtlasLowLevelControlModeMessage message = new AtlasLowLevelControlModeMessage();
        message.setRequestedAtlasLowLevelControlMode(AtlasLowLevelControlMode.FREEZE.toByte());
        this.lowLevelModePublisher.publish((Object)message);
    }

    public void sendStandRequest() {
        AtlasLowLevelControlModeMessage message = new AtlasLowLevelControlModeMessage();
        message.setRequestedAtlasLowLevelControlMode(AtlasLowLevelControlMode.STAND_PREP.toByte());
        this.lowLevelModePublisher.publish((Object)message);
    }

    public void sendShutdownRequest() {
        BDIBehaviorCommandPacket message = HumanoidMessageTools.createBDIBehaviorCommandPacket((boolean)true);
        this.bdiBehaviorPublisher.publish((Object)message);
    }

    public void sendAbortWalkingRequest() {
        this.abortWalkingPublisher.publish((Object)new AbortWalkingMessage());
    }

    public void sendPauseWalkingRequest() {
        PauseWalkingMessage message = new PauseWalkingMessage();
        message.setPause(true);
        this.pauseWalkingPublisher.publish((Object)message);
    }

    public void sendContinueWalkingRequest() {
        PauseWalkingMessage message = new PauseWalkingMessage();
        message.setPause(false);
        this.pauseWalkingPublisher.publish((Object)message);
    }
}

