/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.jfxvisualizer;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.atomic.AtomicReference;
import map_sense.RawGPUPlanarRegionList;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.LittleEndianHeapChannelBuffer;
import org.ros.internal.message.Message;
import org.ros.message.Duration;
import org.ros.message.Time;
import perception_msgs.msg.dds.PlanarRegionsListMessage;
import sensor_msgs.PointCloud2;
import us.ihmc.atlas.AtlasRobotModel;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.ROS2SyncedRobotModel;
import us.ihmc.avatar.ros.RosTfPublisher;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.configuration.NetworkParameters;
import us.ihmc.communication.packets.PlanarRegionMessageConverter;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.log.LogTools;
import us.ihmc.perception.depthData.PointCloudData;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotEnvironmentAwareness.communication.REACommunicationProperties;
import us.ihmc.robotEnvironmentAwareness.updaters.GPUPlanarRegionUpdater;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.ROS2PublisherBasics;
import us.ihmc.utilities.ros.RosMainNode;
import us.ihmc.utilities.ros.RosTools;
import us.ihmc.utilities.ros.publisher.RosClockPublisher;
import us.ihmc.utilities.ros.publisher.RosPointCloudPublisher;
import us.ihmc.utilities.ros.publisher.RosTopicPublisher;
import us.ihmc.utilities.ros.subscriber.AbstractRosTopicSubscriber;
import us.ihmc.utilities.ros.subscriber.RosTopicSubscriberInterface;
import us.ihmc.utilities.ros.types.PointType;

public class AtlasHeightMapTopicConverter {
    private static boolean debug = false;
    private static final String atlasPelvisFrame = "pelvis";
    private static final String atlasOusterFrame = "ouster";

    public AtlasHeightMapTopicConverter() throws URISyntaxException {
        URI rosuri = NetworkParameters.getROSURI();
        System.out.println("ROS MASTER URI " + rosuri);
        RosMainNode rosNode = RosTools.createRosNode((URI)rosuri, (String)"ouster_turtle_sim");
        final AtomicReference<PointCloud2> inputPointCloud = new AtomicReference<PointCloud2>();
        final MutableInt counter = new MutableInt();
        rosNode.attachSubscriber("/os_cloud_node/points", (RosTopicSubscriberInterface)new AbstractRosTopicSubscriber<PointCloud2>("sensor_msgs/PointCloud2"){

            public void onNewMessage(PointCloud2 pointCloud) {
                counter.increment();
                inputPointCloud.set(pointCloud);
            }
        });
        AtlasHeightMapTopicConverter.setupForRealRobot(rosNode, inputPointCloud);
        rosNode.execute();
    }

    private static void setupForTurtleSim(RosMainNode rosNode, AtomicReference<PointCloud2> inputPointCloud) {
        RosPointCloudPublisher publisher = new RosPointCloudPublisher(PointType.XYZI, false);
        rosNode.attachPublisher("/os_cloud_node2/points", (RosTopicPublisher)publisher);
        RigidBodyTransform approxOusterTransform = new RigidBodyTransform();
        double ousterPitch = Math.toRadians(30.0);
        approxOusterTransform.getRotation().setToPitchOrientation(ousterPitch);
        approxOusterTransform.getTranslation().set(-0.2, 0.0, 1.6);
        MutableInt counter = new MutableInt();
        new Thread(() -> {
            while (true) {
                PointCloud2 pointCloud;
                if ((pointCloud = (PointCloud2)inputPointCloud.getAndSet(null)) != null) {
                    System.out.println("publishing " + counter.intValue());
                    counter.increment();
                    PointCloudData pointCloudData = new PointCloudData(pointCloud, 1000000, false);
                    pointCloudData.applyTransform(approxOusterTransform);
                    PointCloud2 message = AtlasHeightMapTopicConverter.packMessage((PointCloud2)publisher.getMessage(), pointCloudData.getPointCloud());
                    pointCloud.getHeader().setFrameId("base_footprint");
                    message.getHeader().setStamp(rosNode.getCurrentTime());
                    publisher.publish((Message)message);
                }
                ThreadTools.sleep((long)25L);
            }
        }).start();
    }

    private static void setupForAtlasSim(RosMainNode ros1Node, AtomicReference<PointCloud2> inputPointCloud) {
        RosClockPublisher rosClockPublisher = new RosClockPublisher();
        ros1Node.attachPublisher("/clock", (RosTopicPublisher)rosClockPublisher);
        new Thread(() -> {
            while (!ros1Node.isStarted()) {
                LogTools.info((String)"waiting to connect...");
                ThreadTools.sleep((long)500L);
            }
            while (true) {
                if (inputPointCloud.get() == null) {
                    continue;
                }
                Time timestamp = ((PointCloud2)inputPointCloud.get()).getHeader().getStamp();
                timestamp.add(new Duration(0.03));
                rosClockPublisher.publish(timestamp);
            }
        }).start();
    }

    private static void setupForRealRobot(RosMainNode ros1Node, AtomicReference<PointCloud2> inputPointCloud) {
        ROS2Node ros2Node = ROS2Tools.createROS2Node((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS, (String)"height_map");
        ROS2SyncedRobotModel syncedRobot = new ROS2SyncedRobotModel((DRCRobotModel)new AtlasRobotModel(AtlasRobotVersion.ATLAS_UNPLUGGED_V5_NO_HANDS), (ROS2NodeInterface)ros2Node);
        RosPointCloudPublisher publisher = new RosPointCloudPublisher(PointType.XYZI, false);
        ros1Node.attachPublisher("/os_cloud_node2/points", (RosTopicPublisher)publisher);
        GPUPlanarRegionUpdater gpuPlanarRegionUpdater = new GPUPlanarRegionUpdater();
        final AtomicReference regionsReference = new AtomicReference();
        AbstractRosTopicSubscriber<RawGPUPlanarRegionList> mapsenseSubscriber = new AbstractRosTopicSubscriber<RawGPUPlanarRegionList>("map_sense/RawGPUPlanarRegionList"){

            public void onNewMessage(RawGPUPlanarRegionList rawGPUPlanarRegionList) {
                regionsReference.set(rawGPUPlanarRegionList);
            }
        };
        ros1Node.attachSubscriber("/mapsense/planar_regions", (RosTopicSubscriberInterface)mapsenseSubscriber);
        RigidBodyTransform transformChestToL515DepthCamera = new RigidBodyTransform();
        transformChestToL515DepthCamera.setIdentity();
        transformChestToL515DepthCamera.getTranslation().set(0.275, 0.052, 0.14);
        transformChestToL515DepthCamera.getRotation().setYawPitchRoll(0.01, 1.1519, 0.045);
        ReferenceFrame steppingFrame = ReferenceFrameTools.constructFrameWithChangingTransformToParent((String)"steppingCamera", (ReferenceFrame)syncedRobot.getReferenceFrames().getChestFrame(), (RigidBodyTransformReadOnly)transformChestToL515DepthCamera);
        RigidBodyTransform zForwardXRightToZUpXForward = new RigidBodyTransform();
        zForwardXRightToZUpXForward.appendPitchRotation(1.5707963267948966);
        zForwardXRightToZUpXForward.appendYawRotation(-1.5707963267948966);
        ROS2PublisherBasics regionsPublisher = ros2Node.createPublisher(REACommunicationProperties.outputTopic.withTypeName(PlanarRegionsListMessage.class));
        RosTfPublisher tfPublisher = new RosTfPublisher(ros1Node, null);
        new Thread(() -> {
            while (!ros1Node.isStarted()) {
                LogTools.info((String)"waiting to connect...");
                ThreadTools.sleep((long)500L);
            }
            while (true) {
                PointCloud2 pointCloud = inputPointCloud.getAndSet(null);
                RawGPUPlanarRegionList regions = regionsReference.getAndSet(null);
                if (pointCloud != null || regions != null) {
                    syncedRobot.update();
                }
                if (pointCloud != null) {
                    ReferenceFrame ousterFrame = syncedRobot.getReferenceFrames().getOusterLidarFrame();
                    RigidBodyTransform ousterToWorld = ousterFrame.getTransformToWorldFrame();
                    if (debug) {
                        System.out.println(ousterToWorld);
                    }
                    Time currentTime = ros1Node.getCurrentTime();
                    long timestamp = currentTime.totalNsecs();
                    LogTools.info((String)"Broadcasting height map message");
                    tfPublisher.publish(ousterToWorld, timestamp, "odom", "os_sensor");
                    pointCloud.getHeader().setStamp(currentTime);
                    publisher.publish((Message)pointCloud);
                }
                if (regions != null) {
                    PlanarRegionsList planarRegionsList = gpuPlanarRegionUpdater.generatePlanarRegions(regions);
                    planarRegionsList.applyTransform((RigidBodyTransformReadOnly)zForwardXRightToZUpXForward);
                    planarRegionsList.applyTransform((RigidBodyTransformReadOnly)steppingFrame.getTransformToWorldFrame());
                    PlanarRegionsListMessage planarRegionsListMessage = PlanarRegionMessageConverter.convertToPlanarRegionsListMessage((PlanarRegionsList)planarRegionsList);
                    regionsPublisher.publish((Object)planarRegionsListMessage);
                    LogTools.info((String)"Broadcasting mapsense regions");
                }
                ThreadTools.sleep((long)350L);
            }
        }).start();
    }

    private static PointCloud2 packMessage(PointCloud2 message, Point3D[] points) {
        message.getHeader().setFrameId("base_footprint");
        PointType pointType = PointType.XYZI;
        message.setHeight(1);
        message.setWidth(points.length);
        message.setPointStep(pointType.getPointStep());
        int dataLength = pointType.getPointStep() * points.length;
        message.setRowStep(dataLength);
        message.setIsBigendian(false);
        message.setIsDense(true);
        message.setFields(pointType.getPointField());
        LittleEndianHeapChannelBuffer buffer = new LittleEndianHeapChannelBuffer(dataLength);
        for (int i = 0; i < points.length; ++i) {
            buffer.writeFloat((float)points[i].getX());
            buffer.writeFloat((float)points[i].getY());
            buffer.writeFloat((float)points[i].getZ());
            buffer.writeFloat(100.0f);
        }
        message.setData((ChannelBuffer)buffer);
        return message;
    }

    public static void main(String[] args) throws URISyntaxException {
        new AtlasHeightMapTopicConverter();
    }
}

