/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.jfxvisualizer;

import java.util.List;
import javafx.application.Platform;
import javafx.stage.Stage;
import org.apache.commons.lang3.tuple.Triple;
import perception_msgs.msg.dds.REAStateRequestMessage;
import us.ihmc.atlas.AtlasRobotModel;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.atlas.jfxvisualizer.AtlasLowLevelMessenger;
import us.ihmc.atlas.parameters.AtlasUIAuxiliaryData;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.avatar.networkProcessor.footstepPlanningModule.FootstepPlanningModuleLauncher;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.footstepPlanning.AStarBodyPathPlannerParametersBasics;
import us.ihmc.footstepPlanning.FootstepPlannerOutput;
import us.ihmc.footstepPlanning.FootstepPlannerTerminationCondition;
import us.ihmc.footstepPlanning.FootstepPlanningModule;
import us.ihmc.footstepPlanning.communication.FootstepPlannerMessagerAPI;
import us.ihmc.footstepPlanning.graphSearch.parameters.DefaultFootstepPlannerParametersBasics;
import us.ihmc.footstepPlanning.log.FootstepPlannerLogger;
import us.ihmc.footstepPlanning.swing.SwingPlannerParametersBasics;
import us.ihmc.footstepPlanning.ui.FootstepPlannerUI;
import us.ihmc.footstepPlanning.ui.RemoteUIMessageConverter;
import us.ihmc.footstepPlanning.ui.UIAuxiliaryRobotData;
import us.ihmc.javaFXToolkit.ApplicationNoModule;
import us.ihmc.messager.Messager;
import us.ihmc.messager.javafx.JavaFXMessager;
import us.ihmc.messager.javafx.SharedMemoryJavaFXMessager;
import us.ihmc.perception.depthData.CollisionBoxProvider;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotEnvironmentAwareness.communication.REACommunicationProperties;
import us.ihmc.robotModels.FullHumanoidRobotModelFactory;
import us.ihmc.robotics.partNames.HumanoidJointNameMap;
import us.ihmc.ros2.ROS2PublisherBasics;
import us.ihmc.ros2.RealtimeROS2Node;
import us.ihmc.wholeBodyController.RobotContactPointParameters;

public class AtlasFootstepPlannerUI
extends ApplicationNoModule {
    private static final double GOAL_DISTANCE_PROXIMITY = 0.1;
    private SharedMemoryJavaFXMessager messager;
    private RemoteUIMessageConverter messageConverter;
    private FootstepPlannerUI ui;
    private FootstepPlanningModule plannerModule;

    public void start(Stage primaryStage) throws Exception {
        List parameters = this.getParameters().getRaw();
        boolean launchPlannerToolbox = parameters == null || !parameters.contains(AtlasFootstepPlannerUI.getSuppressToolboxFlag());
        AtlasRobotModel drcRobotModel = new AtlasRobotModel(AtlasRobotVersion.ATLAS_UNPLUGGED_V5_NO_HANDS, RobotTarget.REAL_ROBOT, false);
        AtlasRobotModel previewModel = new AtlasRobotModel(AtlasRobotVersion.ATLAS_UNPLUGGED_V5_NO_HANDS, RobotTarget.REAL_ROBOT, false);
        this.messager = new SharedMemoryJavaFXMessager(FootstepPlannerMessagerAPI.API);
        RealtimeROS2Node ros2Node = ROS2Tools.createRealtimeROS2Node((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS, (String)"ihmc_footstep_planner_ui");
        AtlasLowLevelMessenger robotLowLevelMessenger = new AtlasLowLevelMessenger(ros2Node, drcRobotModel.getSimpleRobotName());
        ROS2PublisherBasics reaStateRequestPublisher = ros2Node.createPublisher(REACommunicationProperties.inputTopic.withTypeName(REAStateRequestMessage.class));
        this.messageConverter = new RemoteUIMessageConverter(ros2Node, (Messager)this.messager, drcRobotModel.getSimpleRobotName());
        this.messager.startMessager();
        this.messager.submitMessage(FootstepPlannerMessagerAPI.GoalDistanceProximity, (Object)0.1);
        this.ui = FootstepPlannerUI.createUI((Stage)primaryStage, (JavaFXMessager)this.messager, (AStarBodyPathPlannerParametersBasics)drcRobotModel.getAStarBodyPathPlannerParameters(), (DefaultFootstepPlannerParametersBasics)drcRobotModel.getFootstepPlannerParameters("ForLookAndStep"), (SwingPlannerParametersBasics)drcRobotModel.getSwingPlannerParameters(), (FullHumanoidRobotModelFactory)drcRobotModel, (FullHumanoidRobotModelFactory)previewModel, (HumanoidJointNameMap)drcRobotModel.getJointMap(), (RobotContactPointParameters)drcRobotModel.getContactPointParameters(), (WalkingControllerParameters)drcRobotModel.getWalkingControllerParameters(), (UIAuxiliaryRobotData)new AtlasUIAuxiliaryData(), (CollisionBoxProvider)drcRobotModel.getCollisionBoxProvider());
        this.ui.show();
        if (launchPlannerToolbox) {
            this.plannerModule = FootstepPlanningModuleLauncher.createModule((DRCRobotModel)drcRobotModel, (DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS);
            FootstepPlannerLogger logger = new FootstepPlannerLogger(this.plannerModule);
            Runnable loggerRunnable = () -> logger.logSessionAndReportToMessager((Messager)this.messager);
            this.messager.addTopicListener(FootstepPlannerMessagerAPI.RequestGenerateLog, b -> new Thread(loggerRunnable).start());
            this.messager.addTopicListener(FootstepPlannerMessagerAPI.PlanSingleStep, planSingleStep -> {
                if (planSingleStep.booleanValue()) {
                    FootstepPlannerTerminationCondition terminationCondition = (plannerTime, iterations, bestPathFinalStep, bestSecondToFinalStep, bestPathSize) -> bestPathSize >= 1;
                    this.plannerModule.addCustomTerminationCondition(terminationCondition);
                } else {
                    this.plannerModule.clearCustomTerminationConditions();
                }
            });
            this.plannerModule.addStatusCallback(status -> this.handleMessagerCallbacks(this.plannerModule, (FootstepPlannerOutput)status));
        }
    }

    private void handleMessagerCallbacks(FootstepPlanningModule planningModule, FootstepPlannerOutput status) {
        if (status.getFootstepPlanningResult() != null && status.getFootstepPlanningResult().terminalResult()) {
            this.messager.submitMessage(FootstepPlannerMessagerAPI.GraphData, (Object)Triple.of((Object)planningModule.getEdgeDataMap(), (Object)planningModule.getIterationData(), (Object)planningModule.getFootstepPlanVariableDescriptors()));
        }
    }

    public void stop() throws Exception {
        super.stop();
        this.messager.closeMessager();
        this.messageConverter.destroy();
        this.ui.stop();
        if (this.plannerModule != null) {
            this.plannerModule.closeAndDispose();
        }
        Platform.exit();
    }

    public static String getSuppressToolboxFlag() {
        return "suppressToolbox";
    }

    public static void main(String[] args) {
        AtlasFootstepPlannerUI.launch((String[])args);
    }
}

