/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.initialSetup;

import us.ihmc.avatar.initialSetup.HumanoidRobotInitialSetup;
import us.ihmc.robotics.partNames.ArmJointName;
import us.ihmc.robotics.partNames.HumanoidJointNameMap;
import us.ihmc.robotics.partNames.LegJointName;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.scs2.definition.robot.RobotDefinition;

public class AtlasSimInitialSetup
extends HumanoidRobotInitialSetup {
    public AtlasSimInitialSetup(RobotDefinition robotDefinition, HumanoidJointNameMap jointMap) {
        super(jointMap);
        for (RobotSide robotSide : RobotSide.values) {
            this.setJoint(robotSide, LegJointName.HIP_YAW, robotSide.negateIfRightSide(0.0));
            this.setJoint(robotSide, LegJointName.HIP_ROLL, robotSide.negateIfRightSide(0.062));
            this.setJoint(robotSide, LegJointName.HIP_PITCH, -0.233);
            this.setJoint(robotSide, LegJointName.KNEE_PITCH, 0.518);
            this.setJoint(robotSide, LegJointName.ANKLE_PITCH, -0.276);
            this.setJoint(robotSide, LegJointName.ANKLE_ROLL, robotSide.negateIfRightSide(-0.062));
            this.setJoint(robotSide, ArmJointName.SHOULDER_YAW, robotSide.negateIfRightSide(0.785398));
            this.setJoint(robotSide, ArmJointName.SHOULDER_ROLL, robotSide.negateIfRightSide(-0.52379));
            this.setJoint(robotSide, ArmJointName.ELBOW_PITCH, 2.33708);
            this.setJoint(robotSide, ArmJointName.ELBOW_ROLL, robotSide.negateIfRightSide(2.35619));
            this.setJoint(robotSide, ArmJointName.FIRST_WRIST_PITCH, -0.337807);
            this.setJoint(robotSide, ArmJointName.WRIST_ROLL, robotSide.negateIfRightSide(0.20773));
            this.setJoint(robotSide, ArmJointName.SECOND_WRIST_PITCH, -0.026599);
        }
        this.setRootJointHeightSuchThatLowestSoleIsAtZero(robotDefinition);
    }
}

