/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas;

import java.io.File;
import java.io.PrintWriter;
import us.ihmc.atlas.AtlasRobotModelFactory;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.simulationConstructionSetTools.util.HumanoidFloatingRootJointRobot;

public class DRCRobotModelFileInvestigator {
    public void writeModelFile(DRCRobotModel model) {
        try {
            String filename = "scsRobotModelOutputs/scsRobot_" + model;
            File file = new File(filename);
            PrintWriter printWriter = new PrintWriter(file);
            HumanoidFloatingRootJointRobot robot = model.createHumanoidFloatingRootJointRobot(false);
            printWriter.println(robot);
            printWriter.close();
        }
        catch (Exception e) {
            System.err.println("Caught exception with model " + model);
            e.printStackTrace();
        }
    }

    public void writeAllModelFiles() {
        for (String st : AtlasRobotModelFactory.getAvailableRobotModels()) {
            this.writeModelFile(AtlasRobotModelFactory.createDRCRobotModel(st, RobotTarget.SCS, false));
        }
    }

    public static void main(String[] args) {
        DRCRobotModelFileInvestigator investigator = new DRCRobotModelFileInvestigator();
        investigator.writeAllModelFiles();
    }
}

