/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas;

import java.util.List;
import java.util.function.Consumer;
import us.ihmc.atlas.AtlasJointMap;
import us.ihmc.atlas.parameters.AtlasSensorInformation;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.scs2.definition.geometry.ModelFileGeometryDefinition;
import us.ihmc.scs2.definition.robot.CameraSensorDefinition;
import us.ihmc.scs2.definition.robot.IMUSensorDefinition;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.MomentOfInertiaDefinition;
import us.ihmc.scs2.definition.robot.RigidBodyDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.robot.SensorDefinition;
import us.ihmc.scs2.definition.robot.WrenchSensorDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinition;
import us.ihmc.simulationToolkit.RobotDefinitionTools;

public class AtlasRobotDefinitionMutator
implements Consumer<RobotDefinition> {
    private final AtlasJointMap jointMap;
    private final AtlasSensorInformation sensorInformation;

    public AtlasRobotDefinitionMutator(AtlasJointMap jointMap, AtlasSensorInformation sensorInformation) {
        this.jointMap = jointMap;
        this.sensorInformation = sensorInformation;
    }

    @Override
    public void accept(RobotDefinition robotDefinition) {
        for (RigidBodyDefinition body : robotDefinition.getAllRigidBodies()) {
            List cameras;
            for (VisualDefinition visual : body.getVisualDefinitions()) {
                if (!(visual.getGeometryDefinition() instanceof ModelFileGeometryDefinition)) continue;
                ModelFileGeometryDefinition geometry = (ModelFileGeometryDefinition)visual.getGeometryDefinition();
                geometry.setFileName(geometry.getFileName().replace(".dae", ".obj"));
            }
            if (body.getParentJoint() == null || (cameras = body.getParentJoint().getSensorDefinitions(CameraSensorDefinition.class)) == null || cameras.isEmpty()) continue;
            for (CameraSensorDefinition camera : cameras) {
                camera.setClipFar(100000.0);
                camera.setUpdatePeriod(40);
            }
        }
        this.mutateChest(robotDefinition.getRigidBodyDefinition(this.jointMap.getChestName()));
        this.modifyHokuyoInertia(robotDefinition.getRigidBodyDefinition("hokuyo_link"));
        List imus = robotDefinition.getRigidBodyDefinition(this.jointMap.getPelvisName()).getParentJoint().getSensorDefinitions(IMUSensorDefinition.class);
        this.modifyLeftForearm(robotDefinition.getRigidBodyDefinition("l_lfarm"));
        this.modifyRightForearm(robotDefinition.getRigidBodyDefinition("r_lfarm"));
        this.modifyLeftHand(robotDefinition.getRigidBodyDefinition("l_hand"));
        this.modifyRightHand(robotDefinition.getRigidBodyDefinition("r_hand"));
        for (IMUSensorDefinition imu : imus) {
            if (!imu.getName().equals("imu_sensor")) continue;
            imu.setName("imu_sensor_at_pelvis_frame");
        }
        for (String forceSensorName : this.sensorInformation.getForceSensorNames()) {
            JointDefinition jointDefinition = robotDefinition.getJointDefinition(forceSensorName);
            jointDefinition.addSensorDefinition((SensorDefinition)new WrenchSensorDefinition(forceSensorName, (RigidBodyTransformReadOnly)new RigidBodyTransform()));
        }
        if (this.jointMap.getModelScale() != 1.0) {
            RobotDefinitionTools.scaleRobotDefinition((RobotDefinition)robotDefinition, (double)this.jointMap.getModelScale(), (double)this.jointMap.getMassScalePower(), j -> !j.getName().contains("hokuyo"));
        }
    }

    private void modifyLeftHand(RigidBodyDefinition leftHand) {
        if (leftHand == null) {
            return;
        }
        leftHand.setMass(2.7);
        leftHand.getInertiaPose().setToZero();
        leftHand.getInertiaPose().getTranslation().set(0.0, 0.04, 0.0);
    }

    private void modifyRightHand(RigidBodyDefinition rightHand) {
        if (rightHand == null) {
            return;
        }
        rightHand.setMass(2.7);
        rightHand.getInertiaPose().setToZero();
        rightHand.getInertiaPose().getTranslation().set(0.0, -0.04, 0.0);
    }

    private void modifyLeftForearm(RigidBodyDefinition leftForearm) {
        if (leftForearm == null) {
            return;
        }
        leftForearm.setMass(1.6);
    }

    private void modifyRightForearm(RigidBodyDefinition rightForearm) {
        if (rightForearm == null) {
            return;
        }
        rightForearm.setMass(1.6);
    }

    private void mutateChest(RigidBodyDefinition chest) {
        chest.getInertiaPose().setToZero();
        chest.setCenterOfMassOffset(0.017261, 0.0032352, 0.3483);
        chest.setMass(60.009);
        double ixx = 1.5;
        double ixy = 0.0;
        double ixz = 0.1;
        double iyy = 1.5;
        double iyz = 0.0;
        double izz = 0.5;
        chest.setMomentOfInertia(new MomentOfInertiaDefinition(ixx, iyy, izz, ixy, ixz, iyz));
        this.addChestIMU(chest);
    }

    private void addChestIMU(RigidBodyDefinition chest) {
        IMUSensorDefinition chestIMU = new IMUSensorDefinition();
        chestIMU.setName("imu_sensor_chest");
        chestIMU.getTransformToJoint().getTranslation().set(-0.15, 0.0, 0.3);
        chestIMU.getTransformToJoint().getRotation().setYawPitchRoll(-1.5707963267948966, 0.0, 1.5707963267948966);
        chest.getParentJoint().addSensorDefinition((SensorDefinition)chestIMU);
    }

    private void modifyHokuyoInertia(RigidBodyDefinition hokuyo) {
        double ixx = 4.01606E-4;
        double iyy = 0.00208115;
        double izz = 0.00178402;
        double ixy = 4.9927E-8;
        double ixz = 1.0997E-5;
        double iyz = -9.8165E-9;
        hokuyo.setMomentOfInertia(new MomentOfInertiaDefinition(ixx, iyy, izz, ixy, ixz, iyz));
    }
}

