/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas;

import controller_msgs.msg.dds.RobotConfigurationData;
import geometry_msgs.PoseWithCovarianceStamped;
import java.net.URI;
import java.util.concurrent.atomic.AtomicReference;
import org.ros.internal.message.Message;
import org.ros.message.Time;
import sensor_msgs.PointCloud2;
import std_msgs.Header;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.communication.HumanoidControllerAPI;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.configuration.NetworkParameters;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.utilities.ros.RosMainNode;
import us.ihmc.utilities.ros.RosTools;
import us.ihmc.utilities.ros.publisher.RosPointCloudPublisher;
import us.ihmc.utilities.ros.publisher.RosTf2Publisher;
import us.ihmc.utilities.ros.publisher.RosTopicPublisher;
import us.ihmc.utilities.ros.subscriber.RosPointCloudSubscriber;
import us.ihmc.utilities.ros.subscriber.RosTopicSubscriberInterface;
import us.ihmc.utilities.ros.types.PointType;

public class AtlasROS1MappingTopics {
    private static final String MAP_FRAME = "odom";
    private static final String ROBOT_FRAME_ID = "os_sensor";
    private static final String ROBOT_POSE_WITH_COVARIANCE_TOPIC = "robot_pose";
    private static final String OUSTER_TOPIC_IN = "/os_cloud_node/points";
    private static final String OUSTER_TOPIC_OUT = "ouster/points";

    public AtlasROS1MappingTopics() {
        URI rosuri = NetworkParameters.getROSURI();
        RosMainNode ros1Node = RosTools.createRosNode((URI)rosuri, (String)"atlas_topics");
        RosPoseStampedPublisher poseStampedPublisher = new RosPoseStampedPublisher(false);
        RosTf2Publisher tf2Publisher = new RosTf2Publisher(false);
        RosPointCloudPublisher pointCloudPublisher = new RosPointCloudPublisher(PointType.XYZRGB, false);
        final AtomicReference<Object> pointCloudHolder = new AtomicReference<Object>();
        RosPointCloudSubscriber pointCloudSubscriber = new RosPointCloudSubscriber(){

            public void onNewMessage(PointCloud2 pointCloud) {
                pointCloudHolder.set(pointCloud);
            }
        };
        ros1Node.attachPublisher(ROBOT_POSE_WITH_COVARIANCE_TOPIC, (RosTopicPublisher)poseStampedPublisher);
        ros1Node.attachPublisher("/tf", (RosTopicPublisher)tf2Publisher);
        ros1Node.attachPublisher(OUSTER_TOPIC_OUT, (RosTopicPublisher)pointCloudPublisher);
        ros1Node.attachSubscriber(OUSTER_TOPIC_IN, (RosTopicSubscriberInterface)pointCloudSubscriber);
        AtomicReference<RobotConfigurationData> robotConfigurationDataHolder = new AtomicReference<RobotConfigurationData>(new RobotConfigurationData());
        ROS2Node ros2Node = ROS2Tools.createROS2Node((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS, (String)"atlas_topics2");
        ros2Node.createSubscription(HumanoidControllerAPI.getOutputTopic((String)"Atlas").withTypeName(RobotConfigurationData.class), s -> robotConfigurationDataHolder.set((RobotConfigurationData)s.takeNextData()));
        ros1Node.execute();
        while (true) {
            if (ros1Node.isStarted()) {
                RobotConfigurationData robotConfigurationData = robotConfigurationDataHolder.get();
                if (robotConfigurationData != null) {
                    poseStampedPublisher.publish(MAP_FRAME, (Tuple3DReadOnly)robotConfigurationData.getRootPosition(), (QuaternionReadOnly)robotConfigurationData.getRootOrientation());
                }
                RigidBodyTransform transform = new RigidBodyTransform();
                transform.getRotation().setToPitchOrientation(Math.toRadians(45.0));
                tf2Publisher.publish(transform, Time.fromMillis((long)System.currentTimeMillis()).totalNsecs(), MAP_FRAME, ROBOT_FRAME_ID);
                PointCloud2 pointCloud = pointCloudHolder.getAndSet(null);
                if (pointCloud != null) {
                    System.out.println("publishing outster points");
                    pointCloud.getHeader().setStamp(Time.fromMillis((long)System.currentTimeMillis()));
                    pointCloudPublisher.publish((Message)pointCloud);
                }
            }
            ThreadTools.sleep((long)100L);
        }
    }

    public static void main(String[] args) {
        new AtlasROS1MappingTopics();
    }

    private static class RosPoseStampedPublisher
    extends RosTopicPublisher<PoseWithCovarianceStamped> {
        private final PoseWithCovarianceStamped initialValue;
        private int seq = 0;
        private double[] covariance = new double[36];

        public RosPoseStampedPublisher(boolean latched) {
            this(latched, null);
            double cov = 0.05;
            for (int i = 0; i < 6; ++i) {
                this.covariance[i + 6 * i] = cov;
            }
        }

        public RosPoseStampedPublisher(boolean latched, PoseWithCovarianceStamped initialValue) {
            super("geometry_msgs/PoseWithCovarianceStamped", latched);
            this.initialValue = initialValue;
        }

        public void connected() {
            if (this.initialValue != null) {
                this.publish((Message)this.initialValue);
            }
        }

        public void publish(String frameID, Tuple3DReadOnly translation, QuaternionReadOnly orientation) {
            PoseWithCovarianceStamped message = (PoseWithCovarianceStamped)this.getMessage();
            Header header = message.getHeader();
            message.getHeader().setStamp(Time.fromMillis((long)System.currentTimeMillis()));
            header.setFrameId(frameID);
            header.setSeq(this.seq++);
            message.setHeader(header);
            message.getPose().setCovariance(this.covariance);
            message.getPose().getPose().getPosition().setX(translation.getX());
            message.getPose().getPose().getPosition().setY(translation.getY());
            message.getPose().getPose().getPosition().setZ(translation.getZ());
            message.getPose().getPose().getOrientation().setX(orientation.getX());
            message.getPose().getPose().getOrientation().setY(orientation.getY());
            message.getPose().getPose().getOrientation().setZ(orientation.getZ());
            message.getPose().getPose().getOrientation().setW(orientation.getS());
            this.publish((Message)message);
        }
    }
}

