/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.velocityControlEvaluation;

import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.simulationconstructionset.ExternalForcePoint;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.Link;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SliderJoint;

public class VelocityControlEvaluationRobot
extends Robot {
    private static final long serialVersionUID = -2717723504360444704L;
    public static final double MASS = 10.0;
    public static final double STICTION = 60.0;
    private final SliderJoint rootJoint = new SliderJoint("x", (Tuple3DReadOnly)new Vector3D(), (Robot)this, (Vector3DReadOnly)Axis3D.X);

    public VelocityControlEvaluationRobot() {
        super("VelocityControlEvaluationRobot");
        this.rootJoint.setStiction(60.0);
        Link pointMass = new Link("pointMass");
        pointMass.setMass(10.0);
        pointMass.setMomentOfInertia(0.0, 0.0, 0.0);
        pointMass.setComOffset((Vector3DReadOnly)new Vector3D());
        Graphics3DObject linkGraphics = new Graphics3DObject();
        linkGraphics.addSphere(0.03);
        pointMass.setLinkGraphics(linkGraphics);
        ExternalForcePoint externalForce = new ExternalForcePoint("externalForce", this.getRobotsYoRegistry());
        this.rootJoint.addExternalForcePoint(externalForce);
        this.rootJoint.setLink(pointMass);
        this.addRootJoint((Joint)this.rootJoint);
    }

    public void setTau(double tau) {
        this.rootJoint.setTau(tau);
    }

    public double getX() {
        return this.rootJoint.getQYoVariable().getDoubleValue();
    }

    public double getXDot() {
        return this.rootJoint.getQDYoVariable().getDoubleValue();
    }
}

