/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.sensors;

import controller_msgs.msg.dds.StereoVisionPointCloudMessage;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicReference;
import org.bytedeco.javacpp.BytePointer;
import org.jboss.netty.buffer.ChannelBuffer;
import perception_msgs.msg.dds.LidarScanMessage;
import sensor_msgs.Image;
import sensor_msgs.PointCloud2;
import us.ihmc.atlas.AtlasRobotModel;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.ROS2SyncedRobotModel;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.behaviors.tools.CommunicationHelper;
import us.ihmc.communication.PerceptionAPI;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.configuration.NetworkParameters;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.humanoidRobotics.frames.HumanoidReferenceFrames;
import us.ihmc.perception.depthData.PointCloudData;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.tools.UnitConversions;
import us.ihmc.tools.thread.MissingThreadTools;
import us.ihmc.tools.thread.ResettableExceptionHandlingExecutorService;
import us.ihmc.tools.thread.Throttler;
import us.ihmc.utilities.ros.RosMainNode;
import us.ihmc.utilities.ros.RosTools;
import us.ihmc.utilities.ros.subscriber.AbstractRosTopicSubscriber;
import us.ihmc.utilities.ros.subscriber.RosPointCloudSubscriber;
import us.ihmc.utilities.ros.subscriber.RosTopicSubscriberInterface;

public class AtlasOusterL515ZED2FusedColoredROS1ToREABridge {
    private static final double REA_OUTPUT_FREQUENCY = UnitConversions.hertzToSeconds((double)10.0);

    public AtlasOusterL515ZED2FusedColoredROS1ToREABridge() {
        RosMainNode ros1Node = RosTools.createRosNode((URI)NetworkParameters.getROSURI(), (String)"ousterl515_to_rea");
        ROS2Node ros2Node = ROS2Tools.createROS2Node((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS, (String)"ousterl515_to_rea");
        AtlasRobotModel robotModel = new AtlasRobotModel(AtlasRobotVersion.ATLAS_UNPLUGGED_V5_DUAL_ROBOTIQ, RobotTarget.REAL_ROBOT);
        final CommunicationHelper ros2Helper = new CommunicationHelper((DRCRobotModel)robotModel, (ROS2NodeInterface)ros2Node);
        final ROS2SyncedRobotModel syncedRobot = ros2Helper.newSyncedRobot();
        final RigidBodyTransform l515ToWorldTransform = new RigidBodyTransform();
        final RigidBodyTransform ousterToWorldTransform = new RigidBodyTransform();
        final Throttler throttler = new Throttler();
        final AtomicReference latestL515PointCloud = new AtomicReference();
        final AtomicReference latestZED2Image = new AtomicReference();
        final ResettableExceptionHandlingExecutorService executor = MissingThreadTools.newSingleThreadExecutor((String)"OusterL515ToREABridge", (boolean)true);
        AbstractRosTopicSubscriber<Image> zed2LeftEyeSubscriber = new AbstractRosTopicSubscriber<Image>("sensor_msgs/Image"){

            public void onNewMessage(Image image) {
                latestZED2Image.set(image);
            }
        };
        ros1Node.attachSubscriber("/zed/color/left/image_raw", (RosTopicSubscriberInterface)zed2LeftEyeSubscriber);
        AbstractRosTopicSubscriber<PointCloud2> l515Subscriber = new AbstractRosTopicSubscriber<PointCloud2>("sensor_msgs/PointCloud2"){

            public void onNewMessage(PointCloud2 pointCloud2) {
                latestL515PointCloud.set(pointCloud2);
            }
        };
        ros1Node.attachSubscriber("/chest_l515/depth/color/points", (RosTopicSubscriberInterface)l515Subscriber);
        AbstractRosTopicSubscriber<PointCloud2> ousterSubscriber = new AbstractRosTopicSubscriber<PointCloud2>("sensor_msgs/PointCloud2"){

            public void onNewMessage(PointCloud2 pointCloud2) {
                if (throttler.run(REA_OUTPUT_FREQUENCY)) {
                    executor.submit(() -> {
                        syncedRobot.update();
                        FramePose3DReadOnly l515Pose = syncedRobot.getFramePoseReadOnly(HumanoidReferenceFrames::getSteppingCameraFrame);
                        l515Pose.get((RigidBodyTransformBasics)l515ToWorldTransform);
                        FramePose3DReadOnly ousterPose = syncedRobot.getFramePoseReadOnly(HumanoidReferenceFrames::getOusterLidarFrame);
                        ousterPose.get((RigidBodyTransformBasics)ousterToWorldTransform);
                        PointCloud2 latestL515PointCloud2 = (PointCloud2)latestL515PointCloud.get();
                        Image zed2Image = (Image)latestZED2Image.get();
                        Point3D[] l515Points = null;
                        if (latestL515PointCloud2 != null && zed2Image != null) {
                            ChannelBuffer l515NettyImageData = latestL515PointCloud2.getData();
                            ByteBuffer l515DataByteBuffer = l515NettyImageData.toByteBuffer();
                            int arrayOffset = l515NettyImageData.arrayOffset();
                            l515DataByteBuffer.position(arrayOffset);
                            ByteBuffer offsetByteBuffer = l515DataByteBuffer.slice();
                            BytePointer imageDataPointer = new BytePointer(offsetByteBuffer);
                            RosPointCloudSubscriber.UnpackedPointCloud unpackPointsAndIntensities = RosPointCloudSubscriber.unpackPointsAndIntensities((PointCloud2)latestL515PointCloud2);
                            l515Points = unpackPointsAndIntensities.getPoints();
                            for (int i = 0; i < l515Points.length; ++i) {
                                double x = l515Points[i].getX();
                                double y = l515Points[i].getY();
                                double z = l515Points[i].getZ();
                                l515Points[i].set(z, -x, -y);
                                l515Points[i].applyTransform((Transform)l515ToWorldTransform);
                            }
                            StereoVisionPointCloudMessage fusedPointCloudMessage = new StereoVisionPointCloudMessage();
                            PointCloudData pointCloudData = new PointCloudData(pointCloud2, 1600000, true);
                            pointCloudData.applyTransform(ousterToWorldTransform);
                            LidarScanMessage lidarScanMessage = pointCloudData.toLidarScanMessage(null, l515Points);
                            lidarScanMessage.getLidarPosition().set((Tuple3DReadOnly)ousterPose.getPosition());
                            lidarScanMessage.getLidarOrientation().set((QuaternionReadOnly)ousterPose.getOrientation());
                            lidarScanMessage.setSensorPoseConfidence(1.0);
                            ros2Helper.publish(PerceptionAPI.MULTISENSE_LIDAR_SCAN, (Object)lidarScanMessage);
                        }
                    });
                }
            }
        };
        ros1Node.attachSubscriber("/os_cloud_node/points", (RosTopicSubscriberInterface)ousterSubscriber);
        ros1Node.execute();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            executor.destroy();
            ros1Node.shutdown();
        }, "IHMC-OusterROS1ToREABridgeShutdown"));
    }

    public static void main(String[] args) {
        new AtlasOusterL515ZED2FusedColoredROS1ToREABridge();
    }
}

