/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.parameters;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.referenceFrame.FrameBox3D;
import us.ihmc.euclid.referenceFrame.FrameCapsule3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotics.geometry.shapes.FrameSTPBox3D;
import us.ihmc.robotics.partNames.ArmJointName;
import us.ihmc.robotics.partNames.HumanoidJointNameMap;
import us.ihmc.robotics.partNames.LegJointName;
import us.ihmc.robotics.physics.Collidable;
import us.ihmc.robotics.physics.CollidableHelper;
import us.ihmc.robotics.physics.RobotCollisionModel;
import us.ihmc.robotics.robotSide.RobotSide;

public class AtlasSimulationCollisionModel
implements RobotCollisionModel {
    private final HumanoidJointNameMap jointMap;
    private CollidableHelper helper;
    private String[] otherCollisionMasks;
    private String robotCollisionMask;
    private AtlasRobotVersion atlasRobotVersion;

    public AtlasSimulationCollisionModel(HumanoidJointNameMap jointMap, AtlasRobotVersion atlasRobotVersion) {
        this.jointMap = jointMap;
        this.atlasRobotVersion = atlasRobotVersion;
    }

    public void setCollidableHelper(CollidableHelper helper, String robotCollisionMask, String ... otherCollisionMasks) {
        this.helper = helper;
        this.robotCollisionMask = robotCollisionMask;
        this.otherCollisionMasks = otherCollisionMasks;
    }

    public List<Collidable> getRobotCollidables(MultiBodySystemBasics multiBodySystem) {
        ArrayList<Collidable> collidables = new ArrayList<Collidable>();
        long collisionMask = this.helper.getCollisionMask(this.robotCollisionMask);
        long collisionGroup = this.helper.createCollisionGroup(this.otherCollisionMasks);
        RigidBodyBasics torso = RobotCollisionModel.findRigidBody((String)this.jointMap.getChestName(), (MultiBodySystemBasics)multiBodySystem);
        MovingReferenceFrame torsoFrame = torso.getParentJoint().getFrameAfterJoint();
        FrameBox3D chestCoreShape = new FrameBox3D((ReferenceFrame)torsoFrame, 0.4, 0.35, 0.5);
        chestCoreShape.getPosition().set(-0.093, 0.0, 0.28);
        collidables.add(new Collidable(torso, collisionMask, collisionGroup, (FrameShape3DReadOnly)chestCoreShape));
        FrameBox3D chestFrontLowShape = new FrameBox3D((ReferenceFrame)torsoFrame, 0.12, 0.2, 0.3);
        chestFrontLowShape.getPosition().set(0.197, 0.0, 0.158);
        chestFrontLowShape.getOrientation().setQuaternion(0.0, 0.1, 0.0, 1.0);
        collidables.add(new Collidable(torso, collisionMask, collisionGroup, (FrameShape3DReadOnly)chestFrontLowShape));
        FrameCapsule3D chestFrontHighShape = new FrameCapsule3D((ReferenceFrame)torsoFrame, 0.3, 0.15);
        chestFrontHighShape.getPosition().set(0.147, 0.0, 0.418);
        chestFrontHighShape.getAxis().set((UnitVector3DReadOnly)Axis3D.Y);
        collidables.add(new Collidable(torso, collisionMask, collisionGroup, (FrameShape3DReadOnly)chestFrontHighShape));
        FrameBox3D chestTopBackShape = new FrameBox3D((ReferenceFrame)torsoFrame, 0.5, 0.35, 0.18);
        chestTopBackShape.getPosition().set(-0.043, 0.0, 0.598);
        collidables.add(new Collidable(torso, collisionMask, collisionGroup, (FrameShape3DReadOnly)chestTopBackShape));
        FrameCapsule3D chestHeadGuardShape = new FrameCapsule3D((ReferenceFrame)torsoFrame, 0.3, 0.08);
        chestHeadGuardShape.getPosition().set(0.267, 0.0, 0.623);
        chestHeadGuardShape.getAxis().set((UnitVector3DReadOnly)Axis3D.Y);
        collidables.add(new Collidable(torso, collisionMask, collisionGroup, (FrameShape3DReadOnly)chestHeadGuardShape));
        FrameBox3D chestTopShape = new FrameBox3D((ReferenceFrame)torsoFrame, 0.3, 0.35, 0.15);
        chestTopShape.getPosition().set(0.087, 0.0, 0.758);
        collidables.add(new Collidable(torso, collisionMask, collisionGroup, (FrameShape3DReadOnly)chestTopShape));
        RigidBodyBasics pelvis = RobotCollisionModel.findRigidBody((String)this.jointMap.getPelvisName(), (MultiBodySystemBasics)multiBodySystem);
        MovingReferenceFrame pelvisFrame = pelvis.getParentJoint().getFrameAfterJoint();
        FrameCapsule3D pelvisShape = new FrameCapsule3D((ReferenceFrame)pelvisFrame, 0.05, 0.2);
        pelvisShape.getPosition().set(0.012, 0.0, 0.037);
        pelvisShape.getAxis().set((UnitVector3DReadOnly)Axis3D.Z);
        collidables.add(new Collidable(pelvis, collisionMask, collisionGroup, (FrameShape3DReadOnly)pelvisShape));
        for (RobotSide robotSide : RobotSide.values) {
            JointBasics hipPitch = RobotCollisionModel.findJoint((String)this.jointMap.getLegJointName(robotSide, LegJointName.HIP_PITCH), (MultiBodySystemBasics)multiBodySystem);
            MovingReferenceFrame hipPitchFrame = hipPitch.getFrameAfterJoint();
            RigidBodyBasics thigh = hipPitch.getSuccessor();
            FrameCapsule3D thighTopShape = new FrameCapsule3D((ReferenceFrame)hipPitchFrame, 0.1, 0.09);
            thighTopShape.getPosition().set(0.0, 0.0, -0.1);
            thighTopShape.getAxis().set((UnitVector3DReadOnly)Axis3D.Z);
            collidables.add(new Collidable(thigh, collisionMask, collisionGroup, (FrameShape3DReadOnly)thighTopShape));
            FrameCapsule3D thighFrontShape = new FrameCapsule3D((ReferenceFrame)hipPitchFrame, 0.15, 0.085);
            thighFrontShape.getPosition().set(-0.018, 0.0, -0.25);
            thighFrontShape.getAxis().set((Tuple3DReadOnly)new Vector3D(0.22, 0.0, 1.0));
            collidables.add(new Collidable(thigh, collisionMask, collisionGroup, (FrameShape3DReadOnly)thighFrontShape));
            FrameCapsule3D thighBackShape = new FrameCapsule3D((ReferenceFrame)hipPitchFrame, 0.15, 0.085);
            thighBackShape.getPosition().set(-0.05, 0.0, -0.15);
            thighBackShape.getAxis().set((UnitVector3DReadOnly)Axis3D.Z);
            collidables.add(new Collidable(thigh, collisionMask, collisionGroup, (FrameShape3DReadOnly)thighBackShape));
            JointBasics kneePitch = RobotCollisionModel.findJoint((String)this.jointMap.getLegJointName(robotSide, LegJointName.KNEE_PITCH), (MultiBodySystemBasics)multiBodySystem);
            MovingReferenceFrame kneePitchFrame = kneePitch.getFrameAfterJoint();
            RigidBodyBasics shin = kneePitch.getSuccessor();
            FrameCapsule3D shinShape = new FrameCapsule3D((ReferenceFrame)kneePitchFrame, 0.3, 0.08);
            shinShape.getPosition().set(0.015, 0.0, -0.2);
            shinShape.getAxis().set((Tuple3DReadOnly)new Vector3D(0.1, 0.0, 1.0));
            collidables.add(new Collidable(shin, collisionMask, collisionGroup, (FrameShape3DReadOnly)shinShape));
            JointBasics ankleRoll = RobotCollisionModel.findJoint((String)this.jointMap.getLegJointName(robotSide, LegJointName.ANKLE_ROLL), (MultiBodySystemBasics)multiBodySystem);
            MovingReferenceFrame ankleRollFrame = ankleRoll.getFrameAfterJoint();
            RigidBodyBasics foot = ankleRoll.getSuccessor();
            FrameSTPBox3D footShape = new FrameSTPBox3D((ReferenceFrame)ankleRollFrame, 0.26, 0.14, 0.055);
            footShape.getPosition().set(0.045, 0.0, -0.05);
            footShape.setMargins(1.0E-5, 4.0E-4);
            collidables.add(new Collidable(foot, collisionMask, collisionGroup, (FrameShape3DReadOnly)footShape));
        }
        for (RobotSide robotSide : RobotSide.values) {
            JointBasics shoulderRoll = RobotCollisionModel.findJoint((String)this.jointMap.getArmJointName(robotSide, ArmJointName.SHOULDER_ROLL), (MultiBodySystemBasics)multiBodySystem);
            MovingReferenceFrame shoulderRollFrame = shoulderRoll.getFrameAfterJoint();
            RigidBodyBasics upperArm = shoulderRoll.getSuccessor();
            FrameCapsule3D upperArmShape = new FrameCapsule3D((ReferenceFrame)shoulderRollFrame, 0.27, 0.07);
            upperArmShape.getPosition().set(-0.005, robotSide.negateIfRightSide(0.15), -0.01);
            upperArmShape.getAxis().set((UnitVector3DReadOnly)Axis3D.Y);
            collidables.add(new Collidable(upperArm, collisionMask, collisionGroup, (FrameShape3DReadOnly)upperArmShape));
            JointBasics elbowJoint = RobotCollisionModel.findJoint((String)this.jointMap.getArmJointName(robotSide, ArmJointName.ELBOW_ROLL), (MultiBodySystemBasics)multiBodySystem);
            MovingReferenceFrame elbowFrame = elbowJoint.getFrameAfterJoint();
            RigidBodyBasics forearm = elbowJoint.getSuccessor();
            FrameCapsule3D forearmShape = new FrameCapsule3D((ReferenceFrame)elbowFrame, 0.27, 0.07);
            forearmShape.getPosition().set(-0.005, robotSide.negateIfRightSide(0.15), -0.01);
            forearmShape.getAxis().set((UnitVector3DReadOnly)Axis3D.Y);
            collidables.add(new Collidable(forearm, collisionMask, collisionGroup, (FrameShape3DReadOnly)forearmShape));
            if (!this.atlasRobotVersion.hasRobotiqHands(robotSide)) continue;
            JointBasics lastWristJoint = RobotCollisionModel.findJoint((String)this.jointMap.getArmJointName(robotSide, ArmJointName.SECOND_WRIST_PITCH), (MultiBodySystemBasics)multiBodySystem);
            MovingReferenceFrame wristFrame = lastWristJoint.getFrameAfterJoint();
            RigidBodyBasics hand = lastWristJoint.getSuccessor();
            FrameBox3D handShape = new FrameBox3D((ReferenceFrame)wristFrame, 0.125, 0.1, 0.125);
            handShape.getPosition().set(0.0, robotSide.negateIfRightSide(0.17), 0.0);
            collidables.add(new Collidable(hand, collisionMask, collisionGroup, (FrameShape3DReadOnly)handShape));
        }
        return collidables;
    }
}

