/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.logDataProcessing;

import us.ihmc.avatar.logProcessor.LogDataProcessorFunction;
import us.ihmc.avatar.logProcessor.LogDataProcessorHelper;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.YoPlaneContactState;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.controlModules.foot.ExplorationParameters;
import us.ihmc.commonWalkingControlModules.controlModules.foot.FootControlModule;
import us.ihmc.commonWalkingControlModules.controlModules.foot.PartialFootholdControlModule;
import us.ihmc.commonWalkingControlModules.momentumBasedController.HighLevelHumanoidControllerToolbox;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.yoVariables.registry.YoRegistry;

public class FootRotationProcessor
implements LogDataProcessorFunction {
    private final String name = this.getClass().getSimpleName();
    private final YoRegistry registry = new YoRegistry(this.name);
    private final YoGraphicsListRegistry yoGraphicsListRegistry = new YoGraphicsListRegistry();
    private final SideDependentList<PartialFootholdControlModule> partialFootholdControlModules = new SideDependentList();
    private final HighLevelHumanoidControllerToolbox controllerToolbox;
    private final LogDataProcessorHelper logDataProcessorHelper;
    private final FramePoint2D measuredCoP2d = new FramePoint2D();
    private final FramePoint2D desiredCoP2d = new FramePoint2D();

    public FootRotationProcessor(LogDataProcessorHelper logDataProcessorHelper) {
        this.logDataProcessorHelper = logDataProcessorHelper;
        WalkingControllerParameters walkingControllerParameters = logDataProcessorHelper.getWalkingControllerParameters();
        this.controllerToolbox = logDataProcessorHelper.getHighLevelHumanoidControllerToolbox();
        ExplorationParameters explorationParameters = new ExplorationParameters(this.registry);
        for (RobotSide robotSide : RobotSide.values) {
            PartialFootholdControlModule partialFootholdControlModule = new PartialFootholdControlModule(robotSide, this.controllerToolbox, walkingControllerParameters, explorationParameters, this.registry, this.yoGraphicsListRegistry);
            this.partialFootholdControlModules.put((Enum)robotSide, (Object)partialFootholdControlModule);
        }
    }

    public void processDataAtControllerRate() {
        this.logDataProcessorHelper.update();
        for (RobotSide robotSide : RobotSide.values) {
            PartialFootholdControlModule partialFootholdControlModule = (PartialFootholdControlModule)this.partialFootholdControlModules.get((Enum)robotSide);
            if (this.logDataProcessorHelper.getCurrenFootState(robotSide) == FootControlModule.ConstraintType.FULL) {
                this.logDataProcessorHelper.getMeasuredCoP(robotSide, this.measuredCoP2d);
                this.logDataProcessorHelper.getDesiredCoP(robotSide, this.desiredCoP2d);
                partialFootholdControlModule.compute(this.desiredCoP2d, this.measuredCoP2d);
                YoPlaneContactState contactState = (YoPlaneContactState)this.controllerToolbox.getFootContactStates().get((Enum)robotSide);
                boolean contactStateHasChanged = partialFootholdControlModule.applyShrunkPolygon(contactState);
                if (!contactStateHasChanged) continue;
                contactState.notifyContactStateHasChanged();
                continue;
            }
            partialFootholdControlModule.reset();
        }
    }

    public void processDataAtStateEstimatorRate() {
    }

    public YoRegistry getYoVariableRegistry() {
        return this.registry;
    }

    public YoGraphicsListRegistry getYoGraphicsListRegistry() {
        return this.yoGraphicsListRegistry;
    }
}

