/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.handControl.sandia;

import java.util.ArrayList;
import java.util.EnumMap;
import us.ihmc.avatar.handControl.FingerJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.robotModels.FullRobotModel;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.sensors.ForceSensorDataReadOnly;

public class SandiaHandModel {
    private final EnumMap<SandiaFingerName, EnumMap<SandiaFingerJointName, FingerJoint>> handJoints = new EnumMap(SandiaFingerName.class);
    private final ArrayList<FingerJoint> allJoints = new ArrayList();
    private final ForceSensorDataReadOnly wristForceSensor;
    private final OneDoFJointBasics wristJoint;
    private final RobotSide robotSide;

    public SandiaHandModel(FullRobotModel fullRobotModel, ForceSensorDataReadOnly forceSensorDataForController, RobotSide robotSide) {
        this.robotSide = robotSide;
        String prefix = robotSide == RobotSide.LEFT ? "left_" : "right_";
        this.addFingerJoints(fullRobotModel, prefix + "f3", SandiaFingerName.THUMB);
        this.addFingerJoints(fullRobotModel, prefix + "f0", SandiaFingerName.INDEX);
        this.addFingerJoints(fullRobotModel, prefix + "f1", SandiaFingerName.MIDDLE);
        this.addFingerJoints(fullRobotModel, prefix + "f2", SandiaFingerName.RING);
        this.wristForceSensor = forceSensorDataForController;
        this.wristJoint = fullRobotModel.getOneDoFJointByName(robotSide.getShortLowerCaseName() + "_arm_wrx");
    }

    private FingerJoint addFingerJoint(String name, FullRobotModel fullRobotModel) {
        FingerJoint fingerJoint = new FingerJoint(name);
        OneDoFJointBasics oneDoFJoint = fullRobotModel.getOneDoFJointByName(name);
        this.allJoints.add(fingerJoint);
        return fingerJoint;
    }

    private void addFingerJoints(FullRobotModel fullRobotModel, String prefix, SandiaFingerName finger) {
        EnumMap<SandiaFingerJointName, FingerJoint> fingerJoints = new EnumMap<SandiaFingerJointName, FingerJoint>(SandiaFingerJointName.class);
        fingerJoints.put(SandiaFingerJointName.BASEJOINT, this.addFingerJoint(prefix + "_j0", fullRobotModel));
        fingerJoints.put(SandiaFingerJointName.FIRSTJOINT, this.addFingerJoint(prefix + "_j1", fullRobotModel));
        fingerJoints.put(SandiaFingerJointName.SECONDJOINT, this.addFingerJoint(prefix + "_j2", fullRobotModel));
        this.handJoints.put(finger, fingerJoints);
    }

    public EnumMap<SandiaFingerJointName, FingerJoint> getFingerJoints(SandiaFingerName finger) {
        return this.handJoints.get((Object)finger);
    }

    public RobotSide getRobotSide() {
        return this.robotSide;
    }

    public OneDoFJointBasics getWristJoint() {
        return this.wristJoint;
    }

    public ForceSensorDataReadOnly getWristForceSensor() {
        return this.wristForceSensor;
    }

    public ArrayList<FingerJoint> getHandJoints() {
        return this.allJoints;
    }

    public EnumMap<SandiaFingerName, EnumMap<SandiaFingerJointName, FingerJoint>> getJointMap() {
        return this.handJoints;
    }

    public static enum SandiaFingerName {
        THUMB,
        INDEX,
        MIDDLE,
        RING;

        public static final SandiaFingerName[] fingers;

        public int getNumber() {
            switch (this) {
                case THUMB: {
                    return 3;
                }
                case INDEX: {
                    return 0;
                }
                case MIDDLE: {
                    return 1;
                }
                case RING: {
                    return 2;
                }
            }
            throw new RuntimeException("Unhandled Case");
        }

        public String getShortName() {
            switch (this) {
                case THUMB: {
                    return "f3";
                }
                case INDEX: {
                    return "f0";
                }
                case MIDDLE: {
                    return "f1";
                }
                case RING: {
                    return "f2";
                }
            }
            throw new RuntimeException("Unhandled Case");
        }

        static {
            fingers = new SandiaFingerName[]{INDEX, MIDDLE, RING};
        }
    }

    public static enum SandiaFingerJointName {
        BASEJOINT,
        FIRSTJOINT,
        SECONDJOINT;


        public int getNumber() {
            switch (this) {
                case BASEJOINT: {
                    return 0;
                }
                case FIRSTJOINT: {
                    return 1;
                }
                case SECONDJOINT: {
                    return 2;
                }
            }
            throw new RuntimeException("Unhandled Case");
        }

        public String getShortName() {
            switch (this) {
                case BASEJOINT: {
                    return "j0";
                }
                case FIRSTJOINT: {
                    return "j1";
                }
                case SECONDJOINT: {
                    return "j2";
                }
            }
            throw new RuntimeException("Unhandled Case");
        }
    }
}

