/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.StringParser;
import us.ihmc.atlas.AtlasRobotModel;
import us.ihmc.atlas.AtlasRobotModelFactory;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.avatar.posePlayback.PoseSequenceEditorGUI;

public class AtlasPoseSequenceEditorGUI {
    public static void main(String[] args) {
        AtlasRobotModel model;
        JSAP jsap = new JSAP();
        FlaggedOption robotModel = new FlaggedOption("robotModel").setLongFlag("model").setShortFlag('m').setRequired(true).setStringParser((StringParser)JSAP.STRING_PARSER);
        robotModel.setHelp("Robot models: " + AtlasRobotModelFactory.robotModelsToString());
        try {
            jsap.registerParameter((Parameter)robotModel);
            JSAPResult config = jsap.parse(args);
            if (!config.success()) {
                System.out.println("Enter a robot model.");
                return;
            }
            model = AtlasRobotModelFactory.createDRCRobotModel(config.getString("robotModel"), RobotTarget.SCS, false);
        }
        catch (Exception e) {
            System.out.println("Robot model not found");
            e.printStackTrace();
            return;
        }
        PoseSequenceEditorGUI scriptedEditorGUI = new PoseSequenceEditorGUI((DRCRobotModel)model);
        scriptedEditorGUI.setDefaultCloseOperation(3);
        scriptedEditorGUI.setVisible(true);
    }
}

