/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas;

import com.martiansoftware.jsap.JSAPException;
import us.ihmc.atlas.AtlasRobotModel;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.avatar.networkProcessor.fiducialDetectorToolBox.FiducialDetectorToolboxModule;
import us.ihmc.avatar.networkProcessor.objectDetectorToolBox.ObjectDetectorToolboxModule;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.log.LogTools;
import us.ihmc.pubsub.DomainFactory;

public class AtlasObjectDetectionModules {
    private final ObjectDetectorToolboxModule objectDetectorToolboxModule;
    private final FiducialDetectorToolboxModule fiducialDetectorToolboxModule;

    public AtlasObjectDetectionModules() {
        AtlasRobotModel robotModel = new AtlasRobotModel(AtlasRobotVersion.ATLAS_UNPLUGGED_V5_DUAL_ROBOTIQ, RobotTarget.REAL_ROBOT);
        this.fiducialDetectorToolboxModule = new FiducialDetectorToolboxModule(robotModel.getSimpleRobotName(), robotModel.getTarget(), robotModel.createFullRobotModel(), robotModel.getLogModelProvider(), DomainFactory.PubSubImplementation.FAST_RTPS);
        this.objectDetectorToolboxModule = new ObjectDetectorToolboxModule(robotModel.getSimpleRobotName(), robotModel.createFullRobotModel(), robotModel.getLogModelProvider(), DomainFactory.PubSubImplementation.FAST_RTPS);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            LogTools.info((String)"Shutting down network processor modules.");
            this.fiducialDetectorToolboxModule.closeAndDispose();
            this.objectDetectorToolboxModule.closeAndDispose();
            ThreadTools.sleep((long)10L);
        }, this.getClass().getSimpleName() + "Shutdown"));
    }

    public static void main(String[] args) throws JSAPException {
        new AtlasObjectDetectionModules();
    }
}

