/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import us.ihmc.atlas.AtlasRobotModel;
import us.ihmc.atlas.AtlasRobotModelFactory;
import us.ihmc.atlas.sensors.AtlasSensorSuiteManager;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.avatar.networkProcessor.HumanoidNetworkProcessor;
import us.ihmc.communication.producers.VideoControlSettings;
import us.ihmc.log.LogTools;
import us.ihmc.pubsub.DomainFactory;

public class AtlasNetworkProcessor {
    private static final NetworkProcessorMode DEAFULT_MODE = NetworkProcessorMode.VR;

    public static void main(String[] args) throws JSAPException {
        AtlasRobotModel model;
        JSAP jsap = new JSAP();
        FlaggedOption robotModel = new FlaggedOption("robotModel").setLongFlag("model").setShortFlag('m').setRequired(false).setStringParser((StringParser)JSAP.STRING_PARSER);
        FlaggedOption modeOption = new FlaggedOption("mode").setLongFlag("mode").setRequired(false).setStringParser((StringParser)JSAP.STRING_PARSER);
        Switch runningOnRealRobot = new Switch("runningOnRealRobot").setLongFlag("realRobot");
        Switch runningOnGazebo = new Switch("runningOnGazebo").setLongFlag("gazebo");
        FlaggedOption leftHandHost = new FlaggedOption("leftHandHost").setLongFlag("lefthand").setShortFlag('l').setRequired(false).setStringParser((StringParser)JSAP.STRING_PARSER);
        FlaggedOption rightHandHost = new FlaggedOption("rightHandHost").setLongFlag("righthand").setShortFlag('r').setRequired(false).setStringParser((StringParser)JSAP.STRING_PARSER);
        robotModel.setHelp("Robot models: " + AtlasRobotModelFactory.robotModelsToString());
        jsap.registerParameter((Parameter)robotModel);
        jsap.registerParameter((Parameter)runningOnRealRobot);
        jsap.registerParameter((Parameter)modeOption);
        jsap.registerParameter((Parameter)runningOnGazebo);
        jsap.registerParameter((Parameter)leftHandHost);
        jsap.registerParameter((Parameter)rightHandHost);
        JSAPResult config = jsap.parse(args);
        if (!config.success()) {
            System.err.println("Invalid parameters");
            System.out.println(jsap.getHelp());
            return;
        }
        try {
            RobotTarget target = config.getBoolean(runningOnRealRobot.getID()) ? RobotTarget.REAL_ROBOT : (config.getBoolean(runningOnGazebo.getID()) ? RobotTarget.GAZEBO : RobotTarget.SCS);
            String robotVersionString = config.getString("robotModel");
            if (robotVersionString == null) {
                robotVersionString = "ATLAS_UNPLUGGED_V5_DUAL_ROBOTIQ";
            }
            model = AtlasRobotModelFactory.createDRCRobotModel(robotVersionString, target, true);
        }
        catch (IllegalArgumentException e) {
            System.err.println("Incorrect robot model " + config.getString("robotModel"));
            System.out.println(jsap.getHelp());
            return;
        }
        LogTools.info((String)"Selected model: {}", (Object)model);
        HumanoidNetworkProcessor networkProcessor = new HumanoidNetworkProcessor((DRCRobotModel)model, DomainFactory.PubSubImplementation.FAST_RTPS);
        LogTools.info((String)("ROS_MASTER_URI = " + networkProcessor.getOrCreateRosURI()));
        LogTools.info((String)"Setting up network processor modules...");
        NetworkProcessorMode mode = DEAFULT_MODE;
        if (config.userSpecified(modeOption.getID())) {
            String userSpecifiedMode = config.getString(modeOption.getID());
            LogTools.info((String)"User specified mode: {}", (Object)userSpecifiedMode);
            mode = NetworkProcessorMode.valueOf(userSpecifiedMode);
        }
        mode.getApplication().setup(args, model, networkProcessor);
        networkProcessor.setupShutdownHook();
        LogTools.info((String)"Starting modules!");
        networkProcessor.start();
    }

    private static void defaultNetworkProcessor(String[] args, AtlasRobotModel robotModel, HumanoidNetworkProcessor networkProcessor) {
        networkProcessor.setupRosModule();
        networkProcessor.setupBipedalSupportPlanarRegionPublisherModule();
        networkProcessor.setupHumanoidAvatarLidarREAStateUpdater();
        networkProcessor.setupHumanoidAvatarRealSenseREAStateUpdater();
        AtlasSensorSuiteManager sensorModule = robotModel.getSensorSuiteManager();
        sensorModule.setEnableLidarScanPublisher(false);
        sensorModule.setEnableVideoPublisher(false);
        sensorModule.setEnableStereoVisionPointCloudPublisher(false);
        sensorModule.setEnableDepthPointCloudPublisher(false);
        networkProcessor.setupSensorModule();
    }

    private static void behaviorNetworkProcessor(String[] args, AtlasRobotModel robotModel, HumanoidNetworkProcessor networkProcessor) {
        networkProcessor.setupRosModule();
        networkProcessor.setupBipedalSupportPlanarRegionPublisherModule();
        networkProcessor.setupHumanoidAvatarLidarREAStateUpdater();
        networkProcessor.setupHumanoidAvatarRealSenseREAStateUpdater();
        AtlasSensorSuiteManager sensorModule = robotModel.getSensorSuiteManager();
        networkProcessor.setupSensorModule();
        sensorModule.getLidarScanPublisher().setRangeFilter(0.2, 8.0);
        sensorModule.getLidarScanPublisher().setPublisherPeriodInMillisecond(25L);
        sensorModule.getMultiSenseSensorManager().setVideoSettings(VideoControlSettings.configureJPEGServer((int)25, (int)10));
    }

    private static void vrNetworkProcessor(String[] args, AtlasRobotModel robotModel, HumanoidNetworkProcessor networkProcessor) {
        networkProcessor.setupRosModule();
        networkProcessor.setupBipedalSupportPlanarRegionPublisherModule();
        networkProcessor.setupHumanoidAvatarLidarREAStateUpdater();
        networkProcessor.setupFootstepPlanningToolboxModule();
        AtlasSensorSuiteManager sensorModule = robotModel.getSensorSuiteManager();
        sensorModule.setEnableDepthPointCloudPublisher(false);
        sensorModule.setEnableFisheyeCameraPublishers(false);
        sensorModule.setEnableLidarScanPublisher(false);
        sensorModule.setEnableVideoPublisher(false);
        networkProcessor.setupSensorModule();
        sensorModule.getLidarScanPublisher().setRangeFilter(0.2, 8.0);
        sensorModule.getLidarScanPublisher().setPublisherPeriodInMillisecond(25L);
        sensorModule.getMultiSenseSensorManager().setVideoSettings(VideoControlSettings.configureJPEGServer((int)25, (int)10));
        networkProcessor.setupBehaviorModule(false, false, 0.0);
    }

    private static void stairsNetworkProcessor(String[] args, AtlasRobotModel robotModel, HumanoidNetworkProcessor networkProcessor) {
        networkProcessor.setupRosModule();
        networkProcessor.setupHumanoidAvatarLidarREAStateUpdater();
        networkProcessor.setupKinematicsToolboxModule(false);
        AtlasSensorSuiteManager sensorModule = robotModel.getSensorSuiteManager();
        networkProcessor.setupSensorModule();
        sensorModule.getLidarScanPublisher().setRangeFilter(0.2, 8.0);
        sensorModule.getLidarScanPublisher().setPublisherPeriodInMillisecond(25L);
        sensorModule.getMultiSenseSensorManager().setVideoSettings(VideoControlSettings.configureJPEGServer((int)35, (int)15));
    }

    private static void minimalNetworkProcessor(String[] args, AtlasRobotModel robotModel, HumanoidNetworkProcessor networkProcessor) {
        networkProcessor.setupRosModule();
        networkProcessor.setupSensorModule();
    }

    public static enum NetworkProcessorMode {
        DEFAULT(AtlasNetworkProcessor::defaultNetworkProcessor),
        VR(AtlasNetworkProcessor::vrNetworkProcessor),
        BEHAVIOR(AtlasNetworkProcessor::behaviorNetworkProcessor),
        MINIMAL(AtlasNetworkProcessor::minimalNetworkProcessor),
        STAIRS(AtlasNetworkProcessor::stairsNetworkProcessor);

        private Application application;

        private NetworkProcessorMode(Application application) {
            this.application = application;
        }

        public Application getApplication() {
            return this.application;
        }
    }

    private static interface Application {
        public void setup(String[] var1, AtlasRobotModel var2, HumanoidNetworkProcessor var3);
    }
}

