/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import us.ihmc.atlas.AtlasRobotModel;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.avatar.scs2.SCS2BulletSimulationTools;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.mecano.tools.MomentOfInertiaFactory;
import us.ihmc.robotics.physics.CollidableHelper;
import us.ihmc.robotics.physics.RobotCollisionModel;
import us.ihmc.scs2.definition.collision.CollisionShapeDefinition;
import us.ihmc.scs2.definition.geometry.Box3DDefinition;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.RigidBodyDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.robot.SixDoFJointDefinition;
import us.ihmc.scs2.definition.state.SixDoFJointState;
import us.ihmc.scs2.definition.terrain.TerrainObjectDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinitions;
import us.ihmc.scs2.definition.visual.MaterialDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinitionFactory;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizer;
import us.ihmc.scs2.simulation.SimulationSession;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletPhysicsEngine;
import us.ihmc.simulationToolkit.RobotDefinitionTools;

public class AtlasFallingOnGroundSCS2Bullet {
    public AtlasFallingOnGroundSCS2Bullet() {
        AtlasRobotModel robotModel = new AtlasRobotModel(AtlasRobotVersion.ATLAS_UNPLUGGED_V5_NO_HANDS);
        robotModel.setRobotDefinitionMutator(robotDefinition -> {});
        boolean removeCollisions = false;
        MaterialDefinition materialDefinition = null;
        RobotDefinition robotDefinition2 = robotModel.createRobotDefinition(materialDefinition, removeCollisions);
        if (removeCollisions) {
            RobotCollisionModel collisionModel = robotModel.getHumanoidRobotKinematicsCollisionModel();
            if (collisionModel != null) {
                RobotDefinitionTools.addCollisionsToRobotDefinition((List)collisionModel.getRobotCollidables(robotModel.createFullRobotModel().getElevator()), (RobotDefinition)robotDefinition2);
            }
        } else {
            this.setCollisionMasks(robotDefinition2);
        }
        Set<String> lastSimulatedJoints = robotModel.getJointMap().getLastSimulatedJoints();
        lastSimulatedJoints.forEach(arg_0 -> ((RobotDefinition)robotDefinition2).addSubtreeJointsToIgnore(arg_0));
        SimulationSession simulationSession = new SimulationSession(BulletPhysicsEngine::new);
        simulationSession.addRobot(robotDefinition2);
        double groundWidth = 10.0;
        double groundLength = 10.0;
        Box3DDefinition terrainGeometry = new Box3DDefinition(groundLength, groundWidth, 0.1);
        RigidBodyTransform terrainPose = new RigidBodyTransform();
        terrainPose.getTranslation().subZ(1.5);
        TerrainObjectDefinition terrain = new TerrainObjectDefinition(new VisualDefinition((RigidBodyTransformReadOnly)terrainPose, (GeometryDefinition)terrainGeometry, new MaterialDefinition(ColorDefinitions.DarkKhaki())), new CollisionShapeDefinition((RigidBodyTransformReadOnly)terrainPose, (GeometryDefinition)terrainGeometry));
        simulationSession.addTerrainObject(terrain);
        RobotDefinition boxRobotDefinition = new RobotDefinition("atlas2");
        RigidBodyDefinition rootBodyDefinition = new RigidBodyDefinition("elevator2");
        SixDoFJointDefinition rootJointDefinition = new SixDoFJointDefinition("pelvis2");
        rootJointDefinition.setInitialJointState(new SixDoFJointState((Orientation3DReadOnly)new YawPitchRoll(0.1, 0.1, 0.1), (Tuple3DReadOnly)new Point3D(0.6, 0.0, 0.0)));
        rootBodyDefinition.addChildJoint((JointDefinition)rootJointDefinition);
        Vector3D boxSize1 = new Vector3D(0.3, 0.3, 0.3);
        double boxMass1 = 1.0;
        double radiusOfGyrationPercent = 0.8;
        ColorDefinition boxApp1 = ColorDefinitions.LightSeaGreen();
        RigidBodyDefinition rigidBody1 = AtlasFallingOnGroundSCS2Bullet.newBoxRigidBody("pelvis2", (Tuple3DReadOnly)boxSize1, boxMass1, radiusOfGyrationPercent, boxApp1);
        rigidBody1.addCollisionShapeDefinition(new CollisionShapeDefinition((GeometryDefinition)new Box3DDefinition((Tuple3DReadOnly)boxSize1)));
        rootJointDefinition.setSuccessor(rigidBody1);
        boxRobotDefinition.setRootBodyDefinition(rootBodyDefinition);
        SessionVisualizer sessionVisualizer = SCS2BulletSimulationTools.startSessionVisualizerWithDebugDrawing((SimulationSession)simulationSession);
        sessionVisualizer.getSessionVisualizerControls().setCameraFocusPosition(0.3, 0.0, 1.0);
        sessionVisualizer.getSessionVisualizerControls().setCameraPosition(7.0, 4.0, 3.0);
        sessionVisualizer.getToolkit().getSession().runTick();
    }

    private void setCollisionMasks(RobotDefinition robotDefinition) {
        String defaultFilter = "DefaultFilter";
        String staticFilter = "StaticFilter";
        String kinematicFilter = "KinematicFilter";
        String debrisFilter = "DebrisFilter";
        String sensorTrigger = "SensorTrigger";
        String characterFilter = "CharacterFilter";
        String bodyName = "Body";
        String pelvis = "Pelvis";
        String rightLeg = "RightLeg";
        String leftLeg = "LeftLeg";
        String rightArm = "RightArm";
        String leftArm = "LeftArm";
        CollidableHelper helper = new CollidableHelper();
        long bulletCollisionGroup = helper.getCollisionMask(defaultFilter);
        bulletCollisionGroup = helper.getCollisionMask(staticFilter);
        bulletCollisionGroup = helper.getCollisionMask(kinematicFilter);
        bulletCollisionGroup = helper.getCollisionMask(debrisFilter);
        bulletCollisionGroup = helper.getCollisionMask(sensorTrigger);
        bulletCollisionGroup = helper.getCollisionMask(characterFilter);
        for (RigidBodyDefinition rigidBodyDefinition : robotDefinition.getAllRigidBodies()) {
            for (CollisionShapeDefinition shapeDefinition : rigidBodyDefinition.getCollisionShapeDefinitions()) {
                long bulletCollideMask;
                if (shapeDefinition.getName().contains("pelvis") || shapeDefinition.getName().contains("uglut") || shapeDefinition.getName().contains("lglut")) {
                    bulletCollisionGroup = helper.getCollisionMask(pelvis);
                    bulletCollideMask = helper.createCollisionGroup(new String[]{defaultFilter, staticFilter, bodyName, leftArm, rightArm});
                } else if (shapeDefinition.getName().contains("utorso") || shapeDefinition.getName().contains("hokuyo") || shapeDefinition.getName().contains("head")) {
                    bulletCollisionGroup = helper.getCollisionMask(bodyName);
                    bulletCollideMask = helper.createCollisionGroup(new String[]{defaultFilter, staticFilter, rightLeg, leftLeg, rightArm, leftArm});
                } else if (shapeDefinition.getName().contains("l_uleg") || shapeDefinition.getName().contains("l_lleg") || shapeDefinition.getName().contains("l_talus") || shapeDefinition.getName().contains("l_foot")) {
                    bulletCollisionGroup = helper.getCollisionMask(leftLeg);
                    bulletCollideMask = helper.createCollisionGroup(new String[]{defaultFilter, staticFilter, bodyName, rightLeg, leftArm});
                } else if (shapeDefinition.getName().contains("r_uleg") || shapeDefinition.getName().contains("r_lleg") || shapeDefinition.getName().contains("r_talus") || shapeDefinition.getName().contains("r_foot")) {
                    bulletCollisionGroup = helper.getCollisionMask(rightLeg);
                    bulletCollideMask = helper.createCollisionGroup(new String[]{defaultFilter, staticFilter, bodyName, leftLeg, leftArm});
                } else if (shapeDefinition.getName().contains("l_uarm") || shapeDefinition.getName().contains("l_clav") || shapeDefinition.getName().contains("l_scap") || shapeDefinition.getName().contains("l_larm") || shapeDefinition.getName().contains("l_ufarm") || shapeDefinition.getName().contains("l_lfarm")) {
                    bulletCollisionGroup = helper.getCollisionMask(leftArm);
                    bulletCollideMask = helper.createCollisionGroup(new String[]{defaultFilter, staticFilter, bodyName, pelvis, leftLeg, rightLeg, rightArm});
                } else if (shapeDefinition.getName().contains("r_uarm") || shapeDefinition.getName().contains("r_clav") || shapeDefinition.getName().contains("r_scap") || shapeDefinition.getName().contains("r_larm") || shapeDefinition.getName().contains("r_ufarm") || shapeDefinition.getName().contains("r_lfarm")) {
                    bulletCollisionGroup = helper.getCollisionMask(rightArm);
                    bulletCollideMask = helper.createCollisionGroup(new String[]{defaultFilter, staticFilter, bodyName, pelvis, leftLeg, rightLeg, leftArm});
                } else {
                    bulletCollisionGroup = 1L;
                    bulletCollideMask = 3L;
                }
                shapeDefinition.setCollisionMask(bulletCollisionGroup);
                shapeDefinition.setCollisionGroup(bulletCollideMask);
            }
        }
    }

    public static RigidBodyDefinition newBoxRigidBody(String rigidBodyName, Tuple3DReadOnly size, double mass, double radiusOfGyrationPercent, ColorDefinition color) {
        return AtlasFallingOnGroundSCS2Bullet.newBoxRigidBody(rigidBodyName, size, mass, radiusOfGyrationPercent, null, color);
    }

    public static RigidBodyDefinition newBoxRigidBody(String rigidBodyName, Tuple3DReadOnly size, double mass, double radiusOfGyrationPercent, Vector3DReadOnly offsetFromParent, ColorDefinition color) {
        return AtlasFallingOnGroundSCS2Bullet.newBoxRigidBody(rigidBodyName, size.getX(), size.getY(), size.getZ(), mass, radiusOfGyrationPercent, offsetFromParent, color);
    }

    public static RigidBodyDefinition newBoxRigidBody(String rigidBodyName, double sizeX, double sizeY, double sizeZ, double mass, double radiusOfGyrationPercent, Vector3DReadOnly offsetFromParentJoint, ColorDefinition color) {
        RigidBodyDefinition rigidBody = new RigidBodyDefinition(rigidBodyName);
        rigidBody.setMass(mass);
        rigidBody.setMomentOfInertia((Matrix3DReadOnly)MomentOfInertiaFactory.fromMassAndRadiiOfGyration((double)mass, (double)(radiusOfGyrationPercent * sizeX), (double)(radiusOfGyrationPercent * sizeY), (double)(radiusOfGyrationPercent * sizeZ)));
        if (offsetFromParentJoint != null) {
            rigidBody.setCenterOfMassOffset((Tuple3DReadOnly)offsetFromParentJoint);
        }
        VisualDefinitionFactory factory = new VisualDefinitionFactory();
        if (offsetFromParentJoint != null) {
            factory.appendTranslation((Tuple3DReadOnly)offsetFromParentJoint);
        }
        factory.addBox(sizeX, sizeY, sizeZ, new MaterialDefinition(color));
        rigidBody.addVisualDefinitions((Collection)factory.getVisualDefinitions());
        return rigidBody;
    }

    public static void main(String[] args) {
        new AtlasFallingOnGroundSCS2Bullet();
    }
}

