/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.sensors;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.stage.Stage;
import us.ihmc.atlas.AtlasRobotModel;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.atlas.sensors.AtlasSLAMModule;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.communication.IHMCROS2Callback;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.javafx.applicationCreator.JavaFXApplicationCreator;
import us.ihmc.log.LogTools;
import us.ihmc.messager.Messager;
import us.ihmc.messager.SharedMemoryMessager;
import us.ihmc.messager.javafx.SharedMemoryJavaFXMessager;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotEnvironmentAwareness.communication.SLAMModuleAPI;
import us.ihmc.robotEnvironmentAwareness.communication.SegmentationModuleAPI;
import us.ihmc.robotEnvironmentAwareness.ui.PlanarSegmentationUI;
import us.ihmc.robotEnvironmentAwareness.ui.SLAMBasedEnvironmentAwarenessUI;
import us.ihmc.robotEnvironmentAwareness.updaters.OcTreeConsumer;
import us.ihmc.robotEnvironmentAwareness.updaters.PlanarSegmentationModule;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.tools.io.WorkspacePathTools;
import us.ihmc.tools.processManagement.JavaProcessManager;
import us.ihmc.wholeBodyController.RobotContactPointParameters;

public class AtlasSLAMBasedREAStandaloneLauncher {
    private static boolean launchSegmentation = true;
    private static final String SLAM_CONFIGURATION_FILE_NAME = "atlasSLAMModuleConfiguration.txt";
    private static final String SEGMENTATION_CONFIGURATION_FILE_NAME = "atlasSegmentationModuleConfiguration.txt";
    private final boolean spawnSegmentationUI;
    private final boolean spawnSLAMUI;
    private final DomainFactory.PubSubImplementation pubSubImplementation;
    private ROS2Node ros2Node;
    private Messager slamMessager;
    private Messager segmentationMessager;
    private SLAMBasedEnvironmentAwarenessUI ui;
    private AtlasSLAMModule module;
    private PlanarSegmentationUI planarSegmentationUI;
    private PlanarSegmentationModule segmentationModule;

    public AtlasSLAMBasedREAStandaloneLauncher(boolean spawnUIs, DomainFactory.PubSubImplementation pubSubImplementation) {
        this(spawnUIs, spawnUIs, pubSubImplementation);
    }

    public AtlasSLAMBasedREAStandaloneLauncher(boolean spawnSegmentationUI, boolean spawnSLAMUI, DomainFactory.PubSubImplementation pubSubImplementation) {
        this.spawnSegmentationUI = spawnSegmentationUI;
        this.spawnSLAMUI = spawnSLAMUI;
        this.pubSubImplementation = pubSubImplementation;
        Runnable setup = () -> ExceptionTools.handle(this::setup, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        if (spawnSegmentationUI || spawnSLAMUI) {
            JavaFXApplicationCreator.createAJavaFXApplication();
            Platform.runLater((Runnable)setup);
        } else {
            setup.run();
        }
    }

    public void setup() throws Exception {
        Path slamConfigurationFilePath;
        Stage primaryStage = null;
        if (this.spawnSLAMUI) {
            primaryStage = new Stage();
        }
        AtlasRobotModel drcRobotModel = new AtlasRobotModel(AtlasRobotVersion.ATLAS_UNPLUGGED_V5_DUAL_ROBOTIQ, RobotTarget.REAL_ROBOT, false);
        RobotContactPointParameters contactPointParameters = drcRobotModel.getContactPointParameters();
        SideDependentList defaultContactPoints = new SideDependentList();
        for (RobotSide side : RobotSide.values) {
            defaultContactPoints.put((Enum)side, (Object)((List)contactPointParameters.getControllerFootGroundContactPoints().get((Enum)side)));
        }
        this.ros2Node = ROS2Tools.createROS2Node((DomainFactory.PubSubImplementation)this.pubSubImplementation, (String)"REA_module");
        this.slamMessager = this.spawnSLAMUI ? new SharedMemoryJavaFXMessager(SLAMModuleAPI.API) : new SharedMemoryMessager(SLAMModuleAPI.API);
        this.slamMessager.startMessager();
        if (launchSegmentation) {
            this.segmentationMessager = this.spawnSegmentationUI ? new SharedMemoryJavaFXMessager(SegmentationModuleAPI.API) : new SharedMemoryMessager(SegmentationModuleAPI.API);
            this.segmentationMessager.startMessager();
        }
        if (this.spawnSLAMUI) {
            this.ui = SLAMBasedEnvironmentAwarenessUI.creatIntraprocessUI((Messager)this.slamMessager, (Stage)primaryStage, (SideDependentList)defaultContactPoints);
        }
        if ((slamConfigurationFilePath = WorkspacePathTools.handleWorkingDirectoryFuzziness((String)"ihmc-open-robotics-software")) != null) {
            slamConfigurationFilePath = Paths.get(slamConfigurationFilePath.toString(), "/atlas/src/main/resources/atlasSLAMModuleConfiguration.txt").toAbsolutePath().normalize();
            LogTools.info((String)"Loading configuration file: {}", (Object)slamConfigurationFilePath);
        } else {
            LogTools.info((String)"Running from JAR. Saving configuration disabled. {}");
        }
        this.module = AtlasSLAMModule.createIntraprocessModule(this.ros2Node, drcRobotModel, this.slamMessager, slamConfigurationFilePath == null ? null : slamConfigurationFilePath.toFile());
        Stage secondStage = null;
        if (launchSegmentation) {
            Path segmentationConfigurationFilePath;
            if (this.spawnSegmentationUI) {
                secondStage = new Stage();
                this.planarSegmentationUI = PlanarSegmentationUI.createIntraprocessUI((Messager)this.segmentationMessager, (Stage)secondStage);
            }
            if ((segmentationConfigurationFilePath = WorkspacePathTools.handleWorkingDirectoryFuzziness((String)"ihmc-open-robotics-software")) != null) {
                segmentationConfigurationFilePath = Paths.get(segmentationConfigurationFilePath.toString(), "/atlas/src/main/resources/atlasSegmentationModuleConfiguration.txt");
            }
            this.segmentationModule = PlanarSegmentationModule.createIntraprocessModule((File)(segmentationConfigurationFilePath == null ? null : segmentationConfigurationFilePath.toFile()), (ROS2Node)this.ros2Node, (Messager)this.segmentationMessager);
            this.module.attachOcTreeConsumer((OcTreeConsumer)this.segmentationModule);
        }
        if (this.spawnSLAMUI) {
            this.ui.show();
        }
        if (this.spawnSegmentationUI && launchSegmentation) {
            this.planarSegmentationUI.show();
        }
        new IHMCROS2Callback((ROS2NodeInterface)this.ros2Node, SLAMModuleAPI.SHUTDOWN, message -> {
            LogTools.info((String)"Received SHUTDOWN. Shutting down...");
            this.stop();
        });
        this.module.start();
        if (this.segmentationModule != null) {
            this.segmentationModule.start();
        }
    }

    public void stop() {
        ThreadTools.sleepSeconds((double)2.0);
        ExceptionTools.handle(() -> this.slamMessager.closeMessager(), (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        if (launchSegmentation) {
            ExceptionTools.handle(() -> this.segmentationMessager.closeMessager(), (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        }
        this.ros2Node.destroy();
    }

    public static void main(String[] args) {
        JavaProcessManager manager = new JavaProcessManager();
        manager.runOrRegister("AtlasSLAMBasedREA", () -> new AtlasSLAMBasedREAStandaloneLauncher(true, true, DomainFactory.PubSubImplementation.FAST_RTPS));
        ArrayList processes = manager.spawnProcesses(AtlasSLAMBasedREAStandaloneLauncher.class, args);
        ROS2Node ros2Node = ROS2Tools.createROS2Node((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS, (String)"test_node");
        new IHMCROS2Callback((ROS2NodeInterface)ros2Node, SLAMModuleAPI.SHUTDOWN, message -> {
            LogTools.info((String)"Received SHUTDOWN. Shutting down...");
            ThreadTools.startAsDaemon(() -> {
                ThreadTools.sleepSeconds((double)2.0);
                for (Process process : processes) {
                    LogTools.info((String)"Destoying process  forcibly");
                    process.destroyForcibly();
                }
                ros2Node.destroy();
            }, (String)"DestroyThread");
        });
    }
}

