/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.sensors;

import java.io.File;
import java.nio.file.Paths;
import us.ihmc.atlas.AtlasRobotModel;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.atlas.sensors.AtlasSLAMModule;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.communication.IHMCROS2Callback;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.log.LogTools;
import us.ihmc.messager.Messager;
import us.ihmc.messager.SharedMemoryMessager;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotEnvironmentAwareness.communication.SLAMModuleAPI;
import us.ihmc.robotEnvironmentAwareness.communication.SegmentationModuleAPI;
import us.ihmc.robotEnvironmentAwareness.updaters.OcTreeConsumer;
import us.ihmc.robotEnvironmentAwareness.updaters.PlanarSegmentationModule;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeInterface;

public class AtlasRealsenseSLAMRemoteLauncher {
    private static final String SLAM_CONFIGURATION_FILE_NAME = "atlasSLAMModuleConfiguration.txt";
    private static final String SEGMENTATION_CONFIGURATION_FILE_NAME = "atlasSegmentationModuleConfiguration.txt";
    private final DomainFactory.PubSubImplementation pubSubImplementation = DomainFactory.PubSubImplementation.FAST_RTPS;
    private ROS2Node ros2Node;
    private Messager slamMessager;
    private Messager segmentationMessager;
    private AtlasSLAMModule slamModule;
    private PlanarSegmentationModule segmentationModule;

    public AtlasRealsenseSLAMRemoteLauncher() {
        ExceptionTools.handle(this::setup, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
    }

    public void setup() throws Exception {
        AtlasRobotModel drcRobotModel = new AtlasRobotModel(AtlasRobotVersion.ATLAS_UNPLUGGED_V5_DUAL_ROBOTIQ, RobotTarget.REAL_ROBOT, false);
        this.ros2Node = ROS2Tools.createROS2Node((DomainFactory.PubSubImplementation)this.pubSubImplementation, (String)"REA_module");
        this.slamMessager = new SharedMemoryMessager(SLAMModuleAPI.API);
        this.slamMessager.startMessager();
        this.segmentationMessager = new SharedMemoryMessager(SegmentationModuleAPI.API);
        this.segmentationMessager.startMessager();
        File slamConfigurationFile = Paths.get(System.getProperty("user.home"), ".ihmc", SLAM_CONFIGURATION_FILE_NAME).toFile();
        File segmentationConfigurationFile = Paths.get(System.getProperty("user.home"), ".ihmc", SEGMENTATION_CONFIGURATION_FILE_NAME).toFile();
        this.slamModule = new AtlasSLAMModule(this.ros2Node, this.slamMessager, drcRobotModel, slamConfigurationFile);
        this.segmentationModule = PlanarSegmentationModule.createIntraprocessModule((File)segmentationConfigurationFile, (ROS2Node)this.ros2Node, (Messager)this.segmentationMessager);
        this.slamModule.attachOcTreeConsumer((OcTreeConsumer)this.segmentationModule);
        new IHMCROS2Callback((ROS2NodeInterface)this.ros2Node, SLAMModuleAPI.SHUTDOWN, message -> {
            LogTools.info((String)"Received SHUTDOWN. Shutting down...");
            this.stop();
        });
        this.slamModule.start();
        this.segmentationModule.start();
    }

    public void stop() {
        ThreadTools.sleepSeconds((double)2.0);
        ExceptionTools.handle(() -> this.slamMessager.closeMessager(), (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        ExceptionTools.handle(() -> this.segmentationMessager.closeMessager(), (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        this.ros2Node.destroy();
    }

    public static void main(String[] args) {
        new AtlasRealsenseSLAMRemoteLauncher();
    }
}

