/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.sensors;

import java.nio.file.Path;
import java.nio.file.Paths;
import javafx.application.Platform;
import javafx.stage.Stage;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.util.NetworkPorts;
import us.ihmc.javafx.applicationCreator.JavaFXApplicationCreator;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotEnvironmentAwareness.communication.REACommunicationProperties;
import us.ihmc.robotEnvironmentAwareness.io.FilePropertyHelper;
import us.ihmc.robotEnvironmentAwareness.perceptionSuite.RealSenseREANetworkProvider;
import us.ihmc.robotEnvironmentAwareness.ui.LIDARBasedEnvironmentAwarenessUI;
import us.ihmc.robotEnvironmentAwareness.updaters.LIDARBasedREAModule;
import us.ihmc.robotEnvironmentAwareness.updaters.REANetworkProvider;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.tools.io.WorkspacePathTools;

public class AtlasRealsenseBasedREAStandaloneLauncher {
    private static final Path rootPath = WorkspacePathTools.handleWorkingDirectoryFuzziness((String)"ihmc-open-robotics-software");
    private static final String directory = "/atlas/src/main/resources/";
    private static final String REALSENSE_REA_MODULE_CONFIGURATION_FILE_NAME = "atlasRealSenseREAModuleConfiguration.txt";
    private final boolean spawnUI;
    private LIDARBasedEnvironmentAwarenessUI ui;
    private LIDARBasedREAModule module;

    public AtlasRealsenseBasedREAStandaloneLauncher(boolean spawnUI) {
        this.spawnUI = spawnUI;
        JavaFXApplicationCreator.createAJavaFXApplication();
        Platform.runLater(() -> ExceptionTools.handle(this::setup, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE));
    }

    private void setup() throws Exception {
        Stage primaryStage = null;
        if (this.spawnUI) {
            primaryStage = new Stage();
        }
        Path realsenseREAConfigurationFilePath = Paths.get(rootPath.toString(), "/atlas/src/main/resources/atlasRealSenseREAModuleConfiguration.txt");
        ROS2Node ros2Node = ROS2Tools.createROS2Node((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS, (String)"REA_module");
        RealSenseREANetworkProvider realSenseREANetworkProvider = new RealSenseREANetworkProvider(ros2Node, REACommunicationProperties.stereoInputTopic, REACommunicationProperties.stereoOutputTopic);
        if (this.spawnUI) {
            this.ui = LIDARBasedEnvironmentAwarenessUI.creatIntraprocessUI((Stage)primaryStage, (NetworkPorts)NetworkPorts.REA_MODULE2_UI_PORT);
        }
        this.module = LIDARBasedREAModule.createIntraprocessModule((FilePropertyHelper)new FilePropertyHelper(realsenseREAConfigurationFilePath.toFile()), (REANetworkProvider)realSenseREANetworkProvider, (NetworkPorts)NetworkPorts.REA_MODULE2_UI_PORT);
        this.module.setParametersForStereo();
        this.module.loadConfigurationsFromFile();
        if (this.spawnUI) {
            this.ui.show();
        }
        this.module.start();
        if (this.spawnUI) {
            primaryStage.setOnCloseRequest(event -> this.stop());
        }
    }

    public void stop() {
        this.ui.stop();
        this.module.stop();
        Platform.exit();
    }

    public static void main(String[] args) {
        new AtlasRealsenseBasedREAStandaloneLauncher(true);
    }
}

