/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.processManagement;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import us.ihmc.atlas.AtlasNetworkProcessor;
import us.ihmc.atlas.AtlasRobotModelFactory;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.communication.net.tcpServer.DisconnectedException;
import us.ihmc.communication.net.tcpServer.ReconnectingTCPServer;
import us.ihmc.communication.util.NetworkPorts;
import us.ihmc.tools.processManagement.JavaProcessSpawner;
import us.ihmc.tools.processManagement.UnsignedByteTools;

public class DRCNetworkProcessorEnterpriseCloudDispatcherBackend
implements Runnable {
    private JavaProcessSpawner networkProcessorSpawner = new JavaProcessSpawner(true, true);
    private ReconnectingTCPServer commandServer;
    private final byte[] buffer;
    private static String scsMachineIPAddress = "http://192.168.130.112:11311";
    private static String rosMasterURI = "http://192.168.130.101:11311";
    private static String[] javaArgs = new String[]{"-Xms2048m", "-Xmx2048m"};
    private static String robotModel;
    private int leftHandIP;
    private int rightHandIP;

    public DRCNetworkProcessorEnterpriseCloudDispatcherBackend() {
        try {
            this.commandServer = new ReconnectingTCPServer(NetworkPorts.NETWORK_PROCESSOR_CLOUD_DISPATCHER_BACKEND_TCP_PORT.getPort());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.buffer = this.commandServer.getBuffer();
    }

    @Override
    public void run() {
        while (true) {
            try {
                this.commandServer.read(1);
                switch (UnsignedByteTools.toInt((byte)this.buffer[0])) {
                    case 0: {
                        this.commandServer.read(1);
                        robotModel = AtlasRobotModelFactory.getAvailableRobotModels()[UnsignedByteTools.toInt((byte)this.buffer[1])];
                        this.commandServer.read(1);
                        this.leftHandIP = UnsignedByteTools.toInt((byte)this.buffer[2]);
                        this.commandServer.read(1);
                        this.rightHandIP = UnsignedByteTools.toInt((byte)this.buffer[3]);
                        this.spawnNetworkProcessor();
                        break;
                    }
                    case 16: {
                        this.killNetworkProcessor();
                        break;
                    }
                    case 17: {
                        this.restartNetworkProcessor();
                        break;
                    }
                    case 34: {
                        this.startStreamingOutput();
                        break;
                    }
                    default: {
                        System.err.println("Invalid request: " + Integer.toHexString(UnsignedByteTools.toInt((byte)this.buffer[0])));
                        break;
                    }
                }
            }
            catch (DisconnectedException e) {
                this.commandServer.reset();
            }
            if (this.networkProcessorSpawner.hasRunningProcesses()) {
                // empty if block
            }
            this.commandServer.reset();
        }
    }

    private void startStreamingOutput() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ServerSocket server = null;
                try {
                    server = new ServerSocket(NetworkPorts.CONTROLLER_CLOUD_DISPATCHER_BACKEND_CONSOLE_TCP_PORT.getPort());
                    DRCNetworkProcessorEnterpriseCloudDispatcherBackend.this.commandServer.write(new byte[]{UnsignedByteTools.fromInt((int)34)});
                    Socket socket = server.accept();
                    socket.setTcpNoDelay(true);
                    OutputStream outputStream = socket.getOutputStream();
                    System.setOut(new PrintStream(outputStream));
                    System.setErr(new PrintStream(outputStream));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (DisconnectedException e) {
                    DRCNetworkProcessorEnterpriseCloudDispatcherBackend.this.commandServer.reset();
                    try {
                        server.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }).start();
    }

    private void spawnNetworkProcessor() {
        if (!this.networkProcessorSpawner.hasRunningProcesses()) {
            this.networkProcessorSpawner.spawn(AtlasNetworkProcessor.class, javaArgs, new String[]{"--ros-uri", rosMasterURI, "--scs-ip", scsMachineIPAddress, "-m", robotModel, "--realRobot", "-l", "10.66.171.1" + this.leftHandIP, "-r", "10.66.171.1" + this.rightHandIP});
            try {
                this.commandServer.write(new byte[]{UnsignedByteTools.fromInt((int)0)});
            }
            catch (DisconnectedException e) {
                this.commandServer.reset();
            }
        } else {
            System.err.println("Network processor is already running. Try restarting.");
        }
    }

    private void killNetworkProcessor() {
        this.networkProcessorSpawner.shutdown();
        try {
            this.commandServer.write(new byte[]{UnsignedByteTools.fromInt((int)17)});
        }
        catch (DisconnectedException e) {
            this.commandServer.reset();
        }
    }

    private void restartNetworkProcessor() {
        this.killNetworkProcessor();
        ThreadTools.sleep((long)5000L);
        this.spawnNetworkProcessor();
    }

    public static void main(String[] args) throws JSAPException {
        JSAP jsap = new JSAP();
        FlaggedOption scsIPFlag = new FlaggedOption("scs-ip").setLongFlag("scs-ip").setShortFlag('\u0000').setRequired(false).setStringParser((StringParser)JSAP.STRING_PARSER);
        FlaggedOption rosURIFlag = new FlaggedOption("ros-uri").setLongFlag("ros-uri").setShortFlag('\u0000').setRequired(false).setStringParser((StringParser)JSAP.STRING_PARSER);
        Switch largeHeapForProcessor = new Switch("large-heap").setLongFlag("large-heap").setShortFlag('h');
        jsap.registerParameter((Parameter)scsIPFlag);
        jsap.registerParameter((Parameter)rosURIFlag);
        jsap.registerParameter((Parameter)largeHeapForProcessor);
        JSAPResult config = jsap.parse(args);
        if (config.success()) {
            if (config.getString(scsIPFlag.getID()) != null) {
                scsMachineIPAddress = config.getString(scsIPFlag.getID());
            }
            if (config.getString(rosURIFlag.getID()) != null) {
                rosMasterURI = config.getString(rosURIFlag.getID());
            }
            if (config.getBoolean(largeHeapForProcessor.getID())) {
                javaArgs = new String[]{"-Xms4096m", "-Xmx4096m"};
            }
        }
        Thread t = new Thread(new DRCNetworkProcessorEnterpriseCloudDispatcherBackend());
        t.start();
    }
}

