/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.parameters;

import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.commonWalkingControlModules.configurations.SwingTrajectoryParameters;

public class AtlasSwingTrajectoryParameters
extends SwingTrajectoryParameters {
    protected final RobotTarget target;
    protected final double modelScale;
    protected final boolean runningOnRealRobot;

    public AtlasSwingTrajectoryParameters(RobotTarget target, double modelScale) {
        this.target = target;
        this.modelScale = modelScale;
        this.runningOnRealRobot = target == RobotTarget.REAL_ROBOT;
    }

    public double getMinSwingHeight() {
        return 0.1 * this.modelScale;
    }

    public double getDefaultSwingHeight() {
        return this.getMinSwingHeight();
    }

    public double getMaxSwingHeight() {
        return 0.4 * this.modelScale;
    }

    public double getDesiredTouchdownHeightOffset() {
        return 0.0;
    }

    public double getDesiredTouchdownVelocity() {
        return this.modelScale * -0.3;
    }

    public double getDesiredTouchdownAcceleration() {
        switch (this.target) {
            case SCS: {
                return this.modelScale * -2.0;
            }
        }
        return this.modelScale * -1.0;
    }

    public boolean addOrientationMidpointForObstacleClearance() {
        return false;
    }

    public boolean useSingularityAvoidanceInSupport() {
        return true;
    }
}

