/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.parameters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import us.ihmc.atlas.parameters.AtlasSensorInformation;
import us.ihmc.commonWalkingControlModules.sensors.footSwitch.WrenchBasedFootSwitchFactory;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.dataStructures.PolynomialReadOnly;
import us.ihmc.robotics.dataStructures.parameters.ParameterPolynomial;
import us.ihmc.robotics.math.filters.AlphaFilteredYoVariable;
import us.ihmc.robotics.partNames.ArmJointName;
import us.ihmc.robotics.partNames.HumanoidJointNameMap;
import us.ihmc.robotics.partNames.LegJointName;
import us.ihmc.robotics.partNames.SpineJointName;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.sensors.FootSwitchFactory;
import us.ihmc.sensorProcessing.sensorProcessors.SensorProcessing;
import us.ihmc.sensorProcessing.simulatedSensors.SensorNoiseParameters;
import us.ihmc.sensorProcessing.stateEstimation.IMUBasedJointStateEstimatorParameters;
import us.ihmc.sensorProcessing.stateEstimation.StateEstimatorParameters;
import us.ihmc.yoVariables.euclid.YoVector3D;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class AtlasStateEstimatorParameters
extends StateEstimatorParameters {
    private final boolean runningOnRealRobot;
    private final double estimatorDT;
    private final double jointVelocitySlopTimeForBacklashCompensation;
    private static final double backXBacklashSlopTime = 0.03;
    private static final double backXAlphaFilterBreakFrequency = 16.0;
    private final double defaultFilterBreakFrequency;
    private final double defaultFilterBreakFrequencyArm;
    private SensorNoiseParameters sensorNoiseParameters = null;
    private final boolean doElasticityCompensation;
    private final double jointElasticityFilterFrequencyHz;
    private final double defaultJointStiffness;
    private final HashMap<String, Double> jointSpecificStiffness = new HashMap();
    private final SideDependentList<String> footForceSensorNames;
    private final SideDependentList<String> wristForceSensorNames;
    private final HumanoidJointNameMap jointMap;
    private final List<IMUBasedJointStateEstimatorParameters> imuBasedJointStateEstimatorParameters = new ArrayList<IMUBasedJointStateEstimatorParameters>();
    private final boolean applyJointPositionPolynomialApproximation;
    private final String chestIMU;

    public AtlasStateEstimatorParameters(HumanoidJointNameMap jointMap, AtlasSensorInformation sensorInformation, boolean runningOnRealRobot, double estimatorDT) {
        this.jointMap = jointMap;
        this.runningOnRealRobot = runningOnRealRobot;
        this.estimatorDT = estimatorDT;
        this.wristForceSensorNames = sensorInformation.getWristForceSensorNames();
        this.footForceSensorNames = sensorInformation.getFeetForceSensorNames();
        this.defaultFilterBreakFrequency = runningOnRealRobot ? 16.0 : Double.POSITIVE_INFINITY;
        this.defaultFilterBreakFrequencyArm = runningOnRealRobot ? 40.0 : Double.POSITIVE_INFINITY;
        this.jointVelocitySlopTimeForBacklashCompensation = 0.03;
        this.applyJointPositionPolynomialApproximation = runningOnRealRobot;
        this.doElasticityCompensation = runningOnRealRobot;
        this.jointElasticityFilterFrequencyHz = 20.0;
        this.defaultJointStiffness = 20000.0;
        for (RobotSide robotSide : RobotSide.values) {
            this.jointSpecificStiffness.put(jointMap.getLegJointName(robotSide, LegJointName.HIP_ROLL), 12000.0);
        }
        String pelvisIMU = sensorInformation.getPrimaryBodyImu();
        this.chestIMU = sensorInformation.getChestImu();
        double breakFrequencyForVelocityEstimation = AlphaFilteredYoVariable.computeBreakFrequencyGivenAlpha((double)0.85, (double)0.001);
        double breakFrequencyForPositionEstimation = AlphaFilteredYoVariable.computeBreakFrequencyGivenAlpha((double)(runningOnRealRobot ? 0.995 : 0.0), (double)0.001);
        this.imuBasedJointStateEstimatorParameters.add(new IMUBasedJointStateEstimatorParameters("Spine", true, pelvisIMU, this.chestIMU, breakFrequencyForVelocityEstimation, breakFrequencyForPositionEstimation));
    }

    public void configureSensorProcessing(SensorProcessing sensorProcessing) {
        YoRegistry registry = sensorProcessing.getYoVariableRegistry();
        for (LegJointName legJointName : this.jointMap.getLegJointNames()) {
            for (RobotSide robotSide : RobotSide.values) {
                String name = this.jointMap.getLegJointName(robotSide, legJointName);
                YoDouble bias = new YoDouble("q_offset_" + name, registry);
                if (this.runningOnRealRobot && legJointName == LegJointName.HIP_ROLL && robotSide == RobotSide.RIGHT) {
                    bias.set(0.02);
                }
                sensorProcessing.addJointPositionAffineTransformOnlyForSpecifiedJoints(null, (DoubleProvider)bias, false, new String[]{name});
            }
        }
        for (LegJointName legJointName : this.jointMap.getSpineJointNames()) {
            String name = this.jointMap.getSpineJointName((SpineJointName)legJointName);
            YoDouble bias = new YoDouble("q_offset_" + name, registry);
            if (this.runningOnRealRobot && legJointName == SpineJointName.SPINE_ROLL) {
                bias.set(0.015);
            }
            sensorProcessing.addJointPositionAffineTransformOnlyForSpecifiedJoints(null, (DoubleProvider)bias, false, new String[]{name});
        }
        if (this.applyJointPositionPolynomialApproximation) {
            double[] coefficients = new double[]{0.00305, 1.04087};
            ParameterPolynomial backZPolynomial = new ParameterPolynomial("q_poly_back_bkz", coefficients, registry);
            sensorProcessing.addJointPositionPolynomialProcessorOnlyForSpecifiedJoints((PolynomialReadOnly)backZPolynomial, false, new String[]{this.jointMap.getSpineJointName(SpineJointName.SPINE_YAW)});
        }
        String[] armJointNames = this.createArmJointNames();
        String[] backXName = new String[]{this.jointMap.getSpineJointName(SpineJointName.SPINE_ROLL)};
        String[] armAndBackJoints = new String[armJointNames.length + backXName.length];
        System.arraycopy(armJointNames, 0, armAndBackJoints, 0, armJointNames.length);
        System.arraycopy(backXName, 0, armAndBackJoints, armJointNames.length, backXName.length);
        DoubleProvider doubleProvider = sensorProcessing.createAlphaFilter("backXAlphaFilter", 16.0);
        DoubleParameter backXSlopTime = new DoubleParameter("backXSlopTime", registry, 0.03);
        DoubleProvider jointVelocityAlphaFilter = sensorProcessing.createAlphaFilter("jointVelocityAlphaFilter", this.defaultFilterBreakFrequency);
        DoubleProvider wristForceAlphaFilter = sensorProcessing.createAlphaFilter("wristForceAlphaFilter", this.defaultFilterBreakFrequency);
        DoubleParameter jointVelocitySlopTime = new DoubleParameter("jointBacklashSlopTime", registry, this.jointVelocitySlopTimeForBacklashCompensation);
        DoubleProvider armJointVelocityAlphaFilter1 = sensorProcessing.createAlphaFilter("armJointVelocityAlphaFilter1", this.defaultFilterBreakFrequencyArm);
        DoubleParameter armJointVelocitySlopTime = new DoubleParameter("armJointBacklashSlopTime", registry, this.jointVelocitySlopTimeForBacklashCompensation);
        DoubleProvider orientationAlphaFilter = sensorProcessing.createAlphaFilter("orientationAlphaFilter", this.defaultFilterBreakFrequency);
        DoubleProvider angularVelocityAlphaFilter = sensorProcessing.createAlphaFilter("angularVelocityAlphaFilter", this.defaultFilterBreakFrequency);
        DoubleProvider linearAccelerationAlphaFilter = sensorProcessing.createAlphaFilter("linearAccelerationAlphaFilter", this.defaultFilterBreakFrequency);
        sensorProcessing.computeJointVelocityFromFiniteDifferenceWithJointsToIgnore(jointVelocityAlphaFilter, false, armAndBackJoints);
        sensorProcessing.computeJointVelocityFromFiniteDifferenceOnlyForSpecifiedJoints(doubleProvider, false, backXName);
        sensorProcessing.computeJointVelocityFromFiniteDifferenceOnlyForSpecifiedJoints(armJointVelocityAlphaFilter1, false, armJointNames);
        if (this.doElasticityCompensation) {
            DoubleProvider elasticityAlphaFilter = sensorProcessing.createAlphaFilter("jointDeflectionDotAlphaFilter", this.jointElasticityFilterFrequencyHz);
            DoubleProvider maxDeflection = sensorProcessing.createMaxDeflection("jointAngleMaxDeflection", 0.1);
            Map jointPositionStiffness = sensorProcessing.createStiffnessWithJointsToIgnore("stiffness", this.defaultJointStiffness, this.jointSpecificStiffness, armJointNames);
            Map filteredTauForElasticity = sensorProcessing.addSensorAlphaFilterWithSensorsToIgnore(elasticityAlphaFilter, true, SensorProcessing.SensorType.JOINT_TAU, armJointNames);
            sensorProcessing.addJointPositionElasticyCompensatorWithJointsToIgnore(jointPositionStiffness, maxDeflection, filteredTauForElasticity, false, armJointNames);
            sensorProcessing.addJointVelocityElasticyCompensatorWithJointsToIgnore(jointPositionStiffness, maxDeflection, filteredTauForElasticity, false, armJointNames);
        }
        sensorProcessing.addJointVelocityBacklashFilterWithJointsToIgnore((DoubleProvider)jointVelocitySlopTime, false, armAndBackJoints);
        sensorProcessing.addJointVelocityBacklashFilterOnlyForSpecifiedJoints((DoubleProvider)backXSlopTime, false, backXName);
        sensorProcessing.addJointVelocityBacklashFilterOnlyForSpecifiedJoints((DoubleProvider)armJointVelocitySlopTime, false, armJointNames);
        sensorProcessing.computeJointAccelerationFromFiniteDifference(jointVelocityAlphaFilter, false);
        if (this.runningOnRealRobot) {
            YoVector3D chestIMUBias = new YoVector3D("chestIMUAngularVelocityBias", registry);
            chestIMUBias.set(0.0075, 0.0, -0.008);
            sensorProcessing.addIMUAngularVelocityBiasOnlyForSpecifiedSensors((Vector3DReadOnly)chestIMUBias, false, new String[]{this.chestIMU});
        }
        sensorProcessing.addSensorAlphaFilter(orientationAlphaFilter, false, SensorProcessing.SensorType.IMU_ORIENTATION);
        sensorProcessing.addSensorAlphaFilter(angularVelocityAlphaFilter, false, SensorProcessing.SensorType.IMU_ANGULAR_VELOCITY);
        sensorProcessing.addSensorAlphaFilter(linearAccelerationAlphaFilter, false, SensorProcessing.SensorType.IMU_LINEAR_ACCELERATION);
        if (this.wristForceSensorNames != null) {
            for (RobotSide robotSide : RobotSide.values) {
                sensorProcessing.addSensorAlphaFilterOnlyForSpecifiedSensors(wristForceAlphaFilter, false, SensorProcessing.SensorType.FORCE_SENSOR, new String[]{(String)this.wristForceSensorNames.get((Enum)robotSide)});
                sensorProcessing.addSensorAlphaFilterOnlyForSpecifiedSensors(wristForceAlphaFilter, false, SensorProcessing.SensorType.TORQUE_SENSOR, new String[]{(String)this.wristForceSensorNames.get((Enum)robotSide)});
            }
        }
    }

    private String[] createArmJointNames() {
        ArrayList<String> armJointNameList = new ArrayList<String>();
        for (RobotSide robotSide : RobotSide.values) {
            for (ArmJointName jointName : this.jointMap.getArmJointNames()) {
                armJointNameList.add(this.jointMap.getArmJointName(robotSide, jointName));
            }
        }
        String[] armJointNames = new String[armJointNameList.size()];
        armJointNameList.toArray(armJointNames);
        return armJointNames;
    }

    public SensorNoiseParameters getSensorNoiseParameters() {
        return this.sensorNoiseParameters;
    }

    public double getEstimatorDT() {
        return this.estimatorDT;
    }

    public double getKinematicsPelvisPositionFilterFreqInHertz() {
        return Double.POSITIVE_INFINITY;
    }

    public double getCoPFilterFreqInHertz() {
        return 4.0;
    }

    public boolean enableIMUBiasCompensation() {
        return true;
    }

    public boolean enableIMUYawDriftCompensation() {
        return true;
    }

    public double getIMUBiasFilterFreqInHertz() {
        return 0.006;
    }

    public double getIMUYawDriftFilterFreqInHertz() {
        return 0.04;
    }

    public double getIMUBiasVelocityThreshold() {
        return 0.015;
    }

    public boolean useAccelerometerForEstimation() {
        return true;
    }

    public boolean cancelGravityFromAccelerationMeasurement() {
        return true;
    }

    public double getPelvisPositionFusingFrequency() {
        return 11.7893;
    }

    public double getPelvisLinearVelocityFusingFrequency() {
        return 0.4261;
    }

    public double getDelayTimeForTrustingFoot() {
        return 0.02;
    }

    public double getForceInPercentOfWeightThresholdToTrustFoot() {
        return 0.35;
    }

    public double getForceInPercentOfWeightThresholdToNotTrustFoot() {
        return 0.3;
    }

    public boolean trustCoPAsNonSlippingContactPoint() {
        return true;
    }

    public double getPelvisLinearVelocityAlphaNewTwist() {
        return 0.15;
    }

    public FootSwitchFactory getFootSwitchFactory() {
        WrenchBasedFootSwitchFactory footSwitchFactory = new WrenchBasedFootSwitchFactory();
        footSwitchFactory.setDefaultContactThresholdForce(120.0);
        footSwitchFactory.setDefaultCoPThresholdFraction(0.02);
        footSwitchFactory.setDefaultSecondContactThresholdForceIgnoringCoP(Double.POSITIVE_INFINITY);
        return footSwitchFactory;
    }

    public SideDependentList<String> getWristForceSensorNames() {
        return this.wristForceSensorNames;
    }

    public boolean requestWristForceSensorCalibrationAtStart() {
        return this.runningOnRealRobot;
    }

    public SideDependentList<String> getFootForceSensorNames() {
        return this.footForceSensorNames;
    }

    public boolean requestFootForceSensorCalibrationAtStart() {
        return false;
    }

    public boolean requestFrozenModeAtStart() {
        return false;
    }

    public boolean getPelvisLinearStateUpdaterTrustImuWhenNoFeetAreInContact() {
        return false;
    }

    public double getCenterOfMassVelocityFusingFrequency() {
        return 5.0;
    }

    public boolean useGroundReactionForcesToComputeCenterOfMassVelocity() {
        return false;
    }

    public boolean correctTrustedFeetPositions() {
        return true;
    }

    public List<IMUBasedJointStateEstimatorParameters> getIMUBasedJointStateEstimatorParameters() {
        return this.imuBasedJointStateEstimatorParameters;
    }
}

