/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.parameters;

import us.ihmc.avatar.drcRobot.RobotPhysicalProperties;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.robotics.geometry.TransformTools;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;

public class AtlasPhysicalProperties
implements RobotPhysicalProperties {
    private static final double ATLAS_HEIGHT = 2.0;
    private static final double ATLAS_WEIGHT = 155.944174;
    private final double modelScale;
    private double massScalePower = 3.0;
    private final double ankleHeight;
    private final double pelvisToFoot;
    private final double footWidthForControl;
    private final double toeWidthForControl;
    private final double footLengthForControl;
    private final double footBackForControl;
    private final double actualFootWidth;
    private final double actualFootLength;
    private final double footStartToetaperFromBack;
    private final double footForwardForControl;
    private final double shinLength;
    private final double thighLength;
    private final SideDependentList<RigidBodyTransform> soleToAnkleFrameTransforms = new SideDependentList();
    private final SideDependentList<RigidBodyTransform> handAttachmentPlateToWristTransforms = new SideDependentList();

    public AtlasPhysicalProperties() {
        this(1.0);
    }

    public AtlasPhysicalProperties(double height, double weight) {
        this(height / 2.0);
        double massFactor = Math.log(weight / 155.944174) / Math.log(this.modelScale);
        this.setMassScalePower(massFactor);
    }

    public AtlasPhysicalProperties(double modelScale) {
        this.modelScale = modelScale;
        double footWidthScale = modelScale;
        this.ankleHeight = modelScale * 0.084;
        this.pelvisToFoot = modelScale * 0.887;
        this.footWidthForControl = footWidthScale * 0.11;
        this.toeWidthForControl = footWidthScale * 0.085;
        this.footLengthForControl = modelScale * 0.22;
        this.footBackForControl = modelScale * 0.085;
        this.actualFootWidth = footWidthScale * 0.138;
        this.actualFootLength = modelScale * 0.26;
        this.footStartToetaperFromBack = modelScale * 0.195;
        this.footForwardForControl = this.footLengthForControl - this.footBackForControl;
        this.shinLength = modelScale * 0.374;
        this.thighLength = modelScale * 0.422;
        for (RobotSide robotSide : RobotSide.values) {
            RigidBodyTransform soleToAnkleFrame = TransformTools.createTranslationTransform((double)(this.footLengthForControl / 2.0 - this.footBackForControl), (double)0.0, (double)(-this.ankleHeight));
            this.soleToAnkleFrameTransforms.put((Enum)robotSide, (Object)soleToAnkleFrame);
            double y = robotSide.negateIfRightSide(0.1);
            double yaw = robotSide.negateIfRightSide(1.5707963267948966);
            RigidBodyTransform handControlFrameToWristTransform = TransformTools.createTransformFromTranslationAndEulerAngles((double)0.0, (double)y, (double)0.0, (double)0.0, (double)0.0, (double)yaw);
            this.handAttachmentPlateToWristTransforms.put((Enum)robotSide, (Object)handControlFrameToWristTransform);
        }
    }

    public double getFootWidthForControl() {
        return this.footWidthForControl;
    }

    public double getToeWidthForControl() {
        return this.toeWidthForControl;
    }

    public double getFootLengthForControl() {
        return this.footLengthForControl;
    }

    public double getFootBackForControl() {
        return this.footBackForControl;
    }

    public double getActualFootWidth() {
        return this.actualFootWidth;
    }

    public double getActualFootLength() {
        return this.actualFootLength;
    }

    public double getFootForwardForControl() {
        return this.footForwardForControl;
    }

    public double getShinLength() {
        return this.shinLength;
    }

    public double getThighLength() {
        return this.thighLength;
    }

    public SideDependentList<RigidBodyTransform> getSoleToAnkleFrameTransforms() {
        return this.soleToAnkleFrameTransforms;
    }

    public SideDependentList<RigidBodyTransform> getHandAttachmentPlateToWristTransforms() {
        return this.handAttachmentPlateToWristTransforms;
    }

    public double getModelScale() {
        return this.modelScale;
    }

    public double getMassScalePower() {
        return this.massScalePower;
    }

    public void setMassScalePower(double massScalePower) {
        this.massScalePower = massScalePower;
    }
}

