/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.behaviors.scsSensorSimulation;

import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.robotics.lidar.LidarScanParameters;
import us.ihmc.robotics.robotDescription.LidarSensorDescription;
import us.ihmc.simulationconstructionset.CameraMount;
import us.ihmc.simulationconstructionset.GimbalJoint;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.Link;
import us.ihmc.simulationconstructionset.PinJoint;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.simulatedSensors.LidarMount;

public class SensorOnlyRobot
extends Robot {
    private final LidarScanParameters lidarScanParameters;
    private final GimbalJoint gimbalJoint;

    public SensorOnlyRobot() {
        super("SensorOnlyRobot");
        double height = 0.2;
        double radius = 0.05;
        this.gimbalJoint = new GimbalJoint("gimbalZ", "gimbalX", "gimbalY", (Vector3DReadOnly)new Vector3D(0.0, 0.0, 1.0), (Robot)this, Axis3D.Z, Axis3D.X, Axis3D.Y);
        Link link = new Link("lidar");
        link.setMassAndRadiiOfGyration(1.0, radius, radius, radius);
        Graphics3DObject linkGraphics = new Graphics3DObject();
        link.setLinkGraphics(linkGraphics);
        this.gimbalJoint.setLink(link);
        this.gimbalJoint.setDamping(1.0);
        CameraMount robotCam = new CameraMount("camera", (Tuple3DReadOnly)new Vector3D(radius + 0.001, 0.0, height / 2.0), (Robot)this);
        this.gimbalJoint.addCameraMount(robotCam);
        RigidBodyTransform transform = new RigidBodyTransform();
        transform.getTranslation().set((Tuple3DReadOnly)new Vector3D(radius + 0.001, 0.0, height / 2.0));
        this.lidarScanParameters = new LidarScanParameters(720, -1.5707964f, 1.5707964f, 0.0f, 0.1f, 30.0f, 0.0f);
        LidarSensorDescription lidarSensorDescription = new LidarSensorDescription("lidar", (RigidBodyTransformReadOnly)transform);
        lidarSensorDescription.setPointsPerSweep(this.lidarScanParameters.getPointsPerSweep());
        lidarSensorDescription.setScanHeight(this.lidarScanParameters.getScanHeight());
        lidarSensorDescription.setSweepYawLimits((double)this.lidarScanParameters.getSweepYawMin(), (double)this.lidarScanParameters.getSweepYawMax());
        lidarSensorDescription.setHeightPitchLimits((double)this.lidarScanParameters.heightPitchMin, (double)this.lidarScanParameters.heightPitchMax);
        lidarSensorDescription.setRangeLimits((double)this.lidarScanParameters.getMinRange(), (double)this.lidarScanParameters.getMaxRange());
        LidarMount lidarMount = new LidarMount(lidarSensorDescription);
        this.gimbalJoint.addLidarMount(lidarMount);
        linkGraphics.addModelFile("models/hokuyo.dae", YoAppearance.Black());
        linkGraphics.translate(0.0, 0.0, -0.1);
        link.setLinkGraphics(linkGraphics);
        this.addRootJoint((Joint)this.gimbalJoint);
    }

    public GimbalJoint getLidarZJoint() {
        return this.gimbalJoint;
    }

    public PinJoint getLidarXJoint() {
        return (PinJoint)this.gimbalJoint.getChildrenJoints().get(0);
    }

    public LidarScanParameters getLidarScanParameters() {
        return this.lidarScanParameters;
    }
}

