/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.behaviors;

import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import us.ihmc.atlas.sensors.AtlasSLAMBasedREAStandaloneLauncher;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.behaviors.tools.PlanarRegionSLAMMapper;
import us.ihmc.behaviors.tools.perception.MultisenseHeadStereoSimulator;
import us.ihmc.behaviors.tools.perception.MultisenseLidarSimulator;
import us.ihmc.behaviors.tools.perception.RealsensePelvisSimulator;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.communication.CommunicationMode;
import us.ihmc.communication.IHMCROS2Publisher;
import us.ihmc.communication.PerceptionAPI;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.packets.PlanarRegionMessageConverter;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotEnvironmentAwareness.communication.REACommunicationProperties;
import us.ihmc.robotEnvironmentAwareness.communication.converters.PointCloudMessageTools;
import us.ihmc.robotEnvironmentAwareness.io.FilePropertyHelper;
import us.ihmc.robotEnvironmentAwareness.updaters.LIDARBasedREAModule;
import us.ihmc.robotEnvironmentAwareness.updaters.REANetworkProvider;
import us.ihmc.robotEnvironmentAwareness.updaters.REAPlanarRegionPublicNetworkProvider;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.tools.thread.PausablePeriodicThread;

public class AtlasPerceptionSimulation {
    private final boolean runRealsenseSLAM;
    private final boolean runLidarREA;
    private PausablePeriodicThread multisenseLidarPublisher;
    private PausablePeriodicThread multisenseRegionsPublisher;
    private PausablePeriodicThread realsenseRegionsPublisher;
    private AtlasSLAMBasedREAStandaloneLauncher realsenseSLAMFramework;
    private PausablePeriodicThread realsensePointCloudPublisher;
    private LIDARBasedREAModule lidarREA;

    public AtlasPerceptionSimulation(CommunicationMode communicationMode, PlanarRegionsList map, boolean runRealsenseSLAM, boolean spawnUIs, boolean runLidarREA, DRCRobotModel robotModel, Fidelity fidelity) {
        IHMCROS2Publisher publisher;
        int realsenseSphereScanSize;
        int multisenseStereoSphereScanSize;
        int multisenseLidarScanSize;
        this.runRealsenseSLAM = runRealsenseSLAM;
        this.runLidarREA = runLidarREA;
        ROS2Node ros2Node = ROS2Tools.createROS2Node((DomainFactory.PubSubImplementation)communicationMode.getPubSubImplementation(), (String)"perception");
        double period = 1.0;
        double realsenseRange = 3.0;
        double multisenseStereoRange = 10.0;
        if (fidelity == Fidelity.LOW) {
            multisenseLidarScanSize = 200;
            multisenseStereoSphereScanSize = 8000;
            realsenseSphereScanSize = 4000;
        } else {
            multisenseLidarScanSize = 500;
            multisenseStereoSphereScanSize = 50000;
            realsenseSphereScanSize = 30000;
        }
        if (runLidarREA) {
            MultisenseLidarSimulator multisenseLidar = new MultisenseLidarSimulator(robotModel, ros2Node, map, multisenseLidarScanSize);
            publisher = ROS2Tools.createPublisher((ROS2NodeInterface)ros2Node, (ROS2Topic)PerceptionAPI.MULTISENSE_LIDAR_SCAN);
            multisenseLidar.addLidarScanListener(scan -> publisher.publish((Object)PointCloudMessageTools.toLidarScanMessage((List)scan, (Pose3DReadOnly)multisenseLidar.getSensorPose())));
            ExceptionTools.handle(() -> {
                REAPlanarRegionPublicNetworkProvider networkProvider = new REAPlanarRegionPublicNetworkProvider((ROS2NodeInterface)ROS2Tools.createROS2Node((DomainFactory.PubSubImplementation)communicationMode.getPubSubImplementation(), (String)"REA_module"), REACommunicationProperties.outputTopic, REACommunicationProperties.lidarOutputTopic, REACommunicationProperties.stereoOutputTopic, REACommunicationProperties.depthOutputTopic);
                File reaConfigurationFile = Paths.get(System.getProperty("user.home"), new String[0]).resolve(".ihmc/REAModuleConfiguration.txt").toFile();
                this.lidarREA = LIDARBasedREAModule.createRemoteModule((FilePropertyHelper)new FilePropertyHelper(reaConfigurationFile), (REANetworkProvider)networkProvider);
                this.lidarREA.start();
            }, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        } else {
            MultisenseHeadStereoSimulator multisenseStereo = new MultisenseHeadStereoSimulator(map, robotModel, (ROS2NodeInterface)ros2Node, multisenseStereoRange, multisenseStereoSphereScanSize);
            publisher = ROS2Tools.createPublisher((ROS2NodeInterface)ros2Node, (ROS2Topic)PerceptionAPI.LIDAR_REA_REGIONS);
            this.multisenseRegionsPublisher = new PausablePeriodicThread("MultisenseREARegionsPublisher", period, () -> publisher.publish((Object)PlanarRegionMessageConverter.convertToPlanarRegionsListMessage((PlanarRegionsList)multisenseStereo.computeRegions())));
            this.multisenseRegionsPublisher.start();
        }
        RealsensePelvisSimulator realsense = new RealsensePelvisSimulator(map, robotModel, (ROS2NodeInterface)ros2Node, realsenseRange, realsenseSphereScanSize);
        if (runRealsenseSLAM) {
            publisher = ROS2Tools.createPublisher((ROS2NodeInterface)ros2Node, (ROS2Topic)PerceptionAPI.D435_POINT_CLOUD);
            this.realsensePointCloudPublisher = new PausablePeriodicThread("RealsensePointCloudPublisher", period, () -> {
                List pointCloud = realsense.getPointCloud();
                if (!pointCloud.isEmpty()) {
                    publisher.publish((Object)PointCloudMessageTools.toStereoVisionPointCloudMessage((List)pointCloud, (Pose3DReadOnly)realsense.getSensorPose()));
                }
            });
            this.realsensePointCloudPublisher.start();
            this.realsenseSLAMFramework = new AtlasSLAMBasedREAStandaloneLauncher(spawnUIs, communicationMode.getPubSubImplementation());
        } else {
            PlanarRegionSLAMMapper realsenseSLAM = new PlanarRegionSLAMMapper();
            IHMCROS2Publisher publisher2 = ROS2Tools.createPublisher((ROS2NodeInterface)ros2Node, (ROS2Topic)PerceptionAPI.REALSENSE_SLAM_REGIONS);
            this.realsenseRegionsPublisher = new PausablePeriodicThread("RealsenseSLAMPublisher", period, () -> publisher2.publish((Object)PlanarRegionMessageConverter.convertToPlanarRegionsListMessage((PlanarRegionsList)realsenseSLAM.update(realsense.computeRegions()))));
            this.realsenseRegionsPublisher.start();
        }
    }

    public void destroy() {
        LogTools.info((String)"Shutting down...");
        if (this.runLidarREA) {
            this.lidarREA.stop();
        } else {
            this.multisenseRegionsPublisher.stop();
        }
        if (this.runRealsenseSLAM) {
            this.realsensePointCloudPublisher.stop();
            this.realsenseSLAMFramework.stop();
        } else {
            this.realsenseRegionsPublisher.stop();
        }
    }

    public static enum Fidelity {
        LOW,
        HIGH;

    }
}

