/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas;

import java.io.InputStream;
import us.ihmc.avatar.drcRobot.RobotVersion;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.wholeBodyController.DRCHandType;

public enum AtlasRobotVersion implements RobotVersion
{
    ATLAS_UNPLUGGED_V5_NO_FOREARMS,
    ATLAS_UNPLUGGED_V5_NO_HANDS,
    ATLAS_UNPLUGGED_V5_DUAL_ROBOTIQ,
    ATLAS_UNPLUGGED_V5_ROBOTIQ_AND_SRI,
    ATLAS_UNPLUGGED_V5_TROOPER,
    ATLAS_UNPLUGGED_V5_LEFT_NUB_RIGHT_ROBOTIQ;

    private static String[] resourceDirectories;
    private final SideDependentList<RigidBodyTransform> offsetHandFromAttachmentPlate = new SideDependentList();

    public DRCHandType getHandModel(RobotSide side) {
        switch (this) {
            case ATLAS_UNPLUGGED_V5_DUAL_ROBOTIQ: 
            case ATLAS_UNPLUGGED_V5_TROOPER: {
                return DRCHandType.ROBOTIQ;
            }
            case ATLAS_UNPLUGGED_V5_ROBOTIQ_AND_SRI: {
                return DRCHandType.ROBOTIQ_AND_SRI;
            }
            case ATLAS_UNPLUGGED_V5_LEFT_NUB_RIGHT_ROBOTIQ: {
                return side == RobotSide.RIGHT ? DRCHandType.ROBOTIQ : DRCHandType.NONE;
            }
        }
        return DRCHandType.NONE;
    }

    public boolean hasRobotiqHands(RobotSide side) {
        return this.getHandModel(side) == DRCHandType.ROBOTIQ || this.getHandModel(side) == DRCHandType.ROBOTIQ_AND_SRI;
    }

    public String getSdfFile() {
        switch (this) {
            case ATLAS_UNPLUGGED_V5_NO_HANDS: {
                return "models/GFE/atlas_unplugged_v5.sdf";
            }
            case ATLAS_UNPLUGGED_V5_DUAL_ROBOTIQ: 
            case ATLAS_UNPLUGGED_V5_ROBOTIQ_AND_SRI: {
                return "models/GFE/atlas_unplugged_v5_dual_robotiq.sdf";
            }
            case ATLAS_UNPLUGGED_V5_LEFT_NUB_RIGHT_ROBOTIQ: {
                return "models/GFE/atlas_unplugged_v5_left_nub_right_robotiq.sdf";
            }
            case ATLAS_UNPLUGGED_V5_NO_FOREARMS: {
                return "models/GFE/atlas_unplugged_v5_no_forearms.sdf";
            }
            case ATLAS_UNPLUGGED_V5_TROOPER: {
                return "models/GFE/atlas_unplugged_v5_trooper.sdf";
            }
        }
        throw new RuntimeException("AtlasRobotVersion: Unimplemented enumeration case : " + this);
    }

    public String[] getResourceDirectories() {
        if (resourceDirectories == null) {
            resourceDirectories = new String[]{"models/GFE/"};
        }
        return resourceDirectories;
    }

    public InputStream getSdfFileAsStream() {
        return ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.getSdfFile());
    }

    public RigidBodyTransform getOffsetFromAttachmentPlate(RobotSide side) {
        if (this.offsetHandFromAttachmentPlate.get((Enum)side) == null) {
            this.createTransforms();
        }
        return (RigidBodyTransform)this.offsetHandFromAttachmentPlate.get((Enum)side);
    }

    private void createTransforms() {
        for (RobotSide robotSide : RobotSide.values) {
            double distanceAttachmentPlateHand = this.getHandModel(robotSide) == DRCHandType.ROBOTIQ ? 0.12 : 0.0;
            Point3D centerOfHandToWristTranslation = new Point3D();
            Quaternion centerOfHandToWristOrientation = new Quaternion();
            if (this.hasRobotiqHands(robotSide)) {
                centerOfHandToWristTranslation = new Point3D(distanceAttachmentPlateHand, 0.0, 0.0);
                centerOfHandToWristOrientation.appendRollRotation(robotSide.negateIfLeftSide(1.5707963267948966));
            }
            this.offsetHandFromAttachmentPlate.set((Enum)robotSide, (Object)new RigidBodyTransform((Orientation3DReadOnly)centerOfHandToWristOrientation, (Tuple3DReadOnly)centerOfHandToWristTranslation));
        }
    }

    public String getModelName() {
        return "atlas";
    }
}

