/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas;

import java.io.InputStream;
import java.util.Arrays;
import java.util.function.Consumer;
import us.ihmc.atlas.AtlasDampingParameters;
import us.ihmc.atlas.AtlasDirectRobotInterface;
import us.ihmc.atlas.AtlasJointMap;
import us.ihmc.atlas.AtlasRobotDefinitionHandMutator;
import us.ihmc.atlas.AtlasRobotDefinitionMutator;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.atlas.behaviors.AtlasLookAndStepParameters;
import us.ihmc.atlas.diagnostic.AtlasDiagnosticParameters;
import us.ihmc.atlas.initialSetup.AtlasSimInitialSetup;
import us.ihmc.atlas.parameters.AtlasCoPTrajectoryParameters;
import us.ihmc.atlas.parameters.AtlasContactPointParameters;
import us.ihmc.atlas.parameters.AtlasFootstepPlannerParameters;
import us.ihmc.atlas.parameters.AtlasHighLevelControllerParameters;
import us.ihmc.atlas.parameters.AtlasICPSplitFractionCalculatorParameters;
import us.ihmc.atlas.parameters.AtlasKinematicsCollisionModel;
import us.ihmc.atlas.parameters.AtlasPhysicalProperties;
import us.ihmc.atlas.parameters.AtlasPushRecoveryControllerParameters;
import us.ihmc.atlas.parameters.AtlasSensorInformation;
import us.ihmc.atlas.parameters.AtlasSimulationCollisionModel;
import us.ihmc.atlas.parameters.AtlasStateEstimatorParameters;
import us.ihmc.atlas.parameters.AtlasSwingPlannerParameters;
import us.ihmc.atlas.parameters.AtlasUIParameters;
import us.ihmc.atlas.parameters.AtlasVisibilityGraphParameters;
import us.ihmc.atlas.parameters.AtlasWalkingControllerParameters;
import us.ihmc.atlas.ros.AtlasPPSTimestampOffsetProvider;
import us.ihmc.atlas.sensors.AtlasCollisionBoxProvider;
import us.ihmc.atlas.sensors.AtlasSensorSuiteManager;
import us.ihmc.avatar.DRCSimulationOutputWriterForControllerThread;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.avatar.drcRobot.RobotVersion;
import us.ihmc.avatar.handControl.packetsAndConsumers.HandModel;
import us.ihmc.avatar.initialSetup.RobotInitialSetup;
import us.ihmc.avatar.kinematicsSimulation.SimulatedHandKinematicController;
import us.ihmc.avatar.networkProcessor.time.DRCROSAlwaysZeroOffsetPPSTimestampOffsetProvider;
import us.ihmc.avatar.reachabilityMap.footstep.StepReachabilityIOHelper;
import us.ihmc.avatar.ros.DRCROSPPSTimestampOffsetProvider;
import us.ihmc.avatar.ros.RobotROSClockCalculator;
import us.ihmc.avatar.ros.RobotROSClockCalculatorFromPPSOffset;
import us.ihmc.behaviors.lookAndStep.LookAndStepBehaviorParameters;
import us.ihmc.commonWalkingControlModules.barrierScheduler.context.HumanoidRobotContextData;
import us.ihmc.commonWalkingControlModules.capturePoint.splitFractionCalculation.SplitFractionCalculatorParametersReadOnly;
import us.ihmc.commonWalkingControlModules.configurations.HighLevelControllerParameters;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.CoPTrajectoryParameters;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.pushRecoveryController.PushRecoveryControllerParameters;
import us.ihmc.commonWalkingControlModules.staticReachability.StepReachabilityData;
import us.ihmc.commons.Conversions;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.controllerAPI.RobotLowLevelMessenger;
import us.ihmc.footstepPlanning.AStarBodyPathPlannerParameters;
import us.ihmc.footstepPlanning.AStarBodyPathPlannerParametersBasics;
import us.ihmc.footstepPlanning.graphSearch.parameters.FootstepPlannerParametersBasics;
import us.ihmc.footstepPlanning.swing.SwingPlannerParametersBasics;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.modelFileLoaders.SdfLoader.SDFModelLoader;
import us.ihmc.multicastLogDataProtocol.modelLoaders.DefaultLogModelProvider;
import us.ihmc.multicastLogDataProtocol.modelLoaders.LogModelProvider;
import us.ihmc.pathPlanning.visibilityGraphs.parameters.VisibilityGraphsParametersBasics;
import us.ihmc.perception.depthData.CollisionBoxProvider;
import us.ihmc.robotDataLogger.logger.DataServerSettings;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullHumanoidRobotModelFactory;
import us.ihmc.robotModels.FullHumanoidRobotModelWrapper;
import us.ihmc.robotics.partNames.ArmJointName;
import us.ihmc.robotics.partNames.ContactPointDefinitionHolder;
import us.ihmc.robotics.partNames.HumanoidJointNameMap;
import us.ihmc.robotics.partNames.JointNameMap;
import us.ihmc.robotics.physics.CollidableHelper;
import us.ihmc.robotics.physics.RobotCollisionModel;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotiq.model.RobotiqHandModel;
import us.ihmc.robotiq.simulatedHand.SimulatedRobotiqHandKinematicController;
import us.ihmc.robotiq.simulatedHand.SimulatedRobotiqHandsControlThread;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.RealtimeROS2Node;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinitions;
import us.ihmc.scs2.definition.visual.MaterialDefinition;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputWriter;
import us.ihmc.sensorProcessing.stateEstimation.StateEstimatorParameters;
import us.ihmc.simulationConstructionSetTools.util.HumanoidFloatingRootJointRobot;
import us.ihmc.simulationToolkit.RobotDefinitionTools;
import us.ihmc.simulationconstructionset.FloatingRootJointRobot;
import us.ihmc.wholeBodyController.DRCOutputProcessor;
import us.ihmc.wholeBodyController.FootContactPoints;
import us.ihmc.wholeBodyController.UIParameters;
import us.ihmc.wholeBodyController.diagnostics.DiagnosticParameters;
import us.ihmc.yoVariables.providers.DoubleProvider;

public class AtlasRobotModel
implements DRCRobotModel {
    public static final boolean SCALE_ATLAS = false;
    private static final double DESIRED_ATLAS_HEIGHT = 0.66;
    private static final double DESIRED_ATLAS_WEIGHT = 15.0;
    private final double HARDSTOP_RESTRICTION_ANGLE = Math.toRadians(5.0);
    private final AtlasRobotVersion selectedVersion;
    private final RobotTarget target;
    private static final long ESTIMATOR_DT_IN_NS = 1000000L;
    private static final double ESTIMATOR_DT = Conversions.nanosecondsToSeconds((long)1000000L);
    private static final double CONTROL_DT = 0.004;
    private static final double ATLAS_ONBOARD_SAMPLINGFREQ = 1000.0;
    public static final double ATLAS_ONBOARD_DT = 0.001;
    public static final boolean BATTERY_MASS_SIMULATOR_IN_ROBOT = false;
    private final AtlasPhysicalProperties atlasPhysicalProperties = new AtlasPhysicalProperties();
    private final AtlasJointMap jointMap;
    private final AtlasContactPointParameters contactPointParameters;
    private final AtlasSensorInformation sensorInformation;
    private final AtlasWalkingControllerParameters walkingControllerParameters;
    private final AtlasPushRecoveryControllerParameters pushRecoveryControllerParameters;
    private final AtlasStateEstimatorParameters stateEstimatorParameters;
    private final AtlasHighLevelControllerParameters highLevelControllerParameters;
    private AtlasSensorSuiteManager sensorSuiteManager;
    private Consumer<RobotDefinition> robotDefinitionMutator;
    private Consumer<RobotDefinition> robotDefinitionHandMutator;
    private RobotDefinition robotDefinition;
    private RobotDefinition robotDefinitionWithSDFCollision;
    private String simpleRobotName = "Atlas";
    private StepReachabilityData stepReachabilityData = null;
    private boolean useSDFCollisions = false;
    private boolean useHandMutatorCollisions = false;

    public AtlasRobotModel(AtlasRobotVersion atlasVersion) {
        this(atlasVersion, RobotTarget.SCS);
    }

    public AtlasRobotModel(AtlasRobotVersion atlasVersion, RobotTarget target) {
        this(atlasVersion, target, false);
    }

    public AtlasRobotModel(AtlasRobotVersion atlasVersion, RobotTarget target, boolean headless) {
        this(atlasVersion, target, headless, null, false, false);
    }

    public AtlasRobotModel(AtlasRobotVersion atlasVersion, RobotTarget target, boolean headless, boolean createAdditionalContactPoints) {
        this(atlasVersion, target, headless, null, createAdditionalContactPoints, false);
    }

    public AtlasRobotModel(AtlasRobotVersion atlasVersion, RobotTarget target, boolean headless, boolean createAdditionalContactPoints, boolean useShapeCollision) {
        this(atlasVersion, target, headless, null, createAdditionalContactPoints, useShapeCollision);
    }

    public AtlasRobotModel(AtlasRobotVersion atlasVersion, RobotTarget target, boolean headless, FootContactPoints<RobotSide> simulationContactPoints) {
        this(atlasVersion, target, headless, simulationContactPoints, false, false);
    }

    public AtlasRobotModel(AtlasRobotVersion atlasVersion, RobotTarget target, boolean headless, FootContactPoints<RobotSide> simulationContactPoints, boolean createAdditionalContactPointsn) {
        this(atlasVersion, target, headless, simulationContactPoints, createAdditionalContactPointsn, false);
    }

    public AtlasRobotModel(AtlasRobotVersion atlasVersion, RobotTarget target, boolean headless, FootContactPoints<RobotSide> simulationContactPoints, boolean createAdditionalContactPoints, boolean useShapeCollision) {
        this.selectedVersion = atlasVersion;
        this.jointMap = new AtlasJointMap(this.selectedVersion, this.atlasPhysicalProperties);
        boolean createFootContactPoints = true;
        this.contactPointParameters = new AtlasContactPointParameters(this.jointMap, atlasVersion, createFootContactPoints, simulationContactPoints, createAdditionalContactPoints);
        this.target = target;
        this.sensorInformation = new AtlasSensorInformation(atlasVersion, target);
        boolean runningOnRealRobot = target == RobotTarget.REAL_ROBOT;
        this.highLevelControllerParameters = new AtlasHighLevelControllerParameters(runningOnRealRobot, this.jointMap);
        this.walkingControllerParameters = new AtlasWalkingControllerParameters(target, this.jointMap, this.contactPointParameters);
        this.pushRecoveryControllerParameters = new AtlasPushRecoveryControllerParameters(target, this.jointMap, this.contactPointParameters);
        this.stateEstimatorParameters = new AtlasStateEstimatorParameters(this.jointMap, this.sensorInformation, runningOnRealRobot, this.getEstimatorDT());
    }

    public RobotDefinition createRobotDefinition() {
        return this.createRobotDefinition(Double.NaN);
    }

    public RobotDefinition createRobotDefinition(double transparency) {
        if (Double.isNaN(transparency) || transparency < 0.0) {
            return this.createRobotDefinition((MaterialDefinition)null);
        }
        return this.createRobotDefinition(ColorDefinitions.Orange().derive(0.0, 1.0, 1.0, 1.0 - transparency));
    }

    public RobotDefinition createRobotDefinition(ColorDefinition diffuseColor) {
        return this.createRobotDefinition(new MaterialDefinition(diffuseColor));
    }

    public RobotDefinition createRobotDefinition(MaterialDefinition materialDefinition) {
        return this.createRobotDefinition(materialDefinition, !this.useSDFCollisions);
    }

    public RobotDefinition createRobotDefinition(MaterialDefinition materialDefinition, boolean removeCollisions) {
        InputStream stream = this.selectedVersion.getSdfFileAsStream();
        if (stream == null) {
            LogTools.error((String)"Selected version {} could not be found: stream is null", (Object)((Object)this.selectedVersion));
        }
        RobotDefinition robotDefinition = RobotDefinitionTools.loadSDFModel((InputStream)stream, Arrays.asList(this.selectedVersion.getResourceDirectories()), (ClassLoader)this.getClass().getClassLoader(), (String)this.selectedVersion.getModelName(), (ContactPointDefinitionHolder)this.getContactPointParameters(), (JointNameMap)this.jointMap, (boolean)removeCollisions);
        if (materialDefinition != null) {
            RobotDefinitionTools.setRobotDefinitionMaterial((RobotDefinition)robotDefinition, (MaterialDefinition)materialDefinition);
        } else {
            RobotDefinitionTools.setDefaultMaterial((RobotDefinition)robotDefinition, (MaterialDefinition)new MaterialDefinition(ColorDefinitions.Black()));
        }
        this.getRobotDefinitionMutator().accept(robotDefinition);
        if (this.isUseHandMutatorCollisions()) {
            this.getRobotDefinitionHandMutator().accept(robotDefinition);
        }
        return robotDefinition;
    }

    public RobotDefinition getRobotDefinition() {
        if (this.robotDefinition == null) {
            this.robotDefinition = this.createRobotDefinition();
        }
        return this.robotDefinition;
    }

    public RobotDefinition getRobotDefinitionWithSDFCollision() {
        if (this.robotDefinitionWithSDFCollision == null) {
            this.robotDefinitionWithSDFCollision = this.createRobotDefinition(null, false);
        }
        return this.robotDefinitionWithSDFCollision;
    }

    public void disableOneDoFJointDamping() {
        this.setRobotDefinitionMutator(this.getRobotDefinitionMutator().andThen(def -> def.forEachOneDoFJointDefinition(joint -> joint.setDamping(0.0))));
    }

    public void setRobotDefinitionMutator(Consumer<RobotDefinition> robotDefinitionMutator) {
        if (this.robotDefinition != null) {
            throw new IllegalArgumentException("Cannot set customModel once generalizedRobotModel has been created.");
        }
        this.robotDefinitionMutator = robotDefinitionMutator;
    }

    public Consumer<RobotDefinition> getRobotDefinitionMutator() {
        if (this.robotDefinitionMutator == null) {
            this.robotDefinitionMutator = new AtlasRobotDefinitionMutator(this.getJointMap(), this.getSensorInformation());
        }
        return this.robotDefinitionMutator;
    }

    public Consumer<RobotDefinition> getRobotDefinitionHandMutator() {
        if (this.robotDefinitionHandMutator == null) {
            this.robotDefinitionHandMutator = new AtlasRobotDefinitionHandMutator();
        }
        return this.robotDefinitionHandMutator;
    }

    public HighLevelControllerParameters getHighLevelControllerParameters() {
        return this.highLevelControllerParameters;
    }

    public WalkingControllerParameters getWalkingControllerParameters() {
        return this.walkingControllerParameters;
    }

    public PushRecoveryControllerParameters getPushRecoveryControllerParameters() {
        return this.pushRecoveryControllerParameters;
    }

    public CoPTrajectoryParameters getCoPTrajectoryParameters() {
        return new AtlasCoPTrajectoryParameters();
    }

    public SplitFractionCalculatorParametersReadOnly getSplitFractionCalculatorParameters() {
        return new AtlasICPSplitFractionCalculatorParameters();
    }

    public StateEstimatorParameters getStateEstimatorParameters() {
        return this.stateEstimatorParameters;
    }

    public AtlasPhysicalProperties getPhysicalProperties() {
        return this.atlasPhysicalProperties;
    }

    public RobotTarget getTarget() {
        return this.target;
    }

    public AtlasJointMap getJointMap() {
        return this.jointMap;
    }

    public AtlasRobotVersion getAtlasVersion() {
        return this.selectedVersion;
    }

    public RobotVersion getRobotVersion() {
        return this.selectedVersion;
    }

    public String toString() {
        return this.selectedVersion.toString();
    }

    public RobotInitialSetup<HumanoidFloatingRootJointRobot> getDefaultRobotInitialSetup() {
        return new AtlasSimInitialSetup(this.getRobotDefinition(), this.getJointMap());
    }

    public AtlasContactPointParameters getContactPointParameters() {
        return this.contactPointParameters;
    }

    public void setJointDamping(FloatingRootJointRobot simulatedRobot) {
        AtlasDampingParameters.setDampingParameters(simulatedRobot, this.getJointMap());
    }

    public HandModel getHandModel(RobotSide side) {
        if (this.selectedVersion.hasRobotiqHands(side)) {
            return new RobotiqHandModel();
        }
        return null;
    }

    public AtlasSensorInformation getSensorInformation() {
        return this.sensorInformation;
    }

    public FullHumanoidRobotModel createFullRobotModel() {
        return this.createFullRobotModel(true);
    }

    public FullHumanoidRobotModel createFullRobotModel(boolean enforceUniqueReferenceFrames) {
        FullHumanoidRobotModelWrapper fullRobotModel = new FullHumanoidRobotModelWrapper(this.getRobotDefinition(), (HumanoidJointNameMap)this.getJointMap(), enforceUniqueReferenceFrames);
        return this.doArmJointRestriction((FullHumanoidRobotModel)fullRobotModel);
    }

    private FullHumanoidRobotModel doArmJointRestriction(FullHumanoidRobotModel fullRobotModel) {
        for (RobotSide robotSide : RobotSide.values()) {
            ArmJointName[] armJointNames;
            for (ArmJointName armJointName : armJointNames = new ArmJointName[]{ArmJointName.FIRST_WRIST_PITCH, ArmJointName.WRIST_ROLL, ArmJointName.SECOND_WRIST_PITCH}) {
                OneDoFJointBasics armJoint = fullRobotModel.getArmJoint(robotSide, armJointName);
                if (armJoint == null) continue;
                double lowerLimit = armJoint.getJointLimitLower();
                double upperLimit = armJoint.getJointLimitUpper();
                double range = upperLimit - lowerLimit;
                if (range > 2.0 * this.HARDSTOP_RESTRICTION_ANGLE) {
                    double safeLowerBound = lowerLimit + this.HARDSTOP_RESTRICTION_ANGLE;
                    double safeUpperBound = upperLimit - this.HARDSTOP_RESTRICTION_ANGLE;
                    armJoint.setJointLimitLower(safeLowerBound);
                    armJoint.setJointLimitUpper(safeUpperBound);
                    continue;
                }
                System.out.println(this.getClass().getName() + ", createFullRobotModel(): range not large enough to reduce for side=" + robotSide.getLowerCaseName() + " joint=" + armJointName.getCamelCaseNameForStartOfExpression());
            }
        }
        return fullRobotModel;
    }

    public HumanoidFloatingRootJointRobot createHumanoidFloatingRootJointRobot(boolean createCollisionMeshes, boolean enableJointDamping) {
        boolean enableTorqueVelocityLimits = false;
        HumanoidFloatingRootJointRobot humanoidFloatingRootJointRobot = new HumanoidFloatingRootJointRobot(this.getRobotDefinition(), (HumanoidJointNameMap)this.getJointMap(), enableJointDamping, enableTorqueVelocityLimits);
        return humanoidFloatingRootJointRobot;
    }

    public double getSimulateDT() {
        return 5.0E-4;
    }

    public double getEstimatorDT() {
        return ESTIMATOR_DT;
    }

    public double getControllerDT() {
        return 0.004;
    }

    public RobotROSClockCalculator getROSClockCalculator() {
        DRCROSPPSTimestampOffsetProvider timestampOffsetProvider = null;
        if (this.target == RobotTarget.REAL_ROBOT) {
            timestampOffsetProvider = AtlasPPSTimestampOffsetProvider.getInstance(this.sensorInformation);
        }
        if (timestampOffsetProvider == null) {
            timestampOffsetProvider = new DRCROSAlwaysZeroOffsetPPSTimestampOffsetProvider();
        }
        return new RobotROSClockCalculatorFromPPSOffset(timestampOffsetProvider);
    }

    public String getStepReachabilityResourceName() {
        return "us/ihmc/atlas/parameters/StepReachabilityMap.json";
    }

    public StepReachabilityData getStepReachabilityData() {
        if (this.stepReachabilityData == null) {
            this.stepReachabilityData = new StepReachabilityIOHelper().loadStepReachability((DRCRobotModel)this);
        }
        return this.stepReachabilityData;
    }

    public AtlasSensorSuiteManager getSensorSuiteManager() {
        return this.getSensorSuiteManager(null);
    }

    public AtlasSensorSuiteManager getSensorSuiteManager(ROS2NodeInterface ros2Node) {
        if (this.sensorSuiteManager == null) {
            this.sensorSuiteManager = new AtlasSensorSuiteManager(this.getSimpleRobotName(), (FullHumanoidRobotModelFactory)this, this.getCollisionBoxProvider(), this.getROSClockCalculator(), this.sensorInformation, this.getJointMap(), this.getPhysicalProperties(), this.target, ros2Node);
        }
        return this.sensorSuiteManager;
    }

    public UIParameters getUIParameters() {
        return new AtlasUIParameters(this.selectedVersion, this.atlasPhysicalProperties);
    }

    public SimulatedRobotiqHandsControlThread createSimulatedHandController(RealtimeROS2Node realtimeROS2Node) {
        if (this.selectedVersion == AtlasRobotVersion.ATLAS_UNPLUGGED_V5_DUAL_ROBOTIQ) {
            return new SimulatedRobotiqHandsControlThread(this.createFullRobotModel(), realtimeROS2Node, ROS2Tools.getControllerOutputTopic((String)this.getSimpleRobotName()), ROS2Tools.getControllerInputTopic((String)this.getSimpleRobotName()), RobotSide.values);
        }
        if (this.selectedVersion == AtlasRobotVersion.ATLAS_UNPLUGGED_V5_LEFT_NUB_RIGHT_ROBOTIQ) {
            return new SimulatedRobotiqHandsControlThread(this.createFullRobotModel(), realtimeROS2Node, ROS2Tools.getControllerOutputTopic((String)this.getSimpleRobotName()), ROS2Tools.getControllerInputTopic((String)this.getSimpleRobotName()), new RobotSide[]{RobotSide.RIGHT});
        }
        return null;
    }

    public SimulatedHandKinematicController createSimulatedHandKinematicController(FullHumanoidRobotModel fullHumanoidRobotModel, RealtimeROS2Node realtimeROS2Node, DoubleProvider controllerTime) {
        if (this.selectedVersion == AtlasRobotVersion.ATLAS_UNPLUGGED_V5_DUAL_ROBOTIQ) {
            return new SimulatedRobotiqHandKinematicController(this.getSimpleRobotName(), fullHumanoidRobotModel, realtimeROS2Node, controllerTime, RobotSide.values);
        }
        if (this.selectedVersion == AtlasRobotVersion.ATLAS_UNPLUGGED_V5_LEFT_NUB_RIGHT_ROBOTIQ) {
            return new SimulatedRobotiqHandKinematicController(this.getSimpleRobotName(), fullHumanoidRobotModel, realtimeROS2Node, controllerTime, new RobotSide[]{RobotSide.RIGHT});
        }
        return null;
    }

    public LogModelProvider getLogModelProvider() {
        return new DefaultLogModelProvider(SDFModelLoader.class, this.jointMap.getModelName(), this.selectedVersion.getSdfFileAsStream(), this.selectedVersion.getResourceDirectories());
    }

    public AStarBodyPathPlannerParametersBasics getAStarBodyPathPlannerParameters() {
        return new AStarBodyPathPlannerParameters();
    }

    public DataServerSettings getLogSettings() {
        switch (this.target) {
            case REAL_ROBOT: {
                return new DataServerSettings(true, "AtlasGUI");
            }
        }
        return new DataServerSettings(false, "SimulationGUI");
    }

    public String getSimpleRobotName() {
        return this.simpleRobotName;
    }

    public void setSimpleRobotName(String simpleRobotName) {
        this.simpleRobotName = simpleRobotName;
    }

    public CollisionBoxProvider getCollisionBoxProvider() {
        return new AtlasCollisionBoxProvider(this.getRobotDefinitionWithSDFCollision(), this.getJointMap());
    }

    public FootstepPlannerParametersBasics getFootstepPlannerParameters() {
        return new AtlasFootstepPlannerParameters();
    }

    public FootstepPlannerParametersBasics getFootstepPlannerParameters(String fileNameSuffix) {
        return new AtlasFootstepPlannerParameters(fileNameSuffix);
    }

    public LookAndStepBehaviorParameters getLookAndStepParameters() {
        return new AtlasLookAndStepParameters();
    }

    public VisibilityGraphsParametersBasics getVisibilityGraphsParameters() {
        return new AtlasVisibilityGraphParameters();
    }

    public SwingPlannerParametersBasics getSwingPlannerParameters() {
        return new AtlasSwingPlannerParameters();
    }

    public SwingPlannerParametersBasics getSwingPlannerParameters(String fileNameSuffix) {
        return new AtlasSwingPlannerParameters(fileNameSuffix);
    }

    public DRCOutputProcessor getCustomSimulationOutputProcessor(HumanoidFloatingRootJointRobot humanoidFloatingRootJointRobot) {
        return new DRCSimulationOutputWriterForControllerThread((FloatingRootJointRobot)humanoidFloatingRootJointRobot);
    }

    public JointDesiredOutputWriter getCustomSimulationOutputWriter(HumanoidFloatingRootJointRobot humanoidFloatingRootJointRobot, HumanoidRobotContextData contextData) {
        return null;
    }

    public static String getParameterResourceName() {
        return "/us/ihmc/atlas/parameters/controller.xml";
    }

    public String getParameterFileName() {
        return AtlasRobotModel.getParameterResourceName();
    }

    public InputStream getParameterOverwrites() {
        if (this.target == RobotTarget.REAL_ROBOT) {
            return this.getClass().getResourceAsStream("/us/ihmc/atlas/parameters/real_robot.xml");
        }
        return null;
    }

    public InputStream getWholeBodyControllerParametersFile() {
        return this.getClass().getResourceAsStream(AtlasRobotModel.getParameterResourceName());
    }

    public RobotCollisionModel getHumanoidRobotKinematicsCollisionModel() {
        return new AtlasKinematicsCollisionModel(this.jointMap);
    }

    public RobotCollisionModel getSimulationRobotCollisionModel(CollidableHelper helper, String robotCollisionMask, String ... environmentCollisionMasks) {
        AtlasSimulationCollisionModel collisionModel = new AtlasSimulationCollisionModel(this.jointMap, this.selectedVersion);
        collisionModel.setCollidableHelper(helper, robotCollisionMask, environmentCollisionMasks);
        return collisionModel;
    }

    public DiagnosticParameters getDiagnoticParameters() {
        return new AtlasDiagnosticParameters(this.getJointMap(), this.getSensorInformation(), this.target == RobotTarget.REAL_ROBOT);
    }

    public RobotLowLevelMessenger newRobotLowLevelMessenger(ROS2NodeInterface ros2Node) {
        return new AtlasDirectRobotInterface(ros2Node, this);
    }

    public void setUseSDFCollisions(boolean useSDFCollisions) {
        if (this.robotDefinition != null) {
            throw new RuntimeException("Must set before RobotDefinition is created!");
        }
        this.useSDFCollisions = useSDFCollisions;
    }

    public boolean isUseHandMutatorCollisions() {
        return this.useHandMutatorCollisions;
    }

    public void setUseHandMutatorCollisions(boolean useHandMutatorCollisions) {
        this.useHandMutatorCollisions = useHandMutatorCollisions;
    }
}

