/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas;

import com.martiansoftware.jsap.JSAPException;
import ihmc_msgs.HandDesiredConfigurationRosMessage;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ros.internal.message.Message;
import org.ros.message.MessageFactory;
import org.ros.node.NodeConfiguration;
import us.ihmc.atlas.AtlasRobotModel;
import us.ihmc.atlas.AtlasRobotModelFactory;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.avatar.DRCStartingLocation;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.avatar.environments.DRCFinalsEnvironment;
import us.ihmc.avatar.ros.ROSAPISimulator;
import us.ihmc.avatar.ros.subscriber.IHMCMsgToPacketSubscriber;
import us.ihmc.avatar.simulationStarter.DRCSCStartingLocations;
import us.ihmc.communication.packetCommunicator.PacketCommunicator;
import us.ihmc.communication.packets.PacketDestination;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.simulationConstructionSetTools.util.environments.CommonAvatarEnvironmentInterface;
import us.ihmc.utilities.ros.publisher.RosTopicPublisher;
import us.ihmc.utilities.ros.subscriber.RosTopicSubscriberInterface;

public class AtlasFinalsROSAPISimulator
extends ROSAPISimulator {
    private static final String ROBOT_NAME = "atlas";
    private static final String DEFAULT_ROBOT_MODEL = "ATLAS_UNPLUGGED_V5_NO_HANDS";
    private static final boolean CREATE_DOOR = true;
    private static final boolean CREATE_DRILL = true;
    private static final boolean CREATE_VALVE = true;
    private static final boolean CREATE_WALKING = true;
    private static final boolean CREATE_STAIRS = true;
    private final AtlasRobotVersion robotVersion;

    public AtlasFinalsROSAPISimulator(AtlasRobotModel robotModel, DRCStartingLocation startingLocation, String nameSpace, String tfPrefix, boolean runAutomaticDiagnosticRoutine, boolean disableViz) throws IOException {
        super((DRCRobotModel)robotModel, startingLocation, nameSpace, tfPrefix, runAutomaticDiagnosticRoutine, disableViz);
        this.robotVersion = robotModel.getAtlasVersion();
    }

    protected CommonAvatarEnvironmentInterface createEnvironment() {
        return new DRCFinalsEnvironment(true, true, true, true, true);
    }

    protected List<Map.Entry<String, RosTopicSubscriberInterface<? extends Message>>> createCustomSubscribers(String nameSpace, PacketCommunicator communicator) {
        ArrayList<Map.Entry<String, RosTopicSubscriberInterface<? extends Message>>> subscribers = new ArrayList<Map.Entry<String, RosTopicSubscriberInterface<? extends Message>>>();
        MessageFactory messageFactory = NodeConfiguration.newPrivate().getTopicMessageFactory();
        if (this.robotVersion.getHandModel(RobotSide.RIGHT).isHandSimulated()) {
            HandDesiredConfigurationRosMessage message = (HandDesiredConfigurationRosMessage)messageFactory.newFromType("ihmc_msgs/FingerStateRosMessage");
            IHMCMsgToPacketSubscriber sub = IHMCMsgToPacketSubscriber.createIHMCMsgToPacketSubscriber((Message)message, (PacketCommunicator)communicator, (int)PacketDestination.CONTROLLER.ordinal());
            AbstractMap.SimpleEntry<CallSite, IHMCMsgToPacketSubscriber> pair = new AbstractMap.SimpleEntry<CallSite, IHMCMsgToPacketSubscriber>((CallSite)((Object)(nameSpace + "/control/finger_state")), sub);
            subscribers.add(pair);
        }
        return subscribers;
    }

    protected List<Map.Entry<String, RosTopicPublisher<? extends Message>>> createCustomPublishers(String nameSpace, PacketCommunicator communicator) {
        return null;
    }

    public static void main(String[] args) throws JSAPException, IOException {
        DRCSCStartingLocations startingLocation;
        AtlasRobotModel robotModel;
        ROSAPISimulator.Options opt = AtlasFinalsROSAPISimulator.parseArguments((String[])args);
        try {
            robotModel = opt.robotModel.equals("DEFAULT") ? AtlasRobotModelFactory.createDRCRobotModel(DEFAULT_ROBOT_MODEL, RobotTarget.SCS, false) : AtlasRobotModelFactory.createDRCRobotModel(opt.robotModel, RobotTarget.SCS, false);
        }
        catch (IllegalArgumentException e) {
            System.err.println("Incorrect robot model " + opt.robotModel);
            System.out.println("Robot models: " + AtlasRobotModelFactory.robotModelsToString());
            return;
        }
        try {
            startingLocation = DRCSCStartingLocations.valueOf((String)opt.startingLocation);
        }
        catch (IllegalArgumentException e) {
            System.err.println("Incorrect starting location " + opt.startingLocation);
            System.out.println("Starting locations: " + DRCSCStartingLocations.optionsToString());
            return;
        }
        String nameSpace = opt.nameSpace + "/atlas";
        new AtlasFinalsROSAPISimulator(robotModel, (DRCStartingLocation)startingLocation, nameSpace, opt.tfPrefix, opt.runAutomaticDiagnosticRoutine, opt.disableViz);
    }
}

