/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.processManagement;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.StringParser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.EmptyBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import us.ihmc.atlas.AtlasRobotModelFactory;
import us.ihmc.communication.net.ConnectionStateListener;
import us.ihmc.communication.net.tcpServer.DisconnectedException;
import us.ihmc.communication.net.tcpServer.ReconnectingTCPClient;
import us.ihmc.communication.util.NetworkPorts;
import us.ihmc.humanoidBehaviors.IHMCHumanoidBehaviorManager;
import us.ihmc.tools.processManagement.ExitListener;
import us.ihmc.tools.processManagement.JavaProcessSpawner;
import us.ihmc.tools.processManagement.UnsignedByteTools;

public class DRCEnterpriseCloudDispatcherFrontend
implements Runnable {
    private static final String BLUE_TEAM_ACTION_COMMAND = "blue";
    private static final String RED_TEAM_ACTION_COMMAND = "red";
    private static final boolean ENABLE_CONSOLE_OUTPUT = false;
    private ReconnectingTCPClient netProcClient;
    private final byte[] netProcBuffer;
    private ReconnectingTCPClient controllerClient;
    private final byte[] controllerBuffer;
    private static String netProcMachineIpAddress = "10.6.12.44";
    private static String controllerMachineIpAddress = "192.168.130.112";
    private JFrame frame;
    private JPanel netProcPanel;
    private JPanel controllerPanel;
    private JPanel selectControllerPanel;
    private JButton netProcStartButton;
    private JButton netProcStopButton;
    private JButton netProcRestartButton;
    private final JLabel netProcRunningStatusLabel = new JLabel("<html><body>Running: <span style=\"color:red;font-style:italic;\">Not Running</span></body></html>", 0);
    private final JLabel netProcConnectedStatusLabel = new JLabel("<html><body>Connected: <span style=\"color:red;font-style:italic;\">Disconnected</span></body></html>", 0);
    private JButton controllerStartButton;
    private JButton controllerStopButton;
    private final JLabel controllerRunningStatusLabel = new JLabel("<html><body>Running: <span style=\"color:red;font-style:italic;\">Not Running</span></body></html>", 0);
    private final JLabel controllerConnectedStatusLabel = new JLabel("<html><body>Connected: <span style=\"color:red;font-style:italic;\">Disconnected</span></body></html>", 0);
    private ButtonGroup selectControllerRadioButtonGroup;
    private ButtonGroup selectRobotModelRadioButtonGroup;
    private final JTextArea netProcConsole;
    private final JTextArea controllerConsole;
    private JScrollPane robotModelScrollPane;
    private final JavaProcessSpawner localSpawner = new JavaProcessSpawner(true, true);
    private JButton spawnUIButton;
    private JButton spawnBehaviorModuleButton;
    private JPanel handIPPanel;
    private JTextField leftHandField;
    private JTextField rightHandField;

    public DRCEnterpriseCloudDispatcherFrontend() {
        this.setupNetProcSocket();
        this.setupControllerSocket();
        this.netProcBuffer = this.netProcClient.getBuffer();
        this.controllerBuffer = this.controllerClient.getBuffer();
        this.netProcConsole = new JTextArea();
        this.controllerConsole = new JTextArea();
    }

    private void requestControllerStream() {
        try {
            this.controllerClient.write(new byte[]{UnsignedByteTools.fromInt((int)34)});
        }
        catch (DisconnectedException e) {
            this.controllerClient.reset();
        }
    }

    private void requestNetProcStream() {
        try {
            this.netProcClient.write(new byte[]{UnsignedByteTools.fromInt((int)34)});
        }
        catch (DisconnectedException e) {
            this.netProcClient.reset();
        }
    }

    private void setupNetProcSocket() {
        this.netProcClient = new ReconnectingTCPClient(netProcMachineIpAddress, NetworkPorts.NETWORK_PROCESSOR_CLOUD_DISPATCHER_BACKEND_TCP_PORT.getPort());
        this.netProcClient.attachStateListener(new ConnectionStateListener(){

            public void connected() {
                DRCEnterpriseCloudDispatcherFrontend.this.netProcConnectedStatusLabel.setText("<html><body>Connected: <span style=\"color:green;font-style:italic;\">Connected</span></body></html>");
                DRCEnterpriseCloudDispatcherFrontend.this.netProcNotRunningButtonConfiguration();
                DRCEnterpriseCloudDispatcherFrontend.this.repaintFrame();
            }

            public void disconnected() {
                DRCEnterpriseCloudDispatcherFrontend.this.netProcConnectedStatusLabel.setText("<html><body>Connected: <span style=\"color:red;font-style:italic;\">Disconnected</span></body></html>");
                DRCEnterpriseCloudDispatcherFrontend.this.netProcRunningStatusLabel.setText("<html><body>Running: <span style=\"color:red;font-style:italic;\">Not Running</span></body></html>");
                DRCEnterpriseCloudDispatcherFrontend.this.netProcDisableAll();
                DRCEnterpriseCloudDispatcherFrontend.this.repaintFrame();
            }
        });
    }

    private void setupControllerSocket() {
        this.controllerClient = new ReconnectingTCPClient(controllerMachineIpAddress, NetworkPorts.CONTROLLER_CLOUD_DISPATCHER_BACKEND_TCP_PORT.getPort());
        this.controllerClient.attachStateListener(new ConnectionStateListener(){

            public void connected() {
                DRCEnterpriseCloudDispatcherFrontend.this.controllerConnectedStatusLabel.setText("<html><body>Connected: <span style=\"color:green;font-style:italic;\">Connected</span></body></html>");
                DRCEnterpriseCloudDispatcherFrontend.this.controllerNotRunningButtonConfiguration();
                DRCEnterpriseCloudDispatcherFrontend.this.repaintFrame();
            }

            public void disconnected() {
                DRCEnterpriseCloudDispatcherFrontend.this.controllerConnectedStatusLabel.setText("<html><body>Connected: <span style=\"color:red;font-style:italic;\">Disconnected</span></body></html>");
                DRCEnterpriseCloudDispatcherFrontend.this.controllerRunningStatusLabel.setText("<html><body>Running: <span style=\"color:red;font-style:italic;\">Not Running</span></body></html>");
                DRCEnterpriseCloudDispatcherFrontend.this.controllerDisableAll();
                DRCEnterpriseCloudDispatcherFrontend.this.repaintFrame();
            }
        });
    }

    private void repaintFrame() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DRCEnterpriseCloudDispatcherFrontend.this.frame.validate();
                DRCEnterpriseCloudDispatcherFrontend.this.frame.repaint();
            }
        });
    }

    @Override
    public void run() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                DRCEnterpriseCloudDispatcherFrontend.this.netProcClient.connect();
                DRCEnterpriseCloudDispatcherFrontend.this.netProcNotRunningButtonConfiguration();
            }
        }).start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                DRCEnterpriseCloudDispatcherFrontend.this.controllerClient.connect();
                DRCEnterpriseCloudDispatcherFrontend.this.controllerNotRunningButtonConfiguration();
            }
        }).start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    DRCEnterpriseCloudDispatcherFrontend.this.processNetProcSocket();
                }
            }
        }).start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    DRCEnterpriseCloudDispatcherFrontend.this.processControllerSocket();
                }
            }
        }).start();
    }

    private void processNetProcSocket() {
        try {
            this.netProcClient.read(1);
            switch (UnsignedByteTools.toInt((byte)this.netProcBuffer[0])) {
                case 0: {
                    this.netProcRunningButtonConfiguration();
                    this.netProcRunningStatusLabel.setText("<html><body>Network Processor Status: <span style=\"color:green;font-style:italic;\">Running</span></body></html>");
                    this.repaintFrame();
                    break;
                }
                case 17: {
                    this.netProcNotRunningButtonConfiguration();
                    this.netProcRunningStatusLabel.setText("<html><body>Network Processor Status: <span style=\"color:red;font-style:italic;\">Not Running</span></body></html>");
                    this.repaintFrame();
                    break;
                }
                case 34: {
                    this.startReceivingNetProcConsoleText();
                    break;
                }
                default: {
                    System.err.println("Invalid status: " + Integer.toHexString(UnsignedByteTools.toInt((byte)this.netProcBuffer[0])));
                    break;
                }
            }
        }
        catch (DisconnectedException e) {
            this.netProcClient.reset();
        }
        this.netProcClient.reset();
    }

    private void processControllerSocket() {
        try {
            this.controllerClient.read(1);
            switch (UnsignedByteTools.toInt((byte)this.controllerBuffer[0])) {
                case 0: {
                    this.controllerRunningButtonConfiguration();
                    this.controllerRunningStatusLabel.setText("<html><body>Controller Status: <span style=\"color:green;font-style:italic;\">Running</span></body></html>");
                    this.repaintFrame();
                    break;
                }
                case 16: {
                    this.controllerDisableAll();
                    this.controllerRunningStatusLabel.setText("<html><body>Controller Status: <span style=\"color:gray;font-style:italic;\">Restarting</span></body></html>");
                    this.repaintFrame();
                    break;
                }
                case 17: {
                    this.controllerNotRunningButtonConfiguration();
                    this.controllerRunningStatusLabel.setText("<html><body>Controller Status: <span style=\"color:red;font-style:italic;\">Not Running</span></body></html>");
                    this.repaintFrame();
                    break;
                }
                case 34: {
                    this.startReceivingControllerConsoleText();
                    break;
                }
                default: {
                    System.err.println("Invalid status: " + Integer.toHexString(UnsignedByteTools.toInt((byte)this.controllerBuffer[0])));
                    break;
                }
            }
        }
        catch (DisconnectedException e) {
            this.controllerClient.reset();
        }
        this.controllerClient.reset();
    }

    private void netProcDisableAll() {
        this.netProcStartButton.setEnabled(false);
        this.netProcStopButton.setEnabled(false);
        this.netProcRestartButton.setEnabled(false);
    }

    private void netProcNotRunningButtonConfiguration() {
        this.netProcStartButton.setEnabled(true);
        this.netProcStopButton.setEnabled(false);
        this.netProcRestartButton.setEnabled(false);
    }

    private void netProcRunningButtonConfiguration() {
        this.netProcStartButton.setEnabled(false);
        this.netProcStopButton.setEnabled(true);
        this.netProcRestartButton.setEnabled(true);
    }

    private void controllerDisableAll() {
        this.controllerStartButton.setEnabled(false);
        this.controllerStopButton.setEnabled(false);
    }

    private void controllerNotRunningButtonConfiguration() {
        this.controllerStartButton.setEnabled(true);
        this.controllerStopButton.setEnabled(false);
    }

    private void controllerRunningButtonConfiguration() {
        this.controllerStartButton.setEnabled(false);
        this.controllerStopButton.setEnabled(true);
    }

    private void initAndStartSwingGui() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e1) {
            e1.printStackTrace();
        }
        this.frame = new JFrame("DRC Networking Dispatcher");
        this.frame.setSize(1310, 345);
        this.frame.setDefaultCloseOperation(3);
        this.frame.setLocationRelativeTo(null);
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        JPanel controlsPanel = new JPanel(new GridLayout(1, 5));
        ((GridLayout)controlsPanel.getLayout()).setHgap(5);
        this.setupNetProcPanel();
        this.setupControllerPanel();
        this.setupSelectControllerPanel();
        this.setupSelectRobotModelPanel();
        this.setupHandIPPanel();
        controlsPanel.add(this.controllerPanel);
        controlsPanel.add(this.netProcPanel);
        controlsPanel.add(this.selectControllerPanel);
        controlsPanel.add(this.robotModelScrollPane);
        controlsPanel.add(this.handIPPanel);
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(10, 10, 5, 10);
        c.weighty = 0.9;
        c.fill = 2;
        c.ipadx = 180;
        c.ipady = 200;
        mainPanel.add((Component)controlsPanel, c);
        JPanel panel = new JPanel();
        this.spawnUIButton = new JButton("Start Operator UI");
        this.spawnUIButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DRCEnterpriseCloudDispatcherFrontend.this.verifyEverythingIsConfigured()) {
                    JOptionPane.showMessageDialog(DRCEnterpriseCloudDispatcherFrontend.this.frame, "Please complete the Controller/Robot Model configuration!", "Bad Deploy Configuration", 0);
                } else {
                    String[] javaArgs = new String[]{"-Xms4096m", "-Xmx4096m"};
                    String[] programArgs = new String[]{"-m", DRCEnterpriseCloudDispatcherFrontend.this.selectRobotModelRadioButtonGroup.getSelection().getActionCommand(), "--realRobot"};
                    System.err.println("NOT SPAWNING UI");
                    DRCEnterpriseCloudDispatcherFrontend.this.spawnUIButton.setEnabled(false);
                }
            }
        });
        panel.add(this.spawnUIButton);
        this.spawnBehaviorModuleButton = new JButton("[DEBUG]: Spawn Local Behavior Module");
        this.spawnBehaviorModuleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DRCEnterpriseCloudDispatcherFrontend.this.localSpawner.spawn(IHMCHumanoidBehaviorManager.class, new String[0], new String[0], new ExitListener(){

                    public void exited(int statusValue) {
                        DRCEnterpriseCloudDispatcherFrontend.this.spawnBehaviorModuleButton.setEnabled(true);
                    }
                });
                DRCEnterpriseCloudDispatcherFrontend.this.spawnBehaviorModuleButton.setEnabled(false);
            }
        });
        panel.add(this.spawnBehaviorModuleButton);
        ++c.gridy;
        mainPanel.add((Component)panel, c);
        this.frame.getContentPane().add(mainPanel);
        this.frame.setResizable(false);
        this.frame.setVisible(true);
    }

    private boolean isStringInteger(String str) {
        try {
            Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private void setupHandIPPanel() {
        this.handIPPanel = new JPanel(new BorderLayout());
        this.handIPPanel.setBorder(BorderFactory.createEtchedBorder());
        this.handIPPanel.add((Component)new JLabel("<html><body><h2>Hand Configuration</h2></body></html>", 0), "North");
        JLabel leftHandLabel = new JLabel("Left Hand Number:");
        JLabel rightHandLabel = new JLabel("Right Hand Number:");
        this.leftHandField = new JTextField(2);
        this.leftHandField.setDocument(new PlainDocument(){

            @Override
            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                if (this.getLength() + str.length() <= 2 && DRCEnterpriseCloudDispatcherFrontend.this.isStringInteger(str)) {
                    super.insertString(offs, str, a);
                }
            }
        });
        this.leftHandField.setText("40");
        this.rightHandField = new JTextField(2);
        this.rightHandField.setDocument(new PlainDocument(){

            @Override
            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                if (this.getLength() + str.length() <= 2 && DRCEnterpriseCloudDispatcherFrontend.this.isStringInteger(str)) {
                    super.insertString(offs, str, a);
                }
            }
        });
        this.rightHandField.setText("35");
        JPanel leftPanel = new JPanel();
        leftPanel.setBorder(new EmptyBorder(40, 0, 0, 0));
        leftPanel.add(leftHandLabel);
        leftPanel.add(this.leftHandField);
        this.handIPPanel.add((Component)leftPanel, "Center");
        JPanel rightPanel = new JPanel();
        rightPanel.setBorder(new EmptyBorder(0, 0, 80, 0));
        rightPanel.add(rightHandLabel);
        rightPanel.add(this.rightHandField);
        this.handIPPanel.add((Component)rightPanel, "South");
    }

    private void setupNetProcPanel() {
        this.netProcPanel = new JPanel(new GridLayout(6, 1));
        this.netProcPanel.setBorder(BorderFactory.createEtchedBorder());
        this.netProcStartButton = new JButton("Start Network Processor");
        this.netProcStartButton.setEnabled(false);
        this.netProcStartButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (DRCEnterpriseCloudDispatcherFrontend.this.verifyEverythingIsConfigured()) {
                        JOptionPane.showMessageDialog(DRCEnterpriseCloudDispatcherFrontend.this.frame, "Please complete the Controller/Robot Model configuration!", "Bad Deploy Configuration", 0);
                    } else {
                        String modelAsString = DRCEnterpriseCloudDispatcherFrontend.this.selectRobotModelRadioButtonGroup.getSelection().getActionCommand();
                        int leftHandIP = Integer.parseInt(DRCEnterpriseCloudDispatcherFrontend.this.leftHandField.getText());
                        int rightHandIP = Integer.parseInt(DRCEnterpriseCloudDispatcherFrontend.this.rightHandField.getText());
                        DRCEnterpriseCloudDispatcherFrontend.this.netProcClient.write(new byte[]{UnsignedByteTools.fromInt((int)0), UnsignedByteTools.fromInt((int)AtlasRobotModelFactory.getOrdinalOfModel(modelAsString)), UnsignedByteTools.fromInt((int)leftHandIP), UnsignedByteTools.fromInt((int)rightHandIP)});
                    }
                }
                catch (DisconnectedException e) {
                    DRCEnterpriseCloudDispatcherFrontend.this.netProcClient.reset();
                }
            }
        });
        this.netProcStopButton = new JButton("Stop Network Processor");
        this.netProcStopButton.setEnabled(false);
        this.netProcStopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DRCEnterpriseCloudDispatcherFrontend.this.netProcClient.write(new byte[]{UnsignedByteTools.fromInt((int)16)});
                }
                catch (DisconnectedException e) {
                    DRCEnterpriseCloudDispatcherFrontend.this.netProcClient.reset();
                }
            }
        });
        this.netProcRestartButton = new JButton("Restart Network Processor");
        this.netProcRestartButton.setEnabled(false);
        this.netProcRestartButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DRCEnterpriseCloudDispatcherFrontend.this.netProcClient.write(new byte[]{UnsignedByteTools.fromInt((int)17)});
                }
                catch (DisconnectedException e) {
                    DRCEnterpriseCloudDispatcherFrontend.this.netProcClient.reset();
                }
            }
        });
        this.netProcPanel.add(new JLabel("<html><body><h2>Network Processor</h2></body></html>", 0));
        this.netProcPanel.add(this.netProcConnectedStatusLabel);
        this.netProcPanel.add(this.netProcRunningStatusLabel);
        this.netProcPanel.add(this.netProcStartButton);
        this.netProcPanel.add(this.netProcStopButton);
        this.netProcPanel.add(this.netProcRestartButton);
    }

    private void setupControllerPanel() {
        this.controllerPanel = new JPanel(new GridLayout(6, 1));
        this.controllerPanel.setBorder(BorderFactory.createEtchedBorder());
        this.controllerStartButton = new JButton("Start Controller");
        this.controllerStartButton.setEnabled(false);
        this.controllerStartButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (DRCEnterpriseCloudDispatcherFrontend.this.verifyEverythingIsConfigured()) {
                        JOptionPane.showMessageDialog(DRCEnterpriseCloudDispatcherFrontend.this.frame, "Please complete the Controller/Robot Model configuration!", "Bad Deploy Configuration", 0);
                    } else if (DRCEnterpriseCloudDispatcherFrontend.this.selectControllerRadioButtonGroup.getSelection().getActionCommand().contains(DRCEnterpriseCloudDispatcherFrontend.BLUE_TEAM_ACTION_COMMAND)) {
                        String modelAsString = DRCEnterpriseCloudDispatcherFrontend.this.selectRobotModelRadioButtonGroup.getSelection().getActionCommand();
                        DRCEnterpriseCloudDispatcherFrontend.this.controllerClient.write(new byte[]{UnsignedByteTools.fromInt((int)0), UnsignedByteTools.fromInt((int)AtlasRobotModelFactory.getOrdinalOfModel(modelAsString))});
                    } else if (DRCEnterpriseCloudDispatcherFrontend.this.selectControllerRadioButtonGroup.getSelection().getActionCommand().contains(DRCEnterpriseCloudDispatcherFrontend.RED_TEAM_ACTION_COMMAND)) {
                        String modelAsString = DRCEnterpriseCloudDispatcherFrontend.this.selectRobotModelRadioButtonGroup.getSelection().getActionCommand();
                        DRCEnterpriseCloudDispatcherFrontend.this.controllerClient.write(new byte[]{UnsignedByteTools.fromInt((int)1), UnsignedByteTools.fromInt((int)AtlasRobotModelFactory.getOrdinalOfModel(modelAsString))});
                    }
                }
                catch (DisconnectedException e) {
                    DRCEnterpriseCloudDispatcherFrontend.this.controllerClient.reset();
                }
            }
        });
        this.controllerStopButton = new JButton("Stop Controller");
        this.controllerStopButton.setEnabled(false);
        this.controllerStopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DRCEnterpriseCloudDispatcherFrontend.this.controllerClient.write(new byte[]{UnsignedByteTools.fromInt((int)16)});
                }
                catch (DisconnectedException e) {
                    DRCEnterpriseCloudDispatcherFrontend.this.controllerClient.reset();
                }
            }
        });
        this.controllerPanel.add(new JLabel("<html><body><h2>Controller</h2></body></html>", 0));
        this.controllerPanel.add(this.controllerConnectedStatusLabel);
        this.controllerPanel.add(this.controllerRunningStatusLabel);
        this.controllerPanel.add(this.controllerStartButton);
        this.controllerPanel.add(this.controllerStopButton);
    }

    private boolean verifyEverythingIsConfigured() {
        return this.selectControllerRadioButtonGroup.getSelection() == null || this.selectRobotModelRadioButtonGroup.getSelection() == null || this.leftHandField.getText().isEmpty() || this.rightHandField.getText().isEmpty();
    }

    private void setupSelectRobotModelPanel() {
        JPanel selectRobotModelPanel = new JPanel(new GridLayout(AtlasRobotModelFactory.getAvailableRobotModels().length + 1, 1));
        this.robotModelScrollPane = new JScrollPane(selectRobotModelPanel);
        this.selectRobotModelRadioButtonGroup = new ButtonGroup();
        selectRobotModelPanel.add(new JLabel("<html><body style=\"margin-left: 32px;\"><h2>Select Robot Model</h2></body></html>"));
        for (String st : AtlasRobotModelFactory.getAvailableRobotModels()) {
            JRadioButton nextButton = new JRadioButton(st);
            nextButton.setActionCommand(st);
            nextButton.setHorizontalAlignment(10);
            nextButton.setHorizontalTextPosition(11);
            this.selectRobotModelRadioButtonGroup.add(nextButton);
            selectRobotModelPanel.add(nextButton);
        }
    }

    private void setupSelectControllerPanel() {
        this.selectControllerPanel = new JPanel(new GridLayout(4, 1));
        this.selectControllerPanel.setBorder(BorderFactory.createEtchedBorder());
        this.selectControllerRadioButtonGroup = new ButtonGroup();
        JRadioButton atlasBDIControllerRadioButton = new JRadioButton("Atlas BDI Controller");
        atlasBDIControllerRadioButton.setActionCommand(RED_TEAM_ACTION_COMMAND);
        atlasBDIControllerRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 35, 0, -35));
        atlasBDIControllerRadioButton.setHorizontalAlignment(10);
        atlasBDIControllerRadioButton.setHorizontalTextPosition(11);
        JRadioButton atlasControllerFactoryRadioButton = new JRadioButton("Atlas Controller Factory");
        atlasControllerFactoryRadioButton.setActionCommand(BLUE_TEAM_ACTION_COMMAND);
        atlasControllerFactoryRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 35, 0, -35));
        atlasControllerFactoryRadioButton.setHorizontalAlignment(10);
        atlasControllerFactoryRadioButton.setHorizontalTextPosition(11);
        this.selectControllerRadioButtonGroup.add(atlasBDIControllerRadioButton);
        this.selectControllerRadioButtonGroup.add(atlasControllerFactoryRadioButton);
        this.selectControllerPanel.add(new JLabel("<html><body><h2>Select Controller</h2></body></html>", 0));
        this.selectControllerPanel.add(atlasBDIControllerRadioButton);
        this.selectControllerPanel.add(atlasControllerFactoryRadioButton);
    }

    private void startReceivingControllerConsoleText() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Socket clientSocket = null;
                try {
                    clientSocket = new Socket(controllerMachineIpAddress, NetworkPorts.CONTROLLER_CLOUD_DISPATCHER_BACKEND_CONSOLE_TCP_PORT.getPort());
                    clientSocket.setTcpNoDelay(true);
                    DataInputStream inputStream = new DataInputStream(clientSocket.getInputStream());
                    BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                    while (true) {
                        String line;
                        if (!reader.ready() || (line = reader.readLine()) == null) {
                            continue;
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DRCEnterpriseCloudDispatcherFrontend.this.controllerConsole.append(line);
                            }
                        });
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        clientSocket.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    return;
                }
            }
        }).start();
    }

    private void startReceivingNetProcConsoleText() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Socket clientSocket = null;
                try {
                    clientSocket = new Socket(netProcMachineIpAddress, NetworkPorts.NETWORK_PROCESSOR_CLOUD_DISPATCHER_BACKEND_CONSOLE_TCP_PORT.getPort());
                    clientSocket.setTcpNoDelay(true);
                    DataInputStream inputStream = new DataInputStream(clientSocket.getInputStream());
                    BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                    while (true) {
                        String line;
                        if (!reader.ready() || (line = reader.readLine()) == null) {
                            continue;
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DRCEnterpriseCloudDispatcherFrontend.this.netProcConsole.append(line);
                            }
                        });
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        clientSocket.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    return;
                }
            }
        }).start();
    }

    public static void main(String[] args) throws JSAPException {
        JSAP jsap = new JSAP();
        FlaggedOption netProcIPFlag = new FlaggedOption("net-proc-ip").setLongFlag("net-proc-ip").setShortFlag('n').setRequired(false).setStringParser((StringParser)JSAP.STRING_PARSER);
        FlaggedOption controllerIPFlag = new FlaggedOption("scs-ip").setLongFlag("scs-ip").setShortFlag('s').setRequired(false).setStringParser((StringParser)JSAP.STRING_PARSER);
        jsap.registerParameter((Parameter)netProcIPFlag);
        jsap.registerParameter((Parameter)controllerIPFlag);
        JSAPResult config = jsap.parse(args);
        if (config.success()) {
            if (config.getString(netProcIPFlag.getID()) != null) {
                netProcMachineIpAddress = config.getString(netProcIPFlag.getID());
            }
            if (config.getString(controllerIPFlag.getID()) != null) {
                controllerMachineIpAddress = config.getString(controllerIPFlag.getID());
            }
        }
        final DRCEnterpriseCloudDispatcherFrontend frontend = new DRCEnterpriseCloudDispatcherFrontend();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                frontend.initAndStartSwingGui();
                new Thread(frontend).start();
            }
        });
    }
}

