/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.parameters;

import java.util.HashMap;
import us.ihmc.atlas.AtlasJointMap;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.WholeBodySetpointParameters;
import us.ihmc.robotics.partNames.ArmJointName;
import us.ihmc.robotics.partNames.LegJointName;
import us.ihmc.robotics.partNames.NeckJointName;
import us.ihmc.robotics.partNames.SpineJointName;
import us.ihmc.robotics.robotSide.RobotSide;

public class AtlasStandPrepSetpoints
implements WholeBodySetpointParameters {
    private final HashMap<String, Double> setPoints = new HashMap();
    private final AtlasJointMap jointMap;

    public AtlasStandPrepSetpoints(AtlasJointMap jointMap) {
        this.jointMap = jointMap;
        this.useDefaultAngles();
    }

    private void useDefaultAngles() {
        this.setSetpoint(this.jointMap.getNeckJointName(NeckJointName.PROXIMAL_NECK_PITCH), 0.0);
        this.setSetpoint(this.jointMap.getNeckJointName(NeckJointName.DISTAL_NECK_YAW), 0.0);
        this.setSetpoint(this.jointMap.getNeckJointName(NeckJointName.DISTAL_NECK_PITCH), 0.0);
        this.setSetpoint(this.jointMap.getSpineJointName(SpineJointName.SPINE_YAW), 0.0);
        this.setSetpoint(this.jointMap.getSpineJointName(SpineJointName.SPINE_PITCH), 0.0);
        this.setSetpoint(this.jointMap.getSpineJointName(SpineJointName.SPINE_ROLL), 0.0);
        for (RobotSide robotSide : RobotSide.values) {
            this.setSetpoint(robotSide, LegJointName.HIP_YAW, robotSide.negateIfRightSide(0.0));
            this.setSetpoint(robotSide, LegJointName.HIP_ROLL, robotSide.negateIfRightSide(0.062));
            this.setSetpoint(robotSide, LegJointName.HIP_PITCH, -0.233);
            this.setSetpoint(robotSide, LegJointName.KNEE_PITCH, 0.518);
            this.setSetpoint(robotSide, LegJointName.ANKLE_PITCH, -0.276);
            this.setSetpoint(robotSide, LegJointName.ANKLE_ROLL, robotSide.negateIfRightSide(-0.062));
            this.setSetpoint(robotSide, ArmJointName.SHOULDER_YAW, robotSide.negateIfRightSide(0.785398));
            this.setSetpoint(robotSide, ArmJointName.SHOULDER_ROLL, robotSide.negateIfRightSide(-0.52379));
            this.setSetpoint(robotSide, ArmJointName.ELBOW_PITCH, 2.33708);
            this.setSetpoint(robotSide, ArmJointName.ELBOW_ROLL, robotSide.negateIfRightSide(2.35619));
            this.setSetpoint(robotSide, ArmJointName.FIRST_WRIST_PITCH, -0.337807);
            this.setSetpoint(robotSide, ArmJointName.WRIST_ROLL, robotSide.negateIfRightSide(0.20773));
            this.setSetpoint(robotSide, ArmJointName.SECOND_WRIST_PITCH, -0.026599);
        }
    }

    private void setSetpoint(RobotSide robotSide, LegJointName legJointName, double value) {
        this.setSetpoint(this.jointMap.getLegJointName(robotSide, legJointName), value);
    }

    private void setSetpoint(RobotSide robotSide, ArmJointName armJointName, double value) {
        this.setSetpoint(this.jointMap.getArmJointName(robotSide, armJointName), value);
    }

    private void setSetpoint(String jointName, double value) {
        this.setPoints.put(jointName, value);
    }

    public double getSetpoint(String jointName) {
        if (this.setPoints.containsKey(jointName)) {
            return this.setPoints.get(jointName);
        }
        return 0.0;
    }
}

